/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.walk;

import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.processing.Processor;
import com.github.fge.jsonschema.processors.data.SchemaHolder;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.tree.SchemaTree;
import com.github.fge.jsonschema.util.ValueHolder;
import com.github.fge.jsonschema.walk.SchemaListener;
import com.github.fge.jsonschema.walk.SchemaListenerProvider;
import com.github.fge.jsonschema.walk.SchemaWalker;
import com.github.fge.jsonschema.walk.SchemaWalkerProvider;

public final class SchemaWalkerProcessor<T>
implements Processor<SchemaHolder, ValueHolder<T>> {
    private final SchemaWalkerProvider walkerProvider;
    private final SchemaListenerProvider<T> listenerProvider;

    public SchemaWalkerProcessor(SchemaWalkerProvider walkerProvider, SchemaListenerProvider<T> listenerProvider) {
        this.walkerProvider = walkerProvider;
        this.listenerProvider = listenerProvider;
    }

    @Override
    public ValueHolder<T> process(ProcessingReport report, SchemaHolder input) throws ProcessingException {
        SchemaWalker walker = this.walkerProvider.newWalker((SchemaTree)input.getValue());
        SchemaListener<T> listener = this.listenerProvider.newListener();
        walker.walk(listener, report);
        return ValueHolder.hold(listener.getValue());
    }
}

