/*
 * Decompiled with CFR 0.152.
 */
package com.felhr.usbserial;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbManager;
import com.annimon.stream.Optional;
import com.annimon.stream.Stream;
import com.felhr.usbserial.SerialPortCallback;
import com.felhr.usbserial.UsbSerialDevice;
import com.felhr.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class SerialPortBuilder {
    private static final String ACTION_USB_PERMISSION = "com.felhr.usbserial.USB_PERMISSION";
    private static final int MODE_START = 0;
    private static final int MODE_OPEN = 1;
    private static SerialPortBuilder SerialPortBuilder;
    private List<UsbDeviceStatus> devices;
    private List<UsbSerialDevice> serialDevices = new ArrayList<UsbSerialDevice>();
    private ArrayBlockingQueue<PendingUsbPermission> queuedPermissions = new ArrayBlockingQueue(100);
    private AtomicBoolean processingPermission = new AtomicBoolean(false);
    private PendingUsbPermission currentPendingPermission;
    private UsbManager usbManager;
    private SerialPortCallback serialPortCallback;
    private InitSerialPortThread initSerialPortThread;
    private int baudRate;
    private int dataBits;
    private int stopBits;
    private int parity;
    private int flowControl;
    private int mode = 0;
    private boolean broadcastRegistered = false;
    private final BroadcastReceiver usbReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals(com.felhr.usbserial.SerialPortBuilder.ACTION_USB_PERMISSION)) {
                boolean granted = intent.getExtras().getBoolean("permission");
                if (granted) {
                    SerialPortBuilder.this.createAllPorts(((SerialPortBuilder)SerialPortBuilder.this).currentPendingPermission.usbDeviceStatus);
                    if (SerialPortBuilder.this.queuedPermissions.size() > 0) {
                        SerialPortBuilder.this.launchPermission();
                    } else {
                        SerialPortBuilder.this.processingPermission.set(false);
                        if (SerialPortBuilder.this.mode == 0) {
                            SerialPortBuilder.this.serialPortCallback.onSerialPortsDetected(SerialPortBuilder.this.serialDevices);
                        } else {
                            SerialPortBuilder.this.initSerialPortThread = new InitSerialPortThread(SerialPortBuilder.this.serialDevices);
                            SerialPortBuilder.this.initSerialPortThread.start();
                        }
                    }
                } else if (SerialPortBuilder.this.queuedPermissions.size() > 0) {
                    SerialPortBuilder.this.launchPermission();
                } else {
                    SerialPortBuilder.this.processingPermission.set(false);
                    if (SerialPortBuilder.this.mode == 0) {
                        SerialPortBuilder.this.serialPortCallback.onSerialPortsDetected(SerialPortBuilder.this.serialDevices);
                    } else {
                        SerialPortBuilder.this.initSerialPortThread = new InitSerialPortThread(SerialPortBuilder.this.serialDevices);
                        SerialPortBuilder.this.initSerialPortThread.start();
                    }
                }
            }
        }
    };

    private SerialPortBuilder(SerialPortCallback serialPortCallback) {
        this.serialPortCallback = serialPortCallback;
    }

    public static SerialPortBuilder createSerialPortBuilder(SerialPortCallback serialPortCallback) {
        if (SerialPortBuilder == null) {
            SerialPortBuilder = new SerialPortBuilder(serialPortCallback);
            return SerialPortBuilder;
        }
        return SerialPortBuilder;
    }

    public List<UsbDevice> getPossibleSerialPorts(Context context) {
        this.usbManager = (UsbManager)context.getSystemService("usb");
        HashMap allDevices = this.usbManager.getDeviceList();
        List devices = Stream.of(allDevices.values()).filter(UsbSerialDevice::isSupported).toList();
        return devices;
    }

    public boolean getSerialPorts(Context context) {
        this.initReceiver(context);
        if (this.devices == null || this.devices.size() == 0) {
            this.devices = Stream.of(this.getPossibleSerialPorts(context)).map(x$0 -> new UsbDeviceStatus((UsbDevice)x$0)).toList();
            if (this.devices.size() == 0) {
                return false;
            }
            for (UsbDeviceStatus deviceStatus : this.devices) {
                this.queuedPermissions.add(this.createUsbPermission(context, deviceStatus));
            }
            if (!this.processingPermission.get()) {
                this.launchPermission();
            }
        } else {
            List newDevices = Stream.of(this.getPossibleSerialPorts(context)).map(x$0 -> new UsbDeviceStatus((UsbDevice)x$0)).filter(p -> !this.devices.contains(p)).toList();
            if (newDevices.size() == 0) {
                return false;
            }
            for (UsbDeviceStatus deviceStatus : newDevices) {
                this.queuedPermissions.add(this.createUsbPermission(context, deviceStatus));
            }
            this.devices.addAll(newDevices);
            if (!this.processingPermission.get()) {
                this.launchPermission();
            }
        }
        return true;
    }

    public boolean openSerialPorts(Context context, int baudRate, int dataBits, int stopBits, int parity, int flowControl) {
        this.baudRate = baudRate;
        this.dataBits = dataBits;
        this.stopBits = stopBits;
        this.parity = parity;
        this.flowControl = flowControl;
        this.mode = 1;
        return this.getSerialPorts(context);
    }

    public boolean disconnectDevice(UsbSerialDevice usbSerialDevice) {
        usbSerialDevice.syncClose();
        this.serialDevices = Utils.removeIf(this.serialDevices, p -> usbSerialDevice.getDeviceId() == p.getDeviceId());
        return true;
    }

    public boolean disconnectDevice(UsbDevice usbDevice) {
        Optional optionalDevice = Stream.of(this.serialDevices).filter(p -> usbDevice.getDeviceId() == p.getDeviceId()).findSingle();
        if (optionalDevice.isPresent()) {
            UsbSerialDevice disconnectedDevice = (UsbSerialDevice)optionalDevice.get();
            disconnectedDevice.syncClose();
            this.serialDevices = Utils.removeIf(this.serialDevices, p -> usbDevice.getDeviceId() == p.getDeviceId());
            return true;
        }
        return false;
    }

    public void unregisterListeners(Context context) {
        if (this.broadcastRegistered) {
            context.unregisterReceiver(this.usbReceiver);
            this.broadcastRegistered = false;
        }
    }

    private PendingUsbPermission createUsbPermission(Context context, UsbDeviceStatus usbDeviceStatus) {
        PendingIntent mPendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
        PendingUsbPermission pendingUsbPermission = new PendingUsbPermission();
        pendingUsbPermission.pendingIntent = mPendingIntent;
        pendingUsbPermission.usbDeviceStatus = usbDeviceStatus;
        return pendingUsbPermission;
    }

    private void launchPermission() {
        try {
            this.processingPermission.set(true);
            this.currentPendingPermission = this.queuedPermissions.take();
            this.usbManager.requestPermission(this.currentPendingPermission.usbDeviceStatus.usbDevice, this.currentPendingPermission.pendingIntent);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.processingPermission.set(false);
        }
    }

    private void initReceiver(Context context) {
        if (!this.broadcastRegistered) {
            IntentFilter filter = new IntentFilter();
            filter.addAction(ACTION_USB_PERMISSION);
            context.registerReceiver(this.usbReceiver, filter);
            this.broadcastRegistered = true;
        }
    }

    private void createAllPorts(UsbDeviceStatus usbDeviceStatus) {
        int interfaceCount = usbDeviceStatus.usbDevice.getInterfaceCount();
        for (int i = 0; i <= interfaceCount - 1; ++i) {
            if (usbDeviceStatus.usbDeviceConnection == null) {
                usbDeviceStatus.usbDeviceConnection = this.usbManager.openDevice(usbDeviceStatus.usbDevice);
            }
            UsbSerialDevice usbSerialDevice = UsbSerialDevice.createUsbSerialDevice(usbDeviceStatus.usbDevice, usbDeviceStatus.usbDeviceConnection, i);
            this.serialDevices.add(usbSerialDevice);
        }
    }

    private class PendingUsbPermission {
        public PendingIntent pendingIntent;
        public UsbDeviceStatus usbDeviceStatus;

        private PendingUsbPermission() {
        }
    }

    private class UsbDeviceStatus {
        public UsbDevice usbDevice;
        public UsbDeviceConnection usbDeviceConnection;
        public boolean open;

        public UsbDeviceStatus(UsbDevice usbDevice) {
            this.usbDevice = usbDevice;
        }

        public boolean equals(Object obj) {
            UsbDeviceStatus usbDeviceStatus = (UsbDeviceStatus)obj;
            return usbDeviceStatus.usbDevice.getDeviceId() == this.usbDevice.getDeviceId();
        }
    }

    private class InitSerialPortThread
    extends Thread {
        private List<UsbSerialDevice> usbSerialDevices;

        public InitSerialPortThread(List<UsbSerialDevice> usbSerialDevices) {
            this.usbSerialDevices = usbSerialDevices;
        }

        @Override
        public void run() {
            int n = 1;
            for (UsbSerialDevice usbSerialDevice : this.usbSerialDevices) {
                if (usbSerialDevice.isOpen || !usbSerialDevice.syncOpen()) continue;
                usbSerialDevice.setBaudRate(SerialPortBuilder.this.baudRate);
                usbSerialDevice.setDataBits(SerialPortBuilder.this.dataBits);
                usbSerialDevice.setStopBits(SerialPortBuilder.this.stopBits);
                usbSerialDevice.setParity(SerialPortBuilder.this.parity);
                usbSerialDevice.setFlowControl(SerialPortBuilder.this.flowControl);
                usbSerialDevice.setPortName("COM " + String.valueOf(n));
                ++n;
            }
            SerialPortBuilder.this.serialPortCallback.onSerialPortsDetected(SerialPortBuilder.this.serialDevices);
        }
    }
}

