/*
 * Decompiled with CFR 0.152.
 */
package me.toptas.fancyshowcase.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import androidx.core.content.ContextCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.toptas.fancyshowcase.R;
import me.toptas.fancyshowcase.internal.DeviceParams;
import me.toptas.fancyshowcase.internal.DeviceParamsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016J\b\u0010\u0010\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lme/toptas/fancyshowcase/internal/DeviceParamsImpl;", "Lme/toptas/fancyshowcase/internal/DeviceParams;", "activity", "Landroid/app/Activity;", "view", "Landroid/view/View;", "(Landroid/app/Activity;Landroid/view/View;)V", "metrics", "Landroid/util/DisplayMetrics;", "aboveAPI19", "", "currentBackgroundColor", "", "deviceHeight", "deviceWidth", "getStatusBarHeight", "isFullScreen", "fancyshowcaseview_release"})
public final class DeviceParamsImpl
implements DeviceParams {
    private final DisplayMetrics metrics;
    private final Activity activity;

    @Override
    public int currentBackgroundColor() {
        return ContextCompat.getColor((Context)((Context)this.activity), (int)R.color.fancy_showcase_view_default_background_color);
    }

    @Override
    public int deviceWidth() {
        return this.metrics.widthPixels;
    }

    @Override
    public int deviceHeight() {
        return this.metrics.heightPixels;
    }

    @Override
    public int getStatusBarHeight() {
        return DeviceParamsKt.getStatusBarHeight((Context)this.activity);
    }

    @Override
    public boolean isFullScreen() {
        Window window = this.activity.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activity.window");
        int windowFlags = window.getAttributes().flags;
        return (windowFlags & 0x400) != 0;
    }

    @Override
    public boolean aboveAPI19() {
        return Build.VERSION.SDK_INT >= 21;
    }

    public DeviceParamsImpl(@NotNull Activity activity, @NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.activity = activity;
        this.metrics = new DisplayMetrics();
        WindowManager windowManager = this.activity.getWindowManager();
        Intrinsics.checkNotNullExpressionValue((Object)windowManager, (String)"activity.windowManager");
        windowManager.getDefaultDisplay().getMetrics(this.metrics);
    }
}

