/*
 * Decompiled with CFR 0.152.
 */
package com.github.fabienbarbero.plugins.mkdocs;

import com.github.fabienbarbero.plugins.mkdocs.AbstractMkdocsMojo;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

@Mojo(name="build", defaultPhase=LifecyclePhase.PACKAGE)
public class MkdocsBuildMojo
extends AbstractMkdocsMojo {
    @Parameter(defaultValue="${project.build.directory}")
    private File projectBuildDir;
    @Parameter(readonly=true, defaultValue="${mojoExecution}")
    private MojoExecution mojoExecution;
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject project;
    @Component
    private MavenProjectHelper helper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            Path outputDir = this.projectBuildDir.toPath().resolve("mkdocs/" + this.mojoExecution.getExecutionId());
            if (Files.notExists(outputDir, new LinkOption[0])) {
                Files.createDirectories(outputDir, new FileAttribute[0]);
            }
            ArrayList<String> args = new ArrayList<String>();
            args.add("mkdocs");
            args.add("build");
            args.add("-f");
            args.add(this.configFile.getCanonicalPath());
            args.add("-d");
            args.add(outputDir.normalize().toString());
            if (this.getLog().isDebugEnabled()) {
                args.add("-v");
            }
            ProcessBuilder builder = new ProcessBuilder(args);
            builder.directory(this.configFile.getParentFile());
            Process proc = builder.start();
            this.dumpLogs(proc);
            int status = proc.waitFor();
            if (status != 0) {
                throw new MojoExecutionException("Mkdocs documentation generation has failed with status " + status);
            }
            this.getLog().info((CharSequence)("Documentation generated for " + this.mojoExecution.getExecutionId()));
            String archiveName = String.format("%s-%s-mkdocs-%s.zip", this.project.getArtifactId(), this.project.getVersion(), this.mojoExecution.getExecutionId());
            Path archiveFile = this.projectBuildDir.toPath().resolve(archiveName);
            this.compressDirectory(outputDir, archiveFile);
            this.helper.attachArtifact(this.project, "mkdocs", this.mojoExecution.getExecutionId(), archiveFile.toFile());
        }
        catch (IOException | InterruptedException ex) {
            throw new MojoExecutionException("Error building mkdocs documentation", ex);
        }
    }

    private void compressDirectory(Path inputDir, Path outputFile) throws IOException {
        final int startIndex = inputDir.normalize().toString().length();
        try (final ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(outputFile, new OpenOption[0]), StandardCharsets.UTF_8);){
            Files.walkFileTree(inputDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String entryName = file.normalize().toString().substring(startIndex);
                    zos.putNextEntry(new ZipEntry(entryName));
                    Files.copy(file, zos);
                    zos.closeEntry();
                    return FileVisitResult.CONTINUE;
                }
            });
            zos.flush();
        }
    }
}

