/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.standard;

import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.factory.AbstCombFactory;
import com.github.f4b6a3.uuid.factory.AbstRandomBasedFactory;
import com.github.f4b6a3.uuid.factory.UuidFactory;
import com.github.f4b6a3.uuid.util.internal.ByteUtil;
import java.time.Clock;
import java.time.Instant;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.LongSupplier;

public final class TimeOrderedEpochFactory
extends AbstCombFactory {
    private final UuidFunction uuidFunction;
    private static final int INCREMENT_TYPE_DEFAULT = 0;
    private static final int INCREMENT_TYPE_PLUS_1 = 1;
    private static final int INCREMENT_TYPE_PLUS_N = 2;
    private static final long INCREMENT_MAX_DEFAULT = 0xFFFFFFFFL;
    private static final long CLOCK_DRIFT_TOLERANCE = 10000L;
    private static final long versionBits = 61440L;
    private static final long variantBits = -4611686018427387904L;
    private static final long lower16Bits = 65535L;
    private static final long upper16Bits = -281474976710656L;

    public TimeOrderedEpochFactory() {
        this(TimeOrderedEpochFactory.builder());
    }

    public TimeOrderedEpochFactory(Clock clock) {
        this((Builder)TimeOrderedEpochFactory.builder().withClock(clock));
    }

    public TimeOrderedEpochFactory(Random random) {
        this((Builder)TimeOrderedEpochFactory.builder().withRandom(random));
    }

    public TimeOrderedEpochFactory(Random random, Clock clock) {
        this((Builder)((Builder)TimeOrderedEpochFactory.builder().withRandom(random)).withClock(clock));
    }

    public TimeOrderedEpochFactory(LongSupplier randomFunction) {
        this((Builder)TimeOrderedEpochFactory.builder().withRandomFunction(randomFunction));
    }

    public TimeOrderedEpochFactory(LongSupplier randomFunction, Clock clock) {
        this((Builder)((Builder)TimeOrderedEpochFactory.builder().withRandomFunction(randomFunction)).withClock(clock));
    }

    private TimeOrderedEpochFactory(Builder builder) {
        super(UuidVersion.VERSION_TIME_ORDERED_EPOCH, builder);
        switch (builder.getIncrementType()) {
            case 1: {
                this.uuidFunction = new Plus1Function(this.random, this.timeFunction);
                break;
            }
            case 2: {
                this.uuidFunction = new PlusNFunction(this.random, this.timeFunction, builder.getIncrementMax());
                break;
            }
            default: {
                this.uuidFunction = new DefaultFunction(this.random, this.timeFunction);
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public UUID create() {
        UUID uuid = this.uuidFunction.apply(null);
        return this.toUuid(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    @Override
    public UUID create(UuidFactory.Parameters parameters) {
        Objects.requireNonNull(parameters.getInstant(), "Null instant");
        UUID uuid = this.uuidFunction.apply(parameters.getInstant());
        return this.toUuid(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    static final class PlusNFunction
    extends UuidFunction {
        private final LongSupplier plusNFunction;

        public PlusNFunction(AbstRandomBasedFactory.IRandom random, LongSupplier timeFunction, Long incrementMax) {
            super(random, timeFunction);
            this.plusNFunction = this.customPlusNFunction(random, incrementMax);
        }

        @Override
        void increment() {
            this.lsb = (this.lsb | 0xC000000000000000L) + this.plusNFunction.getAsLong();
            if (this.lsb == 0L) {
                this.msb = (this.msb | 0xF000L) + 1L;
            }
        }

        private LongSupplier customPlusNFunction(AbstRandomBasedFactory.IRandom random, Long incrementMax) {
            if (incrementMax == 0xFFFFFFFFL) {
                if (random instanceof AbstRandomBasedFactory.SafeRandom) {
                    return () -> {
                        byte[] bytes = random.nextBytes(4);
                        return ByteUtil.toNumber(bytes, 0, 4) + 1L;
                    };
                }
                return () -> (random.nextLong() >>> 32) + 1L;
            }
            long positive = Long.MAX_VALUE;
            if (random instanceof AbstRandomBasedFactory.SafeRandom) {
                int bits = (int)Math.ceil(Math.log(incrementMax.longValue()) / Math.log(2.0));
                int size = (bits - 1) / 8 + 1;
                return () -> {
                    byte[] bytes = random.nextBytes(size);
                    long entropy = ByteUtil.toNumber(bytes, 0, size);
                    return (entropy & Long.MAX_VALUE) % incrementMax + 1L;
                };
            }
            return () -> (random.nextLong() & Long.MAX_VALUE) % incrementMax + 1L;
        }
    }

    static final class Plus1Function
    extends UuidFunction {
        public Plus1Function(AbstRandomBasedFactory.IRandom random, LongSupplier timeFunction) {
            super(random, timeFunction);
        }

        @Override
        void increment() {
            this.lsb = (this.lsb | 0xC000000000000000L) + 1L;
            if (this.lsb == 0L) {
                this.msb = (this.msb | 0xF000L) + 1L;
            }
        }
    }

    static final class DefaultFunction
    extends UuidFunction {
        public DefaultFunction(AbstRandomBasedFactory.IRandom random, LongSupplier timeFunction) {
            super(random, timeFunction);
        }

        @Override
        void increment() {
            this.lsb &= 0xFFFF000000000000L;
            this.lsb = (this.lsb | 0xC000000000000000L) + 0x1000000000000L;
            if (this.lsb == 0L) {
                this.msb = (this.msb | 0xF000L) + 1L;
            }
            if (this.random instanceof AbstRandomBasedFactory.SafeRandom) {
                byte[] bytes = this.random.nextBytes(6);
                this.lsb |= ByteUtil.toNumber(bytes);
            } else {
                this.lsb |= this.random.nextLong() & 0xFFFFFFFFFFFFL;
            }
        }
    }

    static abstract class UuidFunction
    implements Function<Instant, UUID> {
        protected long msb = 0L;
        protected long lsb = 0L;
        protected final AbstRandomBasedFactory.IRandom random;
        protected final LongSupplier timeFunction;
        protected final ReentrantLock lock = new ReentrantLock();
        protected static final long overflow = 0L;

        public UuidFunction(AbstRandomBasedFactory.IRandom random, LongSupplier timeFunction) {
            this.random = random;
            this.timeFunction = timeFunction;
            this.reset(this.timeFunction.getAsLong());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UUID apply(Instant instant) {
            this.lock.lock();
            try {
                if (instant != null) {
                    this.reset(instant.toEpochMilli());
                    UUID uUID = new UUID(this.msb, this.lsb);
                    return uUID;
                }
                long lastTime = this.time();
                long time = this.timeFunction.getAsLong();
                if (time > lastTime - 10000L && time <= lastTime) {
                    this.increment();
                } else {
                    this.reset(time);
                }
                UUID uUID = new UUID(this.msb, this.lsb);
                return uUID;
            }
            finally {
                this.lock.unlock();
            }
        }

        abstract void increment();

        long time() {
            return this.msb >>> 16;
        }

        void reset(long time) {
            if (this.random instanceof AbstRandomBasedFactory.SafeRandom) {
                byte[] bytes = this.random.nextBytes(10);
                this.msb = time << 16 | ByteUtil.toNumber(bytes, 0, 2);
                this.lsb = ByteUtil.toNumber(bytes, 2, 10);
            } else {
                this.msb = time << 16 | this.random.nextLong() & 0xFFFFL;
                this.lsb = this.random.nextLong();
            }
        }
    }

    public static class Builder
    extends AbstCombFactory.Builder<TimeOrderedEpochFactory, Builder> {
        private Integer incrementType;
        private Long incrementMax;

        public Builder withIncrementPlus1() {
            this.incrementType = 1;
            this.incrementMax = null;
            return this;
        }

        public Builder withIncrementPlusN() {
            this.incrementType = 2;
            this.incrementMax = null;
            return this;
        }

        public Builder withIncrementPlusN(long incrementMax) {
            this.incrementType = 2;
            this.incrementMax = incrementMax;
            return this;
        }

        protected int getIncrementType() {
            if (this.incrementType == null) {
                this.incrementType = 0;
            }
            return this.incrementType;
        }

        protected long getIncrementMax() {
            if (this.incrementMax == null) {
                this.incrementMax = 0xFFFFFFFFL;
            }
            return this.incrementMax;
        }

        @Override
        public TimeOrderedEpochFactory build() {
            return new TimeOrderedEpochFactory(this);
        }
    }
}

