/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.function.impl;

import com.github.f4b6a3.uuid.factory.function.ClockSeqFunction;
import java.util.concurrent.atomic.AtomicInteger;

public final class DefaultClockSeqFunction
implements ClockSeqFunction {
    private AtomicInteger sequence;
    private long lastTimestamp = -1L;
    protected static final ClockSeqFunction.ClockSeqPool POOL = new ClockSeqFunction.ClockSeqPool();

    public DefaultClockSeqFunction() {
        int initial = POOL.random();
        this.sequence = new AtomicInteger(initial);
    }

    @Override
    public long applyAsLong(long timestamp) {
        if (timestamp > this.lastTimestamp) {
            this.lastTimestamp = timestamp;
            return this.sequence.get();
        }
        this.lastTimestamp = timestamp;
        return this.next();
    }

    public int next() {
        if (this.sequence.incrementAndGet() > 16383) {
            this.sequence.set(0);
        }
        return this.sequence.updateAndGet(POOL::take);
    }
}

