/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.function.impl;

import com.github.f4b6a3.uuid.factory.function.TimeFunction;
import com.github.f4b6a3.uuid.util.internal.RandomUtil;

public final class WindowsTimeFunction
implements TimeFunction {
    private long prevTime = -1L;
    private static final long GRANULARITY = 16L;
    private static final long TICKS_PER_GRANULARITY = 160000L;
    private long counter = Math.abs(RandomUtil.nextLong() % 160000L);
    private long counterMax = this.counter + 160000L;

    @Override
    public long getAsLong() {
        ++this.counter;
        long time = WindowsTimeFunction.calculatedTimeMillis();
        if (time == this.prevTime) {
            if (this.counter >= this.counterMax) {
                while (time == WindowsTimeFunction.calculatedTimeMillis()) {
                }
            }
        } else {
            this.counter %= 160000L;
            this.counterMax = this.counter + 160000L;
        }
        this.prevTime = time;
        return time * 10000L + this.counter;
    }

    private static long calculatedTimeMillis() {
        long time = System.currentTimeMillis();
        return time + 16L - time % 16L;
    }
}

