/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.codec.base.function;

import com.github.f4b6a3.uuid.codec.base.BaseN;
import com.github.f4b6a3.uuid.codec.base.function.BaseNEncoder;
import java.util.UUID;

public final class BaseNRemainderEncoder
extends BaseNEncoder {
    private final int radix;
    private final int length;
    private final char padding;
    private static final int UUID_INTS = 4;
    private static final long HALF_LONG_MASK = 0xFFFFFFFFL;

    public BaseNRemainderEncoder(BaseN base) {
        super(base);
        this.radix = base.getRadix();
        this.length = base.getLength();
        this.padding = base.getPadding();
    }

    @Override
    public String apply(UUID uuid) {
        int[] number = new int[]{(int)(uuid.getMostSignificantBits() >>> 32), (int)(uuid.getMostSignificantBits() & 0xFFFFFFFFL), (int)(uuid.getLeastSignificantBits() >>> 32), (int)(uuid.getLeastSignificantBits() & 0xFFFFFFFFL)};
        char[] buffer = new char[this.length];
        int b = this.length;
        while (!this.isZero(number)) {
            int[] quotient = new int[4];
            int remainder = BaseNRemainderEncoder.remainder(number, this.radix, quotient);
            buffer[--b] = this.alphabet.get(remainder);
            number = quotient;
        }
        while (b > 0) {
            buffer[--b] = this.padding;
        }
        return new String(buffer);
    }

    protected static int remainder(int[] number, int divisor, int[] quotient) {
        long temporary = 0L;
        long remainder = 0L;
        for (int i = 0; i < 4; ++i) {
            temporary = remainder << 32 | (long)number[i] & 0xFFFFFFFFL;
            quotient[i] = (int)(temporary / (long)divisor);
            remainder = temporary % (long)divisor;
        }
        return (int)remainder;
    }

    private boolean isZero(int[] number) {
        return number[0] == 0 && number[1] == 0 && number[2] == 0 && number[3] == 0;
    }
}

