/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.codec.base.function;

import com.github.f4b6a3.uuid.codec.base.BaseN;
import com.github.f4b6a3.uuid.codec.base.function.BaseNDecoder;
import com.github.f4b6a3.uuid.exception.UuidCodecException;
import java.util.UUID;

public final class BaseNRemainderDecoder
extends BaseNDecoder {
    private final int radix;
    private static final int UUID_INTS = 4;
    private static final long HALF_LONG_MASK = 0xFFFFFFFFL;

    public BaseNRemainderDecoder(BaseN base) {
        super(base);
        this.radix = base.getRadix();
    }

    @Override
    public UUID apply(String string) {
        char[] chars = this.toCharArray(string);
        int[] number = new int[4];
        for (int i = 0; i < chars.length; ++i) {
            int remainder = (int)this.map.get(chars[i]);
            int[] product = BaseNRemainderDecoder.multiply(number, this.radix, remainder, true);
            number = product;
        }
        long msb = ((long)number[0] & 0xFFFFFFFFL) << 32 | (long)number[1] & 0xFFFFFFFFL;
        long lsb = ((long)number[2] & 0xFFFFFFFFL) << 32 | (long)number[3] & 0xFFFFFFFFL;
        return new UUID(msb, lsb);
    }

    protected static int[] multiply(int[] number, int multiplier, int addend, boolean validate) {
        long temporary = 0L;
        long overflow = addend;
        int[] product = new int[4];
        for (int i = 3; i >= 0; --i) {
            temporary = ((long)number[i] & 0xFFFFFFFFL) * (long)multiplier + overflow;
            product[i] = (int)temporary;
            overflow = temporary >>> 32;
        }
        if (validate && overflow != 0L) {
            throw new UuidCodecException("Invalid string (overflow)");
        }
        return product;
    }
}

