/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util.nonstandard;

import java.time.Instant;
import java.util.UUID;

public final class CombUtil {
    private CombUtil() {
    }

    public static long extractPrefix(UUID comb) {
        return comb.getMostSignificantBits() >>> 16;
    }

    public static long extractSuffix(UUID comb) {
        return comb.getLeastSignificantBits() & 0xFFFFFFFFFFFFL;
    }

    public static Instant extractPrefixInstant(UUID comb) {
        long milliseconds = CombUtil.extractPrefix(comb);
        return Instant.ofEpochMilli(milliseconds);
    }

    public static Instant extractSuffixInstant(UUID comb) {
        long milliseconds = CombUtil.extractSuffix(comb);
        return Instant.ofEpochMilli(milliseconds);
    }
}

