/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.strategy.clockseq;

import com.github.f4b6a3.uuid.strategy.ClockSequenceStrategy;
import com.github.f4b6a3.uuid.strategy.clockseq.ClockSequenceController;
import java.util.concurrent.atomic.AtomicInteger;

public final class DefaultClockSequenceStrategy
implements ClockSequenceStrategy {
    private AtomicInteger sequence;
    private long previousTimestamp = 0L;
    protected static final int SEQUENCE_MIN = 0;
    protected static final int SEQUENCE_MAX = 16383;
    protected static final ClockSequenceController CONTROLLER = new ClockSequenceController();

    public DefaultClockSequenceStrategy() {
        int initial = CONTROLLER.random();
        this.sequence = new AtomicInteger(initial);
    }

    @Override
    public int getClockSequence(long timestamp) {
        if (timestamp > this.previousTimestamp) {
            this.previousTimestamp = timestamp;
            return this.sequence.get();
        }
        this.previousTimestamp = timestamp;
        return this.next();
    }

    public int next() {
        if (this.sequence.incrementAndGet() > 16383) {
            this.sequence.set(0);
        }
        return this.sequence.updateAndGet(CONTROLLER::take);
    }
}

