/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.codec;

import com.github.f4b6a3.uuid.codec.UuidCodec;
import com.github.f4b6a3.uuid.exception.InvalidUuidException;
import com.github.f4b6a3.uuid.util.UuidValidator;
import java.util.UUID;

public class StringCodec
implements UuidCodec<String> {
    protected static final String URN_PREFIX = "urn:uuid:";
    protected static final char[] ALPHABET = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    protected static final long[] MAP = new long[128];
    private static final boolean JAVA_VERSION_GREATER_THAN_8;

    @Override
    public String encode(UUID uuid) {
        if (JAVA_VERSION_GREATER_THAN_8) {
            return uuid.toString();
        }
        char[] chars = new char[36];
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        chars[0] = ALPHABET[(int)(msb >>> 60 & 0xFL)];
        chars[1] = ALPHABET[(int)(msb >>> 56 & 0xFL)];
        chars[2] = ALPHABET[(int)(msb >>> 52 & 0xFL)];
        chars[3] = ALPHABET[(int)(msb >>> 48 & 0xFL)];
        chars[4] = ALPHABET[(int)(msb >>> 44 & 0xFL)];
        chars[5] = ALPHABET[(int)(msb >>> 40 & 0xFL)];
        chars[6] = ALPHABET[(int)(msb >>> 36 & 0xFL)];
        chars[7] = ALPHABET[(int)(msb >>> 32 & 0xFL)];
        chars[8] = 45;
        chars[9] = ALPHABET[(int)(msb >>> 28 & 0xFL)];
        chars[10] = ALPHABET[(int)(msb >>> 24 & 0xFL)];
        chars[11] = ALPHABET[(int)(msb >>> 20 & 0xFL)];
        chars[12] = ALPHABET[(int)(msb >>> 16 & 0xFL)];
        chars[13] = 45;
        chars[14] = ALPHABET[(int)(msb >>> 12 & 0xFL)];
        chars[15] = ALPHABET[(int)(msb >>> 8 & 0xFL)];
        chars[16] = ALPHABET[(int)(msb >>> 4 & 0xFL)];
        chars[17] = ALPHABET[(int)(msb & 0xFL)];
        chars[18] = 45;
        chars[19] = ALPHABET[(int)(lsb >>> 60 & 0xFL)];
        chars[20] = ALPHABET[(int)(lsb >>> 56 & 0xFL)];
        chars[21] = ALPHABET[(int)(lsb >>> 52 & 0xFL)];
        chars[22] = ALPHABET[(int)(lsb >>> 48 & 0xFL)];
        chars[23] = 45;
        chars[24] = ALPHABET[(int)(lsb >>> 44 & 0xFL)];
        chars[25] = ALPHABET[(int)(lsb >>> 40 & 0xFL)];
        chars[26] = ALPHABET[(int)(lsb >>> 36 & 0xFL)];
        chars[27] = ALPHABET[(int)(lsb >>> 32 & 0xFL)];
        chars[28] = ALPHABET[(int)(lsb >>> 28 & 0xFL)];
        chars[29] = ALPHABET[(int)(lsb >>> 24 & 0xFL)];
        chars[30] = ALPHABET[(int)(lsb >>> 20 & 0xFL)];
        chars[31] = ALPHABET[(int)(lsb >>> 16 & 0xFL)];
        chars[32] = ALPHABET[(int)(lsb >>> 12 & 0xFL)];
        chars[33] = ALPHABET[(int)(lsb >>> 8 & 0xFL)];
        chars[34] = ALPHABET[(int)(lsb >>> 4 & 0xFL)];
        chars[35] = ALPHABET[(int)(lsb & 0xFL)];
        return new String(chars);
    }

    @Override
    public UUID decode(String string) {
        if (string == null) {
            throw new InvalidUuidException("Invalid UUID: null");
        }
        char[] chars = string.toCharArray();
        if (chars.length != 32 && chars.length != 36) {
            char[] substring;
            if (string.startsWith(URN_PREFIX)) {
                substring = new char[chars.length - 9];
                System.arraycopy(chars, 9, substring, 0, substring.length);
                chars = substring;
            } else if (chars.length > 0 && chars[0] == '{' && chars[chars.length - 1] == '}') {
                substring = new char[chars.length - 2];
                System.arraycopy(chars, 1, substring, 0, substring.length);
                chars = substring;
            }
        }
        UuidValidator.validate(chars);
        long msb = 0L;
        long lsb = 0L;
        if (chars.length == 32) {
            msb |= MAP[chars[0]] << 60;
            msb |= MAP[chars[1]] << 56;
            msb |= MAP[chars[2]] << 52;
            msb |= MAP[chars[3]] << 48;
            msb |= MAP[chars[4]] << 44;
            msb |= MAP[chars[5]] << 40;
            msb |= MAP[chars[6]] << 36;
            msb |= MAP[chars[7]] << 32;
            msb |= MAP[chars[8]] << 28;
            msb |= MAP[chars[9]] << 24;
            msb |= MAP[chars[10]] << 20;
            msb |= MAP[chars[11]] << 16;
            msb |= MAP[chars[12]] << 12;
            msb |= MAP[chars[13]] << 8;
            msb |= MAP[chars[14]] << 4;
            msb |= MAP[chars[15]];
            lsb |= MAP[chars[16]] << 60;
            lsb |= MAP[chars[17]] << 56;
            lsb |= MAP[chars[18]] << 52;
            lsb |= MAP[chars[19]] << 48;
            lsb |= MAP[chars[20]] << 44;
            lsb |= MAP[chars[21]] << 40;
            lsb |= MAP[chars[22]] << 36;
            lsb |= MAP[chars[23]] << 32;
            lsb |= MAP[chars[24]] << 28;
            lsb |= MAP[chars[25]] << 24;
            lsb |= MAP[chars[26]] << 20;
            lsb |= MAP[chars[27]] << 16;
            lsb |= MAP[chars[28]] << 12;
            lsb |= MAP[chars[29]] << 8;
            lsb |= MAP[chars[30]] << 4;
            lsb |= MAP[chars[31]];
        } else {
            msb |= MAP[chars[0]] << 60;
            msb |= MAP[chars[1]] << 56;
            msb |= MAP[chars[2]] << 52;
            msb |= MAP[chars[3]] << 48;
            msb |= MAP[chars[4]] << 44;
            msb |= MAP[chars[5]] << 40;
            msb |= MAP[chars[6]] << 36;
            msb |= MAP[chars[7]] << 32;
            msb |= MAP[chars[9]] << 28;
            msb |= MAP[chars[10]] << 24;
            msb |= MAP[chars[11]] << 20;
            msb |= MAP[chars[12]] << 16;
            msb |= MAP[chars[14]] << 12;
            msb |= MAP[chars[15]] << 8;
            msb |= MAP[chars[16]] << 4;
            msb |= MAP[chars[17]];
            lsb |= MAP[chars[19]] << 60;
            lsb |= MAP[chars[20]] << 56;
            lsb |= MAP[chars[21]] << 52;
            lsb |= MAP[chars[22]] << 48;
            lsb |= MAP[chars[24]] << 44;
            lsb |= MAP[chars[25]] << 40;
            lsb |= MAP[chars[26]] << 36;
            lsb |= MAP[chars[27]] << 32;
            lsb |= MAP[chars[28]] << 28;
            lsb |= MAP[chars[29]] << 24;
            lsb |= MAP[chars[30]] << 20;
            lsb |= MAP[chars[31]] << 16;
            lsb |= MAP[chars[32]] << 12;
            lsb |= MAP[chars[33]] << 8;
            lsb |= MAP[chars[34]] << 4;
            lsb |= MAP[chars[35]];
        }
        return new UUID(msb, lsb);
    }

    protected static int getJavaVersion() {
        try {
            String[] version = System.getProperty("java.version").split("\\.");
            if (version[0].equals("1")) {
                return Integer.parseInt(version[1]);
            }
            return Integer.parseInt(version[0]);
        }
        catch (IndexOutOfBoundsException | NullPointerException | NumberFormatException e) {
            return 8;
        }
    }

    static {
        for (int i = 0; i < MAP.length; ++i) {
            StringCodec.MAP[i] = -1L;
        }
        StringCodec.MAP[48] = 0L;
        StringCodec.MAP[49] = 1L;
        StringCodec.MAP[50] = 2L;
        StringCodec.MAP[51] = 3L;
        StringCodec.MAP[52] = 4L;
        StringCodec.MAP[53] = 5L;
        StringCodec.MAP[54] = 6L;
        StringCodec.MAP[55] = 7L;
        StringCodec.MAP[56] = 8L;
        StringCodec.MAP[57] = 9L;
        StringCodec.MAP[97] = 10L;
        StringCodec.MAP[98] = 11L;
        StringCodec.MAP[99] = 12L;
        StringCodec.MAP[100] = 13L;
        StringCodec.MAP[101] = 14L;
        StringCodec.MAP[102] = 15L;
        StringCodec.MAP[65] = 10L;
        StringCodec.MAP[66] = 11L;
        StringCodec.MAP[67] = 12L;
        StringCodec.MAP[68] = 13L;
        StringCodec.MAP[69] = 14L;
        StringCodec.MAP[70] = 15L;
        JAVA_VERSION_GREATER_THAN_8 = StringCodec.getJavaVersion() > 8;
    }
}

