/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.codec.base;

import com.github.f4b6a3.uuid.codec.UuidCodec;
import com.github.f4b6a3.uuid.codec.base.BaseN;
import com.github.f4b6a3.uuid.codec.base.BaseNAlphabet;
import com.github.f4b6a3.uuid.codec.base.function.Base16Decoder;
import com.github.f4b6a3.uuid.codec.base.function.Base16Encoder;
import com.github.f4b6a3.uuid.codec.base.function.Base32Decoder;
import com.github.f4b6a3.uuid.codec.base.function.Base32Encoder;
import com.github.f4b6a3.uuid.codec.base.function.Base64Decoder;
import com.github.f4b6a3.uuid.codec.base.function.Base64Encoder;
import com.github.f4b6a3.uuid.exception.UuidCodecException;
import java.util.UUID;
import java.util.function.Function;

public abstract class BaseNCodec
implements UuidCodec<String> {
    protected final BaseN base;
    protected final String alphabet;
    protected final Function<UUID, String> encoder;
    protected final Function<String, UUID> decoder;

    protected BaseNCodec(BaseNAlphabet baseNAlphabet) {
        this(baseNAlphabet.getBase(), baseNAlphabet.getAlphabet());
    }

    public BaseNCodec(BaseN base, String alphabet) {
        if (alphabet.length() != base.getNumber()) {
            throw new IllegalArgumentException(String.format("Invalid alphabet length: %s", alphabet.length()));
        }
        this.base = base;
        this.alphabet = alphabet;
        switch (base) {
            case BASE_16: {
                this.encoder = new Base16Encoder(this.alphabet);
                this.decoder = new Base16Decoder(this.alphabet);
                break;
            }
            case BASE_32: {
                this.encoder = new Base32Encoder(this.alphabet);
                this.decoder = new Base32Decoder(this.alphabet);
                break;
            }
            case BASE_64: {
                this.encoder = new Base64Encoder(this.alphabet);
                this.decoder = new Base64Decoder(this.alphabet);
                break;
            }
            default: {
                throw new UuidCodecException("Unsupported base-n");
            }
        }
    }

    @Override
    public String encode(UUID uuid) {
        return this.encoder.apply(uuid);
    }

    @Override
    public UUID decode(String string) {
        return this.decoder.apply(string);
    }

    public BaseN getBase() {
        return this.base;
    }

    public String getAlphabet() {
        return this.alphabet;
    }
}

