/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.strategy.timestamp;

import com.github.f4b6a3.uuid.strategy.TimestampStrategy;
import com.github.f4b6a3.uuid.util.UuidTime;
import com.github.f4b6a3.uuid.util.internal.SharedRandom;

public final class DefaultTimestampStrategy
implements TimestampStrategy {
    private long counter = SharedRandom.nextLong() & 0xFFL;
    private long prevTime = UuidTime.getCurrentTimestamp();
    private long prevTick = System.nanoTime() / 100L;
    private static final long COUNTER_LIMIT = 10000L;
    private static final long COUNTER_RESET = 255L;
    private static final long TICK_UNIT = 100L;

    @Override
    public long getTimestamp() {
        long time = UuidTime.getCurrentTimestamp();
        long tick = System.nanoTime() / 100L;
        if (time == this.prevTime) {
            long elapsed = tick - this.prevTick;
            this.counter = elapsed > 1L && elapsed < 10000L - this.counter ? (this.counter += elapsed) : ++this.counter;
            if (this.counter >= 10000L) {
                while (time == UuidTime.getCurrentTimestamp()) {
                }
            }
        } else {
            ++this.counter;
            this.counter &= 0xFFL;
        }
        this.prevTime = time;
        this.prevTick = tick;
        return time + this.counter;
    }
}

