/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util;

import com.github.f4b6a3.uuid.util.UuidUtil;
import com.github.f4b6a3.uuid.util.UuidValidator;
import java.util.UUID;

public final class UuidConverter {
    private static final String URN_PREFIX = "urn:uuid:";
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final long[] HEX_VALUES = new long[128];

    private UuidConverter() {
    }

    public static byte[] toBytes(UUID uuid) {
        byte[] bytes = new byte[16];
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        bytes[0] = (byte)(msb >>> 56);
        bytes[1] = (byte)(msb >>> 48);
        bytes[2] = (byte)(msb >>> 40);
        bytes[3] = (byte)(msb >>> 32);
        bytes[4] = (byte)(msb >>> 24);
        bytes[5] = (byte)(msb >>> 16);
        bytes[6] = (byte)(msb >>> 8);
        bytes[7] = (byte)msb;
        bytes[8] = (byte)(lsb >>> 56);
        bytes[9] = (byte)(lsb >>> 48);
        bytes[10] = (byte)(lsb >>> 40);
        bytes[11] = (byte)(lsb >>> 32);
        bytes[12] = (byte)(lsb >>> 24);
        bytes[13] = (byte)(lsb >>> 16);
        bytes[14] = (byte)(lsb >>> 8);
        bytes[15] = (byte)lsb;
        return bytes;
    }

    public static UUID fromBytes(byte[] bytes) {
        UuidValidator.validate(bytes);
        long msb = 0L;
        long lsb = 0L;
        msb |= ((long)bytes[0] & 0xFFL) << 56;
        msb |= ((long)bytes[1] & 0xFFL) << 48;
        msb |= ((long)bytes[2] & 0xFFL) << 40;
        msb |= ((long)bytes[3] & 0xFFL) << 32;
        msb |= ((long)bytes[4] & 0xFFL) << 24;
        msb |= ((long)bytes[5] & 0xFFL) << 16;
        msb |= ((long)bytes[6] & 0xFFL) << 8;
        msb |= (long)bytes[7] & 0xFFL;
        lsb |= ((long)bytes[8] & 0xFFL) << 56;
        lsb |= ((long)bytes[9] & 0xFFL) << 48;
        lsb |= ((long)bytes[10] & 0xFFL) << 40;
        lsb |= ((long)bytes[11] & 0xFFL) << 32;
        lsb |= ((long)bytes[12] & 0xFFL) << 24;
        lsb |= ((long)bytes[13] & 0xFFL) << 16;
        lsb |= ((long)bytes[14] & 0xFFL) << 8;
        return new UUID(msb, lsb |= (long)bytes[15] & 0xFFL);
    }

    public static String toString(UUID uuid) {
        char[] chars = new char[36];
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        chars[0] = HEX_CHARS[(int)(msb >>> 60 & 0xFL)];
        chars[1] = HEX_CHARS[(int)(msb >>> 56 & 0xFL)];
        chars[2] = HEX_CHARS[(int)(msb >>> 52 & 0xFL)];
        chars[3] = HEX_CHARS[(int)(msb >>> 48 & 0xFL)];
        chars[4] = HEX_CHARS[(int)(msb >>> 44 & 0xFL)];
        chars[5] = HEX_CHARS[(int)(msb >>> 40 & 0xFL)];
        chars[6] = HEX_CHARS[(int)(msb >>> 36 & 0xFL)];
        chars[7] = HEX_CHARS[(int)(msb >>> 32 & 0xFL)];
        chars[8] = 45;
        chars[9] = HEX_CHARS[(int)(msb >>> 28 & 0xFL)];
        chars[10] = HEX_CHARS[(int)(msb >>> 24 & 0xFL)];
        chars[11] = HEX_CHARS[(int)(msb >>> 20 & 0xFL)];
        chars[12] = HEX_CHARS[(int)(msb >>> 16 & 0xFL)];
        chars[13] = 45;
        chars[14] = HEX_CHARS[(int)(msb >>> 12 & 0xFL)];
        chars[15] = HEX_CHARS[(int)(msb >>> 8 & 0xFL)];
        chars[16] = HEX_CHARS[(int)(msb >>> 4 & 0xFL)];
        chars[17] = HEX_CHARS[(int)(msb & 0xFL)];
        chars[18] = 45;
        chars[19] = HEX_CHARS[(int)(lsb >>> 60 & 0xFL)];
        chars[20] = HEX_CHARS[(int)(lsb >>> 56 & 0xFL)];
        chars[21] = HEX_CHARS[(int)(lsb >>> 52 & 0xFL)];
        chars[22] = HEX_CHARS[(int)(lsb >>> 48 & 0xFL)];
        chars[23] = 45;
        chars[24] = HEX_CHARS[(int)(lsb >>> 44 & 0xFL)];
        chars[25] = HEX_CHARS[(int)(lsb >>> 40 & 0xFL)];
        chars[26] = HEX_CHARS[(int)(lsb >>> 36 & 0xFL)];
        chars[27] = HEX_CHARS[(int)(lsb >>> 32 & 0xFL)];
        chars[28] = HEX_CHARS[(int)(lsb >>> 28 & 0xFL)];
        chars[29] = HEX_CHARS[(int)(lsb >>> 24 & 0xFL)];
        chars[30] = HEX_CHARS[(int)(lsb >>> 20 & 0xFL)];
        chars[31] = HEX_CHARS[(int)(lsb >>> 16 & 0xFL)];
        chars[32] = HEX_CHARS[(int)(lsb >>> 12 & 0xFL)];
        chars[33] = HEX_CHARS[(int)(lsb >>> 8 & 0xFL)];
        chars[34] = HEX_CHARS[(int)(lsb >>> 4 & 0xFL)];
        chars[35] = HEX_CHARS[(int)(lsb & 0xFL)];
        return new String(chars);
    }

    public static UUID fromString(String string) {
        long msb = 0L;
        long lsb = 0L;
        char[] chars = string.toCharArray();
        if (chars[0] == 'u' && string.indexOf(URN_PREFIX) == 0) {
            char[] substring = new char[chars.length - 9];
            System.arraycopy(chars, 9, substring, 0, substring.length);
            chars = substring;
        } else if (chars[0] == '{' && chars[chars.length - 1] == '}') {
            char[] substring = new char[chars.length - 2];
            System.arraycopy(chars, 1, substring, 0, substring.length);
            chars = substring;
        }
        UuidValidator.validate(chars);
        if (chars.length == 32) {
            msb |= HEX_VALUES[chars[0]] << 60;
            msb |= HEX_VALUES[chars[1]] << 56;
            msb |= HEX_VALUES[chars[2]] << 52;
            msb |= HEX_VALUES[chars[3]] << 48;
            msb |= HEX_VALUES[chars[4]] << 44;
            msb |= HEX_VALUES[chars[5]] << 40;
            msb |= HEX_VALUES[chars[6]] << 36;
            msb |= HEX_VALUES[chars[7]] << 32;
            msb |= HEX_VALUES[chars[8]] << 28;
            msb |= HEX_VALUES[chars[9]] << 24;
            msb |= HEX_VALUES[chars[10]] << 20;
            msb |= HEX_VALUES[chars[11]] << 16;
            msb |= HEX_VALUES[chars[12]] << 12;
            msb |= HEX_VALUES[chars[13]] << 8;
            msb |= HEX_VALUES[chars[14]] << 4;
            msb |= HEX_VALUES[chars[15]];
            lsb |= HEX_VALUES[chars[16]] << 60;
            lsb |= HEX_VALUES[chars[17]] << 56;
            lsb |= HEX_VALUES[chars[18]] << 52;
            lsb |= HEX_VALUES[chars[19]] << 48;
            lsb |= HEX_VALUES[chars[20]] << 44;
            lsb |= HEX_VALUES[chars[21]] << 40;
            lsb |= HEX_VALUES[chars[22]] << 36;
            lsb |= HEX_VALUES[chars[23]] << 32;
            lsb |= HEX_VALUES[chars[24]] << 28;
            lsb |= HEX_VALUES[chars[25]] << 24;
            lsb |= HEX_VALUES[chars[26]] << 20;
            lsb |= HEX_VALUES[chars[27]] << 16;
            lsb |= HEX_VALUES[chars[28]] << 12;
            lsb |= HEX_VALUES[chars[29]] << 8;
            lsb |= HEX_VALUES[chars[30]] << 4;
            lsb |= HEX_VALUES[chars[31]];
        } else {
            msb |= HEX_VALUES[chars[0]] << 60;
            msb |= HEX_VALUES[chars[1]] << 56;
            msb |= HEX_VALUES[chars[2]] << 52;
            msb |= HEX_VALUES[chars[3]] << 48;
            msb |= HEX_VALUES[chars[4]] << 44;
            msb |= HEX_VALUES[chars[5]] << 40;
            msb |= HEX_VALUES[chars[6]] << 36;
            msb |= HEX_VALUES[chars[7]] << 32;
            msb |= HEX_VALUES[chars[9]] << 28;
            msb |= HEX_VALUES[chars[10]] << 24;
            msb |= HEX_VALUES[chars[11]] << 20;
            msb |= HEX_VALUES[chars[12]] << 16;
            msb |= HEX_VALUES[chars[14]] << 12;
            msb |= HEX_VALUES[chars[15]] << 8;
            msb |= HEX_VALUES[chars[16]] << 4;
            msb |= HEX_VALUES[chars[17]];
            lsb |= HEX_VALUES[chars[19]] << 60;
            lsb |= HEX_VALUES[chars[20]] << 56;
            lsb |= HEX_VALUES[chars[21]] << 52;
            lsb |= HEX_VALUES[chars[22]] << 48;
            lsb |= HEX_VALUES[chars[24]] << 44;
            lsb |= HEX_VALUES[chars[25]] << 40;
            lsb |= HEX_VALUES[chars[26]] << 36;
            lsb |= HEX_VALUES[chars[27]] << 32;
            lsb |= HEX_VALUES[chars[28]] << 28;
            lsb |= HEX_VALUES[chars[29]] << 24;
            lsb |= HEX_VALUES[chars[30]] << 20;
            lsb |= HEX_VALUES[chars[31]] << 16;
            lsb |= HEX_VALUES[chars[32]] << 12;
            lsb |= HEX_VALUES[chars[33]] << 8;
            lsb |= HEX_VALUES[chars[34]] << 4;
            lsb |= HEX_VALUES[chars[35]];
        }
        return new UUID(msb, lsb);
    }

    public static UUID toTimeBasedUuid(UUID uuid) {
        if (!UuidUtil.isTimeOrdered(uuid)) {
            throw new IllegalArgumentException(String.format("Not a time-ordered UUID: %s.", uuid.toString()));
        }
        long timestamp = UuidUtil.extractTimestamp(uuid);
        long msb = (timestamp & 0xFFF000000000000L) >>> 48 | (timestamp & 0xFFFF00000000L) >>> 16 | (timestamp & 0xFFFFFFFFL) << 32 | 0x1000L;
        long lsb = uuid.getLeastSignificantBits();
        return new UUID(msb, lsb);
    }

    public static UUID toTimeOrderedUuid(UUID uuid) {
        if (!UuidUtil.isTimeBased(uuid)) {
            throw new IllegalArgumentException(String.format("Not a time-based UUID: %s.", uuid.toString()));
        }
        long timestamp = UuidUtil.extractTimestamp(uuid);
        long msb = (timestamp & 0xFFFFFFFFFFFF000L) << 4 | timestamp & 0xFFFL | 0x6000L;
        long lsb = uuid.getLeastSignificantBits();
        return new UUID(msb, lsb);
    }

    public static UUID toAndFromMsGuid(UUID uuid) {
        long msb = UuidConverter.toAndFromMsGuidMostSignificantBits(uuid.getMostSignificantBits());
        long lsb = uuid.getLeastSignificantBits();
        return new UUID(msb, lsb);
    }

    private static long toAndFromMsGuidMostSignificantBits(long msb) {
        long bits = 0L;
        bits |= (msb & 0xFF00000000000000L) >>> 24;
        bits |= (msb & 0xFF000000000000L) >>> 8;
        bits |= (msb & 0xFF0000000000L) << 8;
        bits |= (msb & 0xFF00000000L) << 24;
        bits |= (msb & 0xFF000000L) >>> 8;
        bits |= (msb & 0xFF0000L) << 8;
        bits |= (msb & 0xFF00L) >>> 8;
        return bits |= (msb & 0xFFL) << 8;
    }

    static {
        UuidConverter.HEX_VALUES[48] = 0L;
        UuidConverter.HEX_VALUES[49] = 1L;
        UuidConverter.HEX_VALUES[50] = 2L;
        UuidConverter.HEX_VALUES[51] = 3L;
        UuidConverter.HEX_VALUES[52] = 4L;
        UuidConverter.HEX_VALUES[53] = 5L;
        UuidConverter.HEX_VALUES[54] = 6L;
        UuidConverter.HEX_VALUES[55] = 7L;
        UuidConverter.HEX_VALUES[56] = 8L;
        UuidConverter.HEX_VALUES[57] = 9L;
        UuidConverter.HEX_VALUES[97] = 10L;
        UuidConverter.HEX_VALUES[98] = 11L;
        UuidConverter.HEX_VALUES[99] = 12L;
        UuidConverter.HEX_VALUES[100] = 13L;
        UuidConverter.HEX_VALUES[101] = 14L;
        UuidConverter.HEX_VALUES[102] = 15L;
        UuidConverter.HEX_VALUES[65] = 10L;
        UuidConverter.HEX_VALUES[66] = 11L;
        UuidConverter.HEX_VALUES[67] = 12L;
        UuidConverter.HEX_VALUES[68] = 13L;
        UuidConverter.HEX_VALUES[69] = 14L;
        UuidConverter.HEX_VALUES[70] = 15L;
    }
}

