/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.strategy.nodeid;

import com.github.f4b6a3.uuid.strategy.NodeIdentifierStrategy;
import com.github.f4b6a3.uuid.util.internal.ByteUtil;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public final class MacNodeIdentifierStrategy
implements NodeIdentifierStrategy {
    private final long nodeIdentifier = this.getHardwareAddress();

    @Override
    public long getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    private long getHardwareAddress() {
        try {
            InetAddress ip = InetAddress.getLocalHost();
            NetworkInterface nic = NetworkInterface.getByInetAddress(ip);
            if (nic != null) {
                byte[] mac = nic.getHardwareAddress();
                if (!nic.isLoopback() && mac != null && mac.length == 6) {
                    return ByteUtil.toNumber(mac);
                }
            }
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements()) {
                byte[] mac;
                NetworkInterface next = nics.nextElement();
                if (next == null || next.isLoopback() || (mac = next.getHardwareAddress()) == null || mac.length != 6) continue;
                return ByteUtil.toNumber(mac);
            }
        }
        catch (SocketException | UnknownHostException iOException) {
            // empty catch block
        }
        return NodeIdentifierStrategy.getRandomNodeIdentifier();
    }
}

