/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util;

import com.github.f4b6a3.uuid.exception.IllegalUuidException;
import com.github.f4b6a3.uuid.util.ByteUtil;
import com.github.f4b6a3.uuid.util.UuidUtil;
import com.github.f4b6a3.uuid.util.UuidValidator;
import java.util.UUID;

public class UuidConverter {
    private UuidConverter() {
    }

    public static byte[] toBytes(UUID uuid) {
        return ByteUtil.toBytes(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public static UUID fromBytes(byte[] bytes) {
        UuidValidator.validate(bytes);
        long msb = ByteUtil.toNumber(bytes, 0, 8);
        long lsb = ByteUtil.toNumber(bytes, 8, 16);
        return new UUID(msb, lsb);
    }

    public static String toString(UUID uuid) {
        char[] input = ByteUtil.toHexadecimalChars(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
        char[] output = new char[36];
        System.arraycopy(input, 0, output, 0, 8);
        System.arraycopy(input, 8, output, 9, 4);
        System.arraycopy(input, 12, output, 14, 4);
        System.arraycopy(input, 16, output, 19, 4);
        System.arraycopy(input, 20, output, 24, 12);
        output[8] = 45;
        output[13] = 45;
        output[18] = 45;
        output[23] = 45;
        return new String(output);
    }

    public static UUID fromString(String uuid) {
        UuidValidator.validate(uuid);
        char[] input = uuid.toCharArray();
        char[] output = new char[32];
        int o = 0;
        for (int i = 0; i < input.length; ++i) {
            if (input[i] == '-') continue;
            output[o++] = input[i];
        }
        return UuidConverter.fromBytes(ByteUtil.toBytes(output));
    }

    public static UUID toTimeBasedUuid(UUID uuid) {
        if (!UuidUtil.isTimeOrdered(uuid)) {
            throw new IllegalUuidException(String.format("Not a time-ordered UUID: %s.", uuid.toString()));
        }
        long timestamp = UuidUtil.extractTimestamp(uuid);
        long msb = (timestamp & 0xFFF000000000000L) >>> 48 | (timestamp & 0xFFFF00000000L) >>> 16 | (timestamp & 0xFFFFFFFFL) << 32 | 0x1000L;
        long lsb = uuid.getLeastSignificantBits();
        return new UUID(msb, lsb);
    }

    public static UUID toTimeOrderedUuid(UUID uuid) {
        if (!UuidUtil.isTimeBased(uuid)) {
            throw new IllegalUuidException(String.format("Not a time-based UUID: %s.", uuid.toString()));
        }
        long timestamp = UuidUtil.extractTimestamp(uuid);
        long msb = (timestamp & 0xFFFFFFFFFFFF000L) << 4 | timestamp & 0xFFFL | 0x6000L;
        long lsb = uuid.getLeastSignificantBits();
        return new UUID(msb, lsb);
    }

    public static UUID toAndFromMsGuid(UUID uuid) {
        long msb = UuidConverter.toAndFromMsGuidMostSignificantBits(uuid.getMostSignificantBits());
        long lsb = uuid.getLeastSignificantBits();
        return new UUID(msb, lsb);
    }

    private static long toAndFromMsGuidMostSignificantBits(long msb) {
        long bits = 0L;
        bits |= (msb & 0xFF00000000000000L) >>> 24;
        bits |= (msb & 0xFF000000000000L) >>> 8;
        bits |= (msb & 0xFF0000000000L) << 8;
        bits |= (msb & 0xFF00000000L) << 24;
        bits |= (msb & 0xFF000000L) >>> 8;
        bits |= (msb & 0xFF0000L) << 8;
        bits |= (msb & 0xFF00L) >>> 8;
        return bits |= (msb & 0xFFL) << 8;
    }
}

