/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.creator.nonstandard;

import com.github.f4b6a3.uuid.creator.AbstractRandomBasedUuidCreator;
import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.util.ByteUtil;
import com.github.f4b6a3.uuid.util.RandomUtil;
import java.security.SecureRandom;
import java.util.UUID;

public class PrefixCombCreator
extends AbstractRandomBasedUuidCreator {
    public PrefixCombCreator() {
        super(UuidVersion.VERSION_RANDOM_BASED);
    }

    @Override
    public synchronized UUID create() {
        long lsb;
        long msb;
        long timestamp = System.currentTimeMillis();
        if (this.random == null) {
            byte[] bytes = new byte[10];
            RandomUtil.get().nextBytes(bytes);
            msb = bytes[8] << 8 | bytes[9] & 0xFF;
            lsb = ByteUtil.toNumber(bytes, 0, 8);
        } else if (this.random instanceof SecureRandom) {
            byte[] bytes = new byte[10];
            this.random.nextBytes(bytes);
            msb = bytes[8] << 8 | bytes[9] & 0xFF;
            lsb = ByteUtil.toNumber(bytes, 0, 8);
        } else {
            msb = this.random.nextLong();
            lsb = this.random.nextLong();
        }
        msb = msb & 0xFFFFL | (timestamp & 0xFFFFFFFFFFFFL) << 16;
        return new UUID(this.applyVersionBits(msb), this.applyVariantBits(lsb));
    }
}

