/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;

public class TimestampUtil {
    public static final long GREGORIAN_MILLISECONDS = TimestampUtil.getGregorianEpochMilliseconds();
    public static final long MILLISECONDS_PER_SECOND = 1000L;
    public static final long TIMESTAMP_RESOLUTION = 10000L;

    private TimestampUtil() {
    }

    public static long getCurrentTimestamp() {
        return (System.currentTimeMillis() - GREGORIAN_MILLISECONDS) * 10000L;
    }

    public static long toTimestamp(Instant instant) {
        return (instant.toEpochMilli() - GREGORIAN_MILLISECONDS) * 10000L;
    }

    public static Instant toInstant(long timestamp) {
        return Instant.ofEpochMilli(timestamp / 10000L + GREGORIAN_MILLISECONDS);
    }

    private static long getGregorianEpochMilliseconds() {
        return LocalDate.parse("1582-10-15").atStartOfDay(ZoneId.of("UTC")).toInstant().getEpochSecond() * 1000L;
    }
}

