/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory;

import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.factory.abst.AbstractUuidCreator;
import com.github.f4b6a3.uuid.random.Xorshift128PlusRandom;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import java.util.UUID;

public class RandomUuidCreator
extends AbstractUuidCreator {
    private Random random = RandomUuidCreator.getSecureRandom();

    public RandomUuidCreator() {
        super(UuidVersion.RANDOM_BASED);
    }

    public UUID create() {
        long msb = this.random.nextLong();
        long lsb = this.random.nextLong();
        msb = this.setVersionBits(msb);
        lsb = this.setVariantBits(lsb);
        return new UUID(msb, lsb);
    }

    public RandomUuidCreator withRandomGenerator(Random random) {
        this.random = random;
        return this;
    }

    public RandomUuidCreator withFastRandomGenerator() {
        this.random = new Xorshift128PlusRandom();
        return this;
    }

    private static SecureRandom getSecureRandom() {
        try {
            return SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            return new SecureRandom();
        }
    }
}

