/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.clockseq;

import com.github.f4b6a3.uuid.clockseq.ClockSequenceStrategy;
import com.github.f4b6a3.uuid.exception.OverrunException;
import com.github.f4b6a3.uuid.sequence.AbstractSequence;
import com.github.f4b6a3.uuid.state.AbstractUuidState;
import com.github.f4b6a3.uuid.state.FileUuidState;
import com.github.f4b6a3.uuid.util.RandomUtil;
import com.github.f4b6a3.uuid.util.SettingsUtil;

public class DefaultClockSequenceStrategy
extends AbstractSequence
implements ClockSequenceStrategy {
    private long timestamp = 0L;
    private long nodeIdentifier = 0L;
    private int counter = 0;
    private static Balancer balancer;
    protected AbstractUuidState state;
    protected static final int SEQUENCE_MIN = 0;
    protected static final int SEQUENCE_MAX = 16383;

    public DefaultClockSequenceStrategy(long timestamp, long nodeIdentifier, AbstractUuidState state) {
        super(0, 16383);
        this.timestamp = timestamp;
        this.nodeIdentifier = nodeIdentifier;
        if (balancer == null) {
            balancer = new Balancer(16383);
        }
        if (SettingsUtil.isStateEnabled()) {
            this.addShutdownHook();
            this.state = state;
            if (this.state == null) {
                this.state = new FileUuidState();
            }
            if (!this.state.isValid()) {
                this.reset();
                return;
            }
            long lastTimestamp = this.state.getTimestamp();
            long lastNodeIdentifier = this.state.getNodeIdentifier();
            int lastClockSequence = this.state.getClockSequence();
            this.set(lastClockSequence);
            if (this.timestamp <= lastTimestamp || this.nodeIdentifier != lastNodeIdentifier) {
                this.next();
            }
        } else {
            this.reset();
        }
    }

    public DefaultClockSequenceStrategy(long timestamp, long nodeIdentifier) {
        this(timestamp, nodeIdentifier, null);
    }

    public DefaultClockSequenceStrategy() {
        this(0L, 0L, null);
    }

    @Override
    public int getClockSequence(long timestamp, long nodeIdentifier) {
        if (timestamp <= this.timestamp) {
            if (this.counter >= 16383) {
                throw new OverrunException("Too many requests.");
            }
            ++this.counter;
            this.timestamp = timestamp;
            return this.next();
        }
        this.counter = 0;
        this.timestamp = timestamp;
        return this.current();
    }

    @Override
    public void reset() {
        this.value = balancer.next();
    }

    protected void storeState() {
        if (SettingsUtil.isStateEnabled()) {
            this.state.setNodeIdentifier(this.nodeIdentifier);
            this.state.setTimestamp(this.timestamp);
            this.state.setClockSequence(this.value);
            this.state.store();
        }
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new DefaultClockSequenceShutdownHook(this));
    }

    protected static class DefaultClockSequenceShutdownHook
    extends Thread {
        private DefaultClockSequenceStrategy strategy;

        public DefaultClockSequenceShutdownHook(DefaultClockSequenceStrategy strategy) {
            this.strategy = strategy;
        }

        @Override
        public void run() {
            this.strategy.storeState();
        }
    }

    protected static class Balancer {
        private float perimeter;
        private float offset;
        private float iteration;
        private float remaining;
        private float arc;

        public Balancer(int max) {
            this.perimeter = max;
            this.reset();
        }

        private void reset() {
            this.offset = 0.0f;
            this.iteration = 0.0f;
            this.remaining = 0.0f;
            this.arc = 0.0f;
        }

        public int first() {
            this.reset();
            this.offset = RandomUtil.nextInt((int)this.perimeter);
            if (this.offset == 0.0f) {
                this.offset = this.perimeter;
            }
            return (int)this.offset;
        }

        public synchronized int next() {
            if (this.offset == 0.0f) {
                return this.first();
            }
            if (this.remaining == 0.0f) {
                this.remaining = (float)Math.pow(2.0, this.iteration);
                if ((double)this.remaining > (double)this.perimeter / 2.0) {
                    return this.first();
                }
                this.arc = this.perimeter / this.remaining;
                this.iteration += 1.0f;
            }
            return (int)(((double)(this.offset + this.arc * (this.remaining -= 1.0f)) + (double)this.arc / 2.0) % (double)this.perimeter);
        }
    }
}

