/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.state;

import com.github.f4b6a3.uuid.state.AbstractUuidState;
import com.github.f4b6a3.uuid.util.ByteUtil;
import com.github.f4b6a3.uuid.util.SettingsUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;

public class FileUuidState
extends AbstractUuidState {
    private static final String FILE_NAME = "uuidcreator";
    private static final String FILE_EXTENSION = "state";
    private static final String PROPERTY_TIMESTAMP = "timestamp";
    private static final String PROPERTY_CLOCKSEQ = "clockseq";
    private static final String PROPERTY_NODEID = "nodeid";
    private String directory = SettingsUtil.getStateDirectory();
    private String fileName;

    public FileUuidState() {
        this.updateFileName();
        this.load();
    }

    private void updateFileName() {
        this.fileName = String.join((CharSequence)"/", this.directory, FILE_NAME);
        this.fileName = String.join((CharSequence)".", this.fileName, FILE_EXTENSION);
    }

    @Override
    public void store() {
        try {
            Properties properties = new Properties();
            properties.setProperty(PROPERTY_TIMESTAMP, ByteUtil.toHexadecimal(this.timestamp));
            properties.setProperty(PROPERTY_CLOCKSEQ, ByteUtil.toHexadecimal(this.clockSequence));
            properties.setProperty(PROPERTY_NODEID, ByteUtil.toHexadecimal(this.nodeIdentifier));
            properties.store(new FileWriter(this.fileName), null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void load() {
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(this.fileName));
            String timestamp = properties.getProperty(PROPERTY_TIMESTAMP, "0");
            String clockseq = properties.getProperty(PROPERTY_CLOCKSEQ, "0");
            String nodeid = properties.getProperty(PROPERTY_NODEID, "0");
            this.timestamp = ByteUtil.toNumber(timestamp);
            this.clockSequence = (int)ByteUtil.toNumber(clockseq) & 0x3FFF;
            this.nodeIdentifier = ByteUtil.toNumber(nodeid) & 0xFFFFFFFFFFFFL;
        }
        catch (FileNotFoundException properties) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

