/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.ulid.util;

import com.github.f4b6a3.ulid.exception.InvalidUlidException;
import com.github.f4b6a3.ulid.util.internal.UlidStruct;

public final class UlidValidator {
    protected static final int ULID_LENGTH = 26;

    private UlidValidator() {
    }

    public static boolean isValid(String ulid) {
        return ulid != null && ulid.length() != 0 && UlidValidator.isValidString(ulid.toCharArray());
    }

    public static boolean isValid(char[] ulid) {
        return ulid != null && ulid.length != 0 && UlidValidator.isValidString(ulid);
    }

    public static void validate(String ulid) {
        if (ulid == null || ulid.length() == 0 || !UlidValidator.isValidString(ulid.toCharArray())) {
            throw new InvalidUlidException("Invalid ULID: \"" + ulid + "\"");
        }
    }

    public static void validate(char[] ulid) {
        if (ulid == null || ulid.length == 0 || !UlidValidator.isValidString(ulid)) {
            throw new InvalidUlidException("Invalid ULID: \"" + (ulid == null ? null : new String(ulid)) + "\"");
        }
    }

    protected static boolean isValidString(char[] c) {
        if ((UlidStruct.BASE32_VALUES[c[0]] & 0x18L) != 0L) {
            return false;
        }
        int hyphen = 0;
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '-') {
                ++hyphen;
                continue;
            }
            if (c[i] == 'U' || c[i] == 'u') {
                return false;
            }
            if (c[i] >= 'A' && c[i] <= 'Z' || c[i] >= '0' && c[i] <= '9' || c[i] >= 'a' && c[i] <= 'z') continue;
            return false;
        }
        return c.length - hyphen == 26;
    }
}

