/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.adapter.recyclerview;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import com.evrencoskun.tableview.adapter.ITableAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.AbstractRecyclerViewAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.holder.AbstractViewHolder;
import java.util.List;

public class CellRowRecyclerViewAdapter<C>
extends AbstractRecyclerViewAdapter<C> {
    private static final String LOG_TAG = CellRowRecyclerViewAdapter.class.getSimpleName();
    private int mYPosition;
    private ITableAdapter mTableAdapter;

    public CellRowRecyclerViewAdapter(Context context, List itemList, ITableAdapter p_iTableAdapter, int yPosition) {
        super(context, itemList);
        this.mYPosition = yPosition;
        this.mTableAdapter = p_iTableAdapter;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (this.mTableAdapter != null) {
            AbstractViewHolder viewHolder = (AbstractViewHolder)this.mTableAdapter.onCreateCellViewHolder(parent, viewType);
            return viewHolder;
        }
        return null;
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int xPosition) {
        if (this.mTableAdapter != null) {
            AbstractViewHolder viewHolder = (AbstractViewHolder)holder;
            Object value = this.getItem(xPosition);
            this.mTableAdapter.onBindCellViewHolder(viewHolder, value, xPosition, this.mYPosition);
        }
    }

    public int getYPosition() {
        return this.mYPosition;
    }

    @Override
    public int getItemViewType(int position) {
        return this.mTableAdapter.getCellItemViewType(position);
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        super.onViewAttachedToWindow(holder);
        AbstractViewHolder viewHolder = (AbstractViewHolder)holder;
        AbstractViewHolder.SelectionState selectionState = this.mTableAdapter.getTableView().getSelectionHandler().getCellSelectionState(holder.getAdapterPosition(), this.mYPosition);
        if (!this.mTableAdapter.getTableView().isIgnoreSelectionColors()) {
            if (selectionState == AbstractViewHolder.SelectionState.SELECTED) {
                viewHolder.setBackgroundColor(this.mTableAdapter.getTableView().getSelectedColor());
            } else {
                viewHolder.setBackgroundColor(this.mTableAdapter.getTableView().getUnSelectedColor());
            }
        }
        viewHolder.setSelected(selectionState);
    }
}

