/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.adapter.recyclerview;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import com.evrencoskun.tableview.adapter.ITableAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.AbstractRecyclerViewAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.holder.AbstractViewHolder;
import com.evrencoskun.tableview.sort.RowHeaderSortHelper;
import java.util.List;

public class RowHeaderRecyclerViewAdapter<RH>
extends AbstractRecyclerViewAdapter<RH> {
    private ITableAdapter mTableAdapter;
    private RowHeaderSortHelper mRowHeaderSortHelper;

    public RowHeaderRecyclerViewAdapter(Context context, List<RH> itemList, ITableAdapter tableAdapter) {
        super(context, itemList);
        this.mTableAdapter = tableAdapter;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return this.mTableAdapter.onCreateRowHeaderViewHolder(parent, viewType);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        AbstractViewHolder viewHolder = (AbstractViewHolder)holder;
        Object value = this.getItem(position);
        this.mTableAdapter.onBindRowHeaderViewHolder(viewHolder, value, position);
    }

    @Override
    public int getItemViewType(int position) {
        return this.mTableAdapter.getRowHeaderItemViewType(position);
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        super.onViewAttachedToWindow(holder);
        AbstractViewHolder viewHolder = (AbstractViewHolder)holder;
        AbstractViewHolder.SelectionState selectionState = this.mTableAdapter.getTableView().getSelectionHandler().getRowSelectionState(holder.getAdapterPosition());
        if (!this.mTableAdapter.getTableView().isIgnoreSelectionColors()) {
            this.mTableAdapter.getTableView().getSelectionHandler().changeRowBackgroundColorBySelectionStatus(viewHolder, selectionState);
        }
        viewHolder.setSelected(selectionState);
    }

    public RowHeaderSortHelper getRowHeaderSortHelper() {
        if (this.mRowHeaderSortHelper == null) {
            this.mRowHeaderSortHelper = new RowHeaderSortHelper();
        }
        return this.mRowHeaderSortHelper;
    }
}

