/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.listener.scroll;

import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.MotionEvent;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.adapter.recyclerview.CellRecyclerView;

public class VerticalRecyclerViewListener
extends RecyclerView.OnScrollListener
implements RecyclerView.OnItemTouchListener {
    private static final String LOG_TAG = VerticalRecyclerViewListener.class.getSimpleName();
    private CellRecyclerView m_jRowHeaderRecyclerView;
    private CellRecyclerView m_jCellRecyclerView;
    private RecyclerView m_jLastTouchedRecyclerView;
    private boolean m_bMoved = false;
    private int m_nYPosition;

    public VerticalRecyclerViewListener(ITableView p_iTableView) {
        this.m_jRowHeaderRecyclerView = p_iTableView.getRowHeaderRecyclerView();
        this.m_jCellRecyclerView = p_iTableView.getCellRecyclerView();
    }

    public boolean onInterceptTouchEvent(RecyclerView rv, MotionEvent e) {
        if (e.getAction() == 0) {
            if (rv.getScrollState() == 0) {
                if (this.m_jLastTouchedRecyclerView != null && rv != this.m_jLastTouchedRecyclerView) {
                    this.removeLastTouchedRecyclerViewScrollListener(false);
                }
                this.m_nYPosition = ((CellRecyclerView)rv).getScrolledY();
                rv.addOnScrollListener((RecyclerView.OnScrollListener)this);
                if (rv == this.m_jCellRecyclerView) {
                    Log.d((String)LOG_TAG, (String)"m_jCellRecyclerView scroll listener added");
                } else if (rv == this.m_jRowHeaderRecyclerView) {
                    Log.d((String)LOG_TAG, (String)"m_jRowHeaderRecyclerView scroll listener added");
                }
                this.m_bMoved = false;
            }
        } else if (e.getAction() == 2) {
            this.m_bMoved = true;
        } else if (e.getAction() == 1) {
            int nScrollY = ((CellRecyclerView)rv).getScrolledY();
            if (this.m_nYPosition == nScrollY && !this.m_bMoved && rv.getScrollState() == 0) {
                rv.removeOnScrollListener((RecyclerView.OnScrollListener)this);
                if (rv == this.m_jCellRecyclerView) {
                    Log.d((String)LOG_TAG, (String)"m_jCellRecyclerView scroll listener removed from up ");
                } else if (rv == this.m_jRowHeaderRecyclerView) {
                    Log.d((String)LOG_TAG, (String)"m_jRowHeaderRecyclerView scroll listener removed from up");
                }
            }
            this.m_jLastTouchedRecyclerView = rv;
        }
        return false;
    }

    public void onTouchEvent(RecyclerView rv, MotionEvent e) {
    }

    public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
    }

    public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
        if (recyclerView == this.m_jCellRecyclerView) {
            super.onScrolled(recyclerView, dx, dy);
        } else if (recyclerView == this.m_jRowHeaderRecyclerView) {
            super.onScrolled(recyclerView, dx, dy);
            this.m_jCellRecyclerView.scrollBy(0, dy);
        }
    }

    public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
        super.onScrollStateChanged(recyclerView, newState);
        if (newState == 0) {
            recyclerView.removeOnScrollListener((RecyclerView.OnScrollListener)this);
            this.m_bMoved = false;
            if (recyclerView == this.m_jCellRecyclerView) {
                Log.d((String)LOG_TAG, (String)"m_jCellRecyclerView scroll listener removed from onScrollStateChanged");
            } else if (recyclerView == this.m_jRowHeaderRecyclerView) {
                Log.d((String)LOG_TAG, (String)"m_jRowHeaderRecyclerView scroll listener removed from onScrollStateChanged");
            }
        }
    }

    public void removeLastTouchedRecyclerViewScrollListener(boolean p_bIsNeeded) {
        if (this.m_jLastTouchedRecyclerView == this.m_jCellRecyclerView) {
            this.m_jCellRecyclerView.removeOnScrollListener(this);
            this.m_jCellRecyclerView.stopScroll();
            Log.d((String)LOG_TAG, (String)"m_jCellRecyclerView scroll listener removed from last touched");
        } else {
            this.m_jRowHeaderRecyclerView.removeOnScrollListener(this);
            this.m_jRowHeaderRecyclerView.stopScroll();
            Log.d((String)LOG_TAG, (String)"m_jRowHeaderRecyclerView scroll listener removed from last touched");
            if (p_bIsNeeded) {
                this.m_jCellRecyclerView.removeOnScrollListener(this);
                this.m_jCellRecyclerView.stopScroll();
                Log.d((String)LOG_TAG, (String)"m_jCellRecyclerView scroll listener removed from last touched");
            }
        }
    }
}

