/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.adapter.recyclerview;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.adapter.ITableAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.AbstractRecyclerViewAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.holder.AbstractViewHolder;

public class CellRowRecyclerViewAdapter<C>
extends AbstractRecyclerViewAdapter<C> {
    private static final String LOG_TAG = CellRowRecyclerViewAdapter.class.getSimpleName();
    private int mYPosition;
    private ITableAdapter mTableAdapter;
    private ITableView mTableView;

    public CellRowRecyclerViewAdapter(Context context, ITableView tableView) {
        super(context, null);
        this.mTableAdapter = tableView.getAdapter();
        this.mTableView = tableView;
    }

    public AbstractViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return this.mTableAdapter.onCreateCellViewHolder(parent, viewType);
    }

    public void onBindViewHolder(AbstractViewHolder holder, int xPosition) {
        this.mTableAdapter.onBindCellViewHolder(holder, this.getItem(xPosition), xPosition, this.mYPosition);
    }

    public int getYPosition() {
        return this.mYPosition;
    }

    public void setYPosition(int rowPosition) {
        this.mYPosition = rowPosition;
    }

    @Override
    public int getItemViewType(int position) {
        return this.mTableAdapter.getCellItemViewType(position);
    }

    public void onViewAttachedToWindow(AbstractViewHolder viewHolder) {
        super.onViewAttachedToWindow((RecyclerView.ViewHolder)viewHolder);
        AbstractViewHolder.SelectionState selectionState = this.mTableView.getSelectionHandler().getCellSelectionState(viewHolder.getAdapterPosition(), this.mYPosition);
        if (!this.mTableView.isIgnoreSelectionColors()) {
            if (selectionState == AbstractViewHolder.SelectionState.SELECTED) {
                viewHolder.setBackgroundColor(this.mTableView.getSelectedColor());
            } else {
                viewHolder.setBackgroundColor(this.mTableView.getUnSelectedColor());
            }
        }
        viewHolder.setSelected(selectionState);
    }

    public boolean onFailedToRecycleView(AbstractViewHolder holder) {
        return holder.onFailedToRecycleView();
    }

    public void onViewRecycled(AbstractViewHolder holder) {
        super.onViewRecycled((RecyclerView.ViewHolder)holder);
        holder.onViewRecycled();
    }
}

