/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.handler;

import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.adapter.AdapterDataSetChangedListener;
import com.evrencoskun.tableview.adapter.recyclerview.CellRecyclerViewAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.RowHeaderRecyclerViewAdapter;
import com.evrencoskun.tableview.filter.Filter;
import com.evrencoskun.tableview.filter.FilterChangedListener;
import com.evrencoskun.tableview.filter.FilterItem;
import com.evrencoskun.tableview.filter.FilterType;
import com.evrencoskun.tableview.filter.IFilterableModel;
import java.util.ArrayList;
import java.util.List;

public class FilterHandler<T> {
    private CellRecyclerViewAdapter mCellRecyclerViewAdapter;
    private RowHeaderRecyclerViewAdapter mRowHeaderRecyclerViewAdapter;
    private List<List<IFilterableModel>> originalCellDataStore;
    private List<List<IFilterableModel>> originalCellData;
    private List<List<IFilterableModel>> filteredCellList;
    private List<T> originalRowDataStore;
    private List<T> originalRowData;
    private List<T> filteredRowList;
    private List<FilterChangedListener> filterChangedListeners;
    private AdapterDataSetChangedListener adapterDataSetChangedListener = new AdapterDataSetChangedListener(){

        public void onRowHeaderItemsChanged(List rowHeaderItems) {
            if (rowHeaderItems != null) {
                FilterHandler.this.originalRowDataStore = new ArrayList(rowHeaderItems);
            }
        }

        public void onCellItemsChanged(List cellItems) {
            if (cellItems != null) {
                FilterHandler.this.originalCellDataStore = new ArrayList(cellItems);
            }
        }
    };

    public FilterHandler(ITableView tableView) {
        tableView.getAdapter().addAdapterDataSetChangedListener(this.adapterDataSetChangedListener);
        this.mCellRecyclerViewAdapter = (CellRecyclerViewAdapter)tableView.getCellRecyclerView().getAdapter();
        this.mRowHeaderRecyclerViewAdapter = (RowHeaderRecyclerViewAdapter)tableView.getRowHeaderRecyclerView().getAdapter();
    }

    public void filter(Filter filter) {
        if (this.originalCellDataStore == null || this.originalRowDataStore == null) {
            return;
        }
        this.originalCellData = new ArrayList<List<IFilterableModel>>(this.originalCellDataStore);
        this.originalRowData = new ArrayList<T>(this.originalRowDataStore);
        this.filteredCellList = new ArrayList<List<IFilterableModel>>();
        this.filteredRowList = new ArrayList<T>();
        if (filter.getFilterItems().isEmpty()) {
            this.filteredCellList = new ArrayList<List<IFilterableModel>>(this.originalCellDataStore);
            this.filteredRowList = new ArrayList<T>(this.originalRowDataStore);
            this.dispatchFilterClearedToListeners(this.originalCellDataStore, this.originalRowDataStore);
        } else {
            int x = 0;
            while (x < filter.getFilterItems().size()) {
                FilterItem filterItem = filter.getFilterItems().get(x);
                if (filterItem.getFilterType().equals((Object)FilterType.ALL)) {
                    block1: for (List<IFilterableModel> itemsList : this.originalCellData) {
                        for (IFilterableModel item : itemsList) {
                            if (!item.getFilterableKeyword().toLowerCase().contains(filterItem.getFilter().toLowerCase())) continue;
                            this.filteredCellList.add(itemsList);
                            this.filteredRowList.add(this.originalRowData.get(this.filteredCellList.indexOf(itemsList)));
                            continue block1;
                        }
                    }
                } else {
                    for (List<IFilterableModel> itemsList : this.originalCellData) {
                        if (!itemsList.get(filterItem.getColumn()).getFilterableKeyword().toLowerCase().contains(filterItem.getFilter().toLowerCase())) continue;
                        this.filteredCellList.add(itemsList);
                        this.filteredRowList.add(this.originalRowData.get(this.filteredCellList.indexOf(itemsList)));
                    }
                }
                if (++x >= filter.getFilterItems().size()) continue;
                this.originalCellData = new ArrayList<List<IFilterableModel>>(this.filteredCellList);
                this.originalRowData = new ArrayList<T>(this.filteredRowList);
                this.filteredCellList.clear();
                this.filteredRowList.clear();
            }
        }
        this.mRowHeaderRecyclerViewAdapter.setItems(this.filteredRowList, true);
        this.mCellRecyclerViewAdapter.setItems(this.filteredCellList, true);
        this.dispatchFilterChangedToListeners(this.filteredCellList, this.filteredRowList);
    }

    private void dispatchFilterChangedToListeners(List<List<IFilterableModel>> filteredCellItems, List<T> filteredRowHeaderItems) {
        if (this.filterChangedListeners != null) {
            for (FilterChangedListener listener : this.filterChangedListeners) {
                listener.onFilterChanged(filteredCellItems, filteredRowHeaderItems);
            }
        }
    }

    private void dispatchFilterClearedToListeners(List<List<IFilterableModel>> originalCellItems, List<T> originalRowHeaderItems) {
        if (this.filterChangedListeners != null) {
            for (FilterChangedListener listener : this.filterChangedListeners) {
                listener.onFilterCleared(originalCellItems, originalRowHeaderItems);
            }
        }
    }

    public void addFilterChangedListener(FilterChangedListener listener) {
        if (this.filterChangedListeners == null) {
            this.filterChangedListeners = new ArrayList<FilterChangedListener>();
        }
        this.filterChangedListeners.add(listener);
    }
}

