/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.jsonbeans;

import com.esotericsoftware.jsonbeans.Null;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OutputType {
    json,
    javascript,
    minimal;

    private static Pattern javascriptPattern;
    private static Pattern minimalNamePattern;
    private static Pattern minimalValuePattern;

    public String quoteValue(@Null Object value) {
        int length;
        if (value == null || value instanceof Number || value instanceof Boolean) {
            return String.valueOf(value);
        }
        String string = String.valueOf(value).replace("\\", "\\\\").replace("\r", "\\r").replace("\n", "\\n").replace("\t", "\\t");
        if (!(this != minimal || string.equals("true") || string.equals("false") || string.equals("null") || string.contains("//") || string.contains("/*") || (length = string.length()) <= 0 || string.charAt(length - 1) == ' ' || !minimalValuePattern.matcher(string).matches())) {
            return string;
        }
        return '\"' + string.replace("\"", "\\\"") + '\"';
    }

    public String quoteName(String value) {
        value = value.replace("\\", "\\\\").replace("\r", "\\r").replace("\n", "\\n").replace("\t", "\\t");
        switch (this) {
            case minimal: {
                if (!value.contains("//") && !value.contains("/*") && minimalNamePattern.matcher(value).matches()) {
                    return value;
                }
            }
            case javascript: {
                if (!javascriptPattern.matcher(value).matches()) break;
                return value;
            }
        }
        return '\"' + value.replace("\"", "\\\"") + '\"';
    }

    static {
        javascriptPattern = Pattern.compile("^[a-zA-Z_$][a-zA-Z_$0-9]*$");
        minimalNamePattern = Pattern.compile("^[^\":,}/ ][^:]*$");
        minimalValuePattern = Pattern.compile("^[^\":,{\\[\\]/ ][^}\\],]*$");
    }
}

