/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.jsonbeans;

import com.esotericsoftware.jsonbeans.ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedMap<K, V>
extends ObjectMap<K, V> {
    final ArrayList<K> keys;

    public OrderedMap() {
        this.keys = new ArrayList();
    }

    public OrderedMap(int initialCapacity) {
        super(initialCapacity);
        this.keys = new ArrayList(initialCapacity);
    }

    public OrderedMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.keys = new ArrayList(initialCapacity);
    }

    public OrderedMap(OrderedMap<? extends K, ? extends V> map) {
        super(map);
        this.keys = new ArrayList<K>(map.keys);
    }

    @Override
    public V put(K key, V value) {
        int i = this.locateKey(key);
        if (i >= 0) {
            Object oldValue = this.valueTable[i];
            this.valueTable[i] = value;
            return (V)oldValue;
        }
        i = -(i + 1);
        this.keyTable[i] = key;
        this.valueTable[i] = value;
        this.keys.add(key);
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return null;
    }

    @Override
    public <T extends K> void putAll(OrderedMap<T, ? extends V> map) {
        this.ensureCapacity(map.size);
        ArrayList<K> keys = map.keys;
        int n = map.keys.size();
        for (int i = 0; i < n; ++i) {
            K key = keys.get(i);
            this.put(key, map.get(key));
        }
    }

    @Override
    public V remove(K key) {
        this.keys.remove(key);
        return super.remove(key);
    }

    public V removeIndex(int index) {
        return super.remove(this.keys.remove(index));
    }

    public boolean alter(K before, K after) {
        if (this.containsKey(after)) {
            return false;
        }
        int index = this.keys.indexOf(before);
        if (index == -1) {
            return false;
        }
        super.put(after, super.remove(before));
        this.keys.set(index, after);
        return true;
    }

    public boolean alterIndex(int index, K after) {
        if (index < 0 || index >= this.size || this.containsKey(after)) {
            return false;
        }
        super.put(after, super.remove(this.keys.get(index)));
        this.keys.set(index, after);
        return true;
    }

    @Override
    public void clear(int maximumCapacity) {
        this.keys.clear();
        super.clear(maximumCapacity);
    }

    @Override
    public void clear() {
        this.keys.clear();
        super.clear();
    }

    public ArrayList<K> orderedKeys() {
        return this.keys;
    }

    @Override
    public ObjectMap.Entries<K, V> iterator() {
        return this.entries();
    }

    @Override
    public ObjectMap.Entries<K, V> entries() {
        return new OrderedMapEntries(this);
    }

    @Override
    public ObjectMap.Values<V> values() {
        return new OrderedMapValues(this);
    }

    @Override
    public ObjectMap.Keys<K> keys() {
        return new OrderedMapKeys(this);
    }

    @Override
    public String toString() {
        if (this.size == 0) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('{');
        ArrayList<K> keys = this.keys;
        int n = keys.size();
        for (int i = 0; i < n; ++i) {
            K key = keys.get(i);
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(key);
            buffer.append('=');
            buffer.append(this.get(key));
        }
        buffer.append('}');
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OrderedMapValues<V>
    extends ObjectMap.Values<V> {
        private ArrayList keys;

        public OrderedMapValues(OrderedMap<?, V> map) {
            super(map);
            this.keys = map.keys;
        }

        @Override
        public void reset() {
            this.currentIndex = -1;
            this.nextIndex = 0;
            this.hasNext = this.map.size > 0;
        }

        @Override
        public V next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            Object value = this.map.get(this.keys.get(this.nextIndex));
            this.currentIndex = this.nextIndex++;
            this.hasNext = this.nextIndex < this.map.size;
            return value;
        }

        @Override
        public void remove() {
            if (this.currentIndex < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            ((OrderedMap)this.map).removeIndex(this.currentIndex);
            this.nextIndex = this.currentIndex;
            this.currentIndex = -1;
        }

        @Override
        public <T extends List<V>> T toList(T array) {
            int n = this.keys.size();
            for (int i = this.nextIndex; i < n; ++i) {
                array.add(this.map.get(this.keys.get(i)));
            }
            this.currentIndex = n - 1;
            this.nextIndex = n;
            this.hasNext = false;
            return array;
        }

        @Override
        public ArrayList<V> toList() {
            return this.toList(new ArrayList(this.keys.size() - this.nextIndex));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OrderedMapKeys<K>
    extends ObjectMap.Keys<K> {
        private ArrayList<K> keys;

        public OrderedMapKeys(OrderedMap<K, ?> map) {
            super(map);
            this.keys = map.keys;
        }

        @Override
        public void reset() {
            this.currentIndex = -1;
            this.nextIndex = 0;
            this.hasNext = this.map.size > 0;
        }

        @Override
        public K next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            K key = this.keys.get(this.nextIndex);
            this.currentIndex = this.nextIndex++;
            this.hasNext = this.nextIndex < this.map.size;
            return key;
        }

        @Override
        public void remove() {
            if (this.currentIndex < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            ((OrderedMap)this.map).removeIndex(this.currentIndex);
            this.nextIndex = this.currentIndex;
            this.currentIndex = -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OrderedMapEntries<K, V>
    extends ObjectMap.Entries<K, V> {
        private ArrayList<K> keys;

        public OrderedMapEntries(OrderedMap<K, V> map) {
            super(map);
            this.keys = map.keys;
        }

        @Override
        public void reset() {
            this.currentIndex = -1;
            this.nextIndex = 0;
            this.hasNext = this.map.size > 0;
        }

        @Override
        public ObjectMap.Entry next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            this.currentIndex = this.nextIndex;
            this.entry.key = this.keys.get(this.nextIndex);
            this.entry.value = this.map.get(this.entry.key);
            ++this.nextIndex;
            this.hasNext = this.nextIndex < this.map.size;
            return this.entry;
        }

        @Override
        public void remove() {
            if (this.currentIndex < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            this.map.remove(this.entry.key);
            --this.nextIndex;
            this.currentIndex = -1;
        }
    }
}

