/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.jsonbeans;

import com.esotericsoftware.jsonbeans.JsonException;
import com.esotericsoftware.jsonbeans.JsonReader;
import com.esotericsoftware.jsonbeans.JsonSerializable;
import com.esotericsoftware.jsonbeans.JsonSerializer;
import com.esotericsoftware.jsonbeans.JsonValue;
import com.esotericsoftware.jsonbeans.JsonWriter;
import com.esotericsoftware.jsonbeans.Null;
import com.esotericsoftware.jsonbeans.ObjectMap;
import com.esotericsoftware.jsonbeans.OrderedMap;
import com.esotericsoftware.jsonbeans.OutputType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Json {
    private static final boolean debug = false;
    private JsonWriter writer;
    private String typeName = "class";
    private boolean usePrototypes = true;
    private OutputType outputType;
    private boolean quoteLongValues;
    private boolean ignoreUnknownFields;
    private boolean enumNames = true;
    private JsonSerializer defaultSerializer;
    private final ObjectMap<Class, OrderedMap<String, FieldMetadata>> typeToFields = new ObjectMap();
    private final ObjectMap<String, Class> tagToClass = new ObjectMap();
    private final ObjectMap<Class, String> classToTag = new ObjectMap();
    private final ObjectMap<Class, JsonSerializer> classToSerializer = new ObjectMap();
    private final ObjectMap<Class, Object[]> classToDefaultValues = new ObjectMap();
    private final Object[] equals1 = new Object[]{null};
    private final Object[] equals2 = new Object[]{null};

    public Json() {
        this.outputType = OutputType.minimal;
    }

    public Json(OutputType outputType) {
        this.outputType = outputType;
    }

    public void setIgnoreUnknownFields(boolean ignoreUnknownFields) {
        this.ignoreUnknownFields = ignoreUnknownFields;
    }

    public void setOutputType(OutputType outputType) {
        this.outputType = outputType;
    }

    public void setQuoteLongValues(boolean quoteLongValues) {
        this.quoteLongValues = quoteLongValues;
    }

    public void setEnumNames(boolean enumNames) {
        this.enumNames = enumNames;
    }

    public void addClassTag(String tag, Class type) {
        this.tagToClass.put(tag, type);
        this.classToTag.put(type, tag);
    }

    @Null
    public Class getClass(String tag) {
        return this.tagToClass.get(tag);
    }

    @Null
    public String getTag(Class type) {
        return this.classToTag.get(type);
    }

    public void setTypeName(@Null String typeName) {
        this.typeName = typeName;
    }

    public void setDefaultSerializer(@Null JsonSerializer defaultSerializer) {
        this.defaultSerializer = defaultSerializer;
    }

    public <T> void setSerializer(Class<T> type, JsonSerializer<T> serializer) {
        this.classToSerializer.put(type, serializer);
    }

    public <T> JsonSerializer<T> getSerializer(Class<T> type) {
        return this.classToSerializer.get(type);
    }

    public void setUsePrototypes(boolean usePrototypes) {
        this.usePrototypes = usePrototypes;
    }

    public void setElementType(Class type, String fieldName, Class elementType) {
        OrderedMap<String, FieldMetadata> fields = this.getFields(type);
        FieldMetadata metadata = (FieldMetadata)fields.get(fieldName);
        if (metadata == null) {
            throw new JsonException("Field not found: " + fieldName + " (" + type.getName() + ")");
        }
        metadata.elementType = elementType;
    }

    private OrderedMap<String, FieldMetadata> getFields(Class type) {
        OrderedMap<String, FieldMetadata> fields = this.typeToFields.get(type);
        if (fields != null) {
            return fields;
        }
        ArrayList allFields = new ArrayList();
        for (Class nextClass = type; nextClass != Object.class; nextClass = nextClass.getSuperclass()) {
            Collections.addAll(allFields, nextClass.getDeclaredFields());
        }
        OrderedMap<String, FieldMetadata> nameToField = new OrderedMap<String, FieldMetadata>();
        int n = allFields.size();
        for (int i = 0; i < n; ++i) {
            Field field = (Field)allFields.get(i);
            int modifiers = field.getModifiers();
            if (Modifier.isTransient(modifiers) || Modifier.isStatic(modifiers) || field.isSynthetic()) continue;
            if (!field.isAccessible()) {
                try {
                    field.setAccessible(true);
                }
                catch (AccessControlException ex) {
                    continue;
                }
            }
            nameToField.put(field.getName(), new FieldMetadata(field));
        }
        this.typeToFields.put(type, nameToField);
        return nameToField;
    }

    public String toJson(@Null Object object) {
        return this.toJson(object, object == null ? null : object.getClass(), (Class)null);
    }

    public String toJson(@Null Object object, @Null Class knownType) {
        return this.toJson(object, knownType, (Class)null);
    }

    public String toJson(@Null Object object, @Null Class knownType, @Null Class elementType) {
        StringWriter buffer = new StringWriter();
        this.toJson(object, knownType, elementType, buffer);
        return buffer.toString();
    }

    public void toJson(@Null Object object, File file) {
        this.toJson(object, object == null ? null : object.getClass(), null, file);
    }

    public void toJson(@Null Object object, @Null Class knownType, File file) {
        this.toJson(object, knownType, null, file);
    }

    public void toJson(@Null Object object, @Null Class knownType, @Null Class elementType, File file) {
        Writer writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            this.toJson(object, knownType, elementType, writer);
        }
        catch (Exception ex) {
            throw new JsonException("Error writing file: " + file, ex);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void toJson(@Null Object object, Writer writer) {
        this.toJson(object, object == null ? null : object.getClass(), null, writer);
    }

    public void toJson(@Null Object object, @Null Class knownType, Writer writer) {
        this.toJson(object, knownType, null, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toJson(@Null Object object, @Null Class knownType, @Null Class elementType, Writer writer) {
        this.setWriter(writer);
        try {
            this.writeValue(object, knownType, elementType);
        }
        finally {
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (IOException iOException) {}
            }
            this.writer = null;
        }
    }

    public void setWriter(Writer writer) {
        if (!(writer instanceof JsonWriter)) {
            writer = new JsonWriter(writer);
        }
        this.writer = (JsonWriter)writer;
        this.writer.setOutputType(this.outputType);
        this.writer.setQuoteLongValues(this.quoteLongValues);
    }

    public JsonWriter getWriter() {
        return this.writer;
    }

    public void writeFields(Object object) {
        Class<?> type = object.getClass();
        Object[] defaultValues = this.getDefaultValues(type);
        OrderedMap<String, FieldMetadata> fields = this.getFields(type);
        int i = 0;
        for (FieldMetadata metadata : new OrderedMap.OrderedMapValues<FieldMetadata>(fields)) {
            Field field = metadata.field;
            try {
                Object value = field.get(object);
                if (defaultValues != null) {
                    Object defaultValue = defaultValues[i++];
                    if (value == null && defaultValue == null) continue;
                    if (value != null && defaultValue != null) {
                        if (value.equals(defaultValue)) continue;
                        if (value.getClass().isArray() && defaultValue.getClass().isArray()) {
                            this.equals1[0] = value;
                            this.equals2[0] = defaultValue;
                            if (Arrays.deepEquals(this.equals1, this.equals2)) continue;
                        }
                    }
                }
                this.writer.name(field.getName());
                this.writeValue(value, field.getType(), metadata.elementType);
            }
            catch (IllegalAccessException ex) {
                throw new JsonException("Error accessing field: " + field.getName() + " (" + type.getName() + ")", ex);
            }
            catch (JsonException ex) {
                ex.addTrace(field + " (" + type.getName() + ")");
                throw ex;
            }
            catch (Exception runtimeEx) {
                JsonException ex = new JsonException(runtimeEx);
                ex.addTrace(field + " (" + type.getName() + ")");
                throw ex;
            }
        }
    }

    @Null
    private Object[] getDefaultValues(Class type) {
        Object object;
        if (!this.usePrototypes) {
            return null;
        }
        if (this.classToDefaultValues.containsKey(type)) {
            return this.classToDefaultValues.get(type);
        }
        try {
            object = this.newInstance(type);
        }
        catch (Exception ex) {
            this.classToDefaultValues.put(type, null);
            return null;
        }
        OrderedMap<String, FieldMetadata> fields = this.getFields(type);
        Object[] values = new Object[fields.size];
        this.classToDefaultValues.put(type, values);
        int i = 0;
        for (FieldMetadata metadata : ((ObjectMap)fields).values()) {
            Field field = metadata.field;
            try {
                values[i++] = field.get(object);
            }
            catch (IllegalAccessException ex) {
                throw new JsonException("Error accessing field: " + field.getName() + " (" + type.getName() + ")", ex);
            }
            catch (JsonException ex) {
                ex.addTrace(field + " (" + type.getName() + ")");
                throw ex;
            }
            catch (RuntimeException runtimeEx) {
                JsonException ex = new JsonException(runtimeEx);
                ex.addTrace(field + " (" + type.getName() + ")");
                throw ex;
            }
        }
        return values;
    }

    public void writeField(Object object, String name) {
        this.writeField(object, name, name, null);
    }

    public void writeField(Object object, String name, @Null Class elementType) {
        this.writeField(object, name, name, elementType);
    }

    public void writeField(Object object, String fieldName, String jsonName) {
        this.writeField(object, fieldName, jsonName, null);
    }

    public void writeField(Object object, String fieldName, String jsonName, @Null Class elementType) {
        Class<?> type = object.getClass();
        OrderedMap<String, FieldMetadata> fields = this.getFields(type);
        FieldMetadata metadata = (FieldMetadata)fields.get(fieldName);
        if (metadata == null) {
            throw new JsonException("Field not found: " + fieldName + " (" + type.getName() + ")");
        }
        Field field = metadata.field;
        if (elementType == null) {
            elementType = metadata.elementType;
        }
        try {
            this.writer.name(jsonName);
            this.writeValue(field.get(object), field.getType(), elementType);
        }
        catch (IllegalAccessException ex) {
            throw new JsonException("Error accessing field: " + field.getName() + " (" + type.getName() + ")", ex);
        }
        catch (JsonException ex) {
            ex.addTrace(field + " (" + type.getName() + ")");
            throw ex;
        }
        catch (Exception runtimeEx) {
            JsonException ex = new JsonException(runtimeEx);
            ex.addTrace(field + " (" + type.getName() + ")");
            throw ex;
        }
    }

    public void writeValue(String name, @Null Object value) {
        try {
            this.writer.name(name);
        }
        catch (IOException ex) {
            throw new JsonException(ex);
        }
        if (value == null) {
            this.writeValue(value, null, null);
        } else {
            this.writeValue(value, value.getClass(), null);
        }
    }

    public void writeValue(String name, @Null Object value, @Null Class knownType) {
        try {
            this.writer.name(name);
        }
        catch (IOException ex) {
            throw new JsonException(ex);
        }
        this.writeValue(value, knownType, null);
    }

    public void writeValue(String name, @Null Object value, @Null Class knownType, @Null Class elementType) {
        try {
            this.writer.name(name);
        }
        catch (IOException ex) {
            throw new JsonException(ex);
        }
        this.writeValue(value, knownType, elementType);
    }

    public void writeValue(@Null Object value) {
        if (value == null) {
            this.writeValue(value, null, null);
        } else {
            this.writeValue(value, value.getClass(), null);
        }
    }

    public void writeValue(@Null Object value, @Null Class knownType) {
        this.writeValue(value, knownType, null);
    }

    /*
     * WARNING - void declaration
     */
    public void writeValue(@Null Object value, @Null Class knownType, @Null Class elementType) {
        try {
            if (value == null) {
                this.writer.value(null);
                return;
            }
            if (knownType != null && knownType.isPrimitive() || knownType == String.class || knownType == Integer.class || knownType == Boolean.class || knownType == Float.class || knownType == Long.class || knownType == Double.class || knownType == Short.class || knownType == Byte.class || knownType == Character.class) {
                this.writer.value(value);
                return;
            }
            Class<?> actualType = value.getClass();
            if (actualType.isPrimitive() || actualType == String.class || actualType == Integer.class || actualType == Boolean.class || actualType == Float.class || actualType == Long.class || actualType == Double.class || actualType == Short.class || actualType == Byte.class || actualType == Character.class) {
                this.writeObjectStart(actualType, null);
                this.writeValue("value", value);
                this.writeObjectEnd();
                return;
            }
            if (value instanceof JsonSerializable) {
                this.writeObjectStart(actualType, knownType);
                ((JsonSerializable)value).write(this);
                this.writeObjectEnd();
                return;
            }
            JsonSerializer serializer = this.classToSerializer.get(actualType);
            if (serializer != null) {
                serializer.write(this, value, knownType);
                return;
            }
            if (value instanceof ArrayList) {
                void var7_14;
                if (knownType != null && actualType != knownType && actualType != ArrayList.class) {
                    throw new JsonException("Serialization of an Array other than the known type is not supported.\nKnown type: " + knownType + "\nActual type: " + actualType);
                }
                this.writeArrayStart();
                ArrayList array = (ArrayList)value;
                boolean bl = false;
                int n = array.size();
                while (var7_14 < n) {
                    this.writeValue(array.get((int)var7_14), elementType, null);
                    ++var7_14;
                }
                this.writeArrayEnd();
                return;
            }
            if (value instanceof Collection) {
                if (this.typeName != null && actualType != ArrayList.class && (knownType == null || knownType != actualType)) {
                    this.writeObjectStart(actualType, knownType);
                    this.writeArrayStart("items");
                    for (Object e : (Collection)value) {
                        this.writeValue(e, elementType, null);
                    }
                    this.writeArrayEnd();
                    this.writeObjectEnd();
                } else {
                    this.writeArrayStart();
                    for (Object e : (Collection)value) {
                        this.writeValue(e, elementType, null);
                    }
                    this.writeArrayEnd();
                }
                return;
            }
            if (actualType.isArray()) {
                void var7_18;
                if (elementType == null) {
                    elementType = actualType.getComponentType();
                }
                int length = Array.getLength(value);
                this.writeArrayStart();
                boolean bl = false;
                while (var7_18 < length) {
                    this.writeValue(Array.get(value, (int)var7_18), elementType, null);
                    ++var7_18;
                }
                this.writeArrayEnd();
                return;
            }
            if (value instanceof ObjectMap) {
                if (knownType == null) {
                    knownType = ObjectMap.class;
                }
                this.writeObjectStart(actualType, knownType);
                for (ObjectMap.Entry entry : ((ObjectMap)value).entries()) {
                    this.writer.name(this.convertToString(entry.key));
                    this.writeValue(entry.value, elementType, null);
                }
                this.writeObjectEnd();
                return;
            }
            if (value instanceof Map) {
                if (knownType == null) {
                    knownType = HashMap.class;
                }
                this.writeObjectStart(actualType, knownType);
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    this.writer.name(this.convertToString(entry.getKey()));
                    this.writeValue(entry.getValue(), elementType, null);
                }
                this.writeObjectEnd();
                return;
            }
            if (Enum.class.isAssignableFrom(actualType)) {
                if (this.typeName != null && (knownType == null || knownType != actualType)) {
                    if (actualType.getEnumConstants() == null) {
                        actualType = actualType.getSuperclass();
                    }
                    this.writeObjectStart(actualType, null);
                    this.writer.name("value");
                    this.writer.value(this.convertToString((Enum)value));
                    this.writeObjectEnd();
                } else {
                    this.writer.value(this.convertToString((Enum)value));
                }
                return;
            }
            this.writeObjectStart(actualType, knownType);
            this.writeFields(value);
            this.writeObjectEnd();
        }
        catch (IOException ex) {
            throw new JsonException(ex);
        }
    }

    public void writeObjectStart(String name) {
        try {
            this.writer.name(name);
        }
        catch (IOException ex) {
            throw new JsonException(ex);
        }
        this.writeObjectStart();
    }

    public void writeObjectStart(String name, Class actualType, @Null Class knownType) {
        try {
            this.writer.name(name);
        }
        catch (IOException ex) {
            throw new JsonException(ex);
        }
        this.writeObjectStart(actualType, knownType);
    }

    public void writeObjectStart() {
        try {
            this.writer.object();
        }
        catch (IOException ex) {
            throw new JsonException(ex);
        }
    }

    public void writeObjectStart(Class actualType, @Null Class knownType) {
        try {
            this.writer.object();
        }
        catch (IOException ex) {
            throw new JsonException(ex);
        }
        if (knownType == null || knownType != actualType) {
            this.writeType(actualType);
        }
    }

    public void writeObjectEnd() {
        try {
            this.writer.pop();
        }
        catch (IOException ex) {
            throw new JsonException(ex);
        }
    }

    public void writeArrayStart(String name) {
        try {
            this.writer.name(name);
            this.writer.array();
        }
        catch (IOException ex) {
            throw new JsonException(ex);
        }
    }

    public void writeArrayStart() {
        try {
            this.writer.array();
        }
        catch (IOException ex) {
            throw new JsonException(ex);
        }
    }

    public void writeArrayEnd() {
        try {
            this.writer.pop();
        }
        catch (IOException ex) {
            throw new JsonException(ex);
        }
    }

    public void writeType(Class type) {
        if (this.typeName == null) {
            return;
        }
        String className = this.getTag(type);
        if (className == null) {
            className = type.getName();
        }
        try {
            this.writer.set(this.typeName, className);
        }
        catch (IOException ex) {
            throw new JsonException(ex);
        }
    }

    @Null
    public <T> T fromJson(@Null Class<T> type, Reader reader) {
        return this.readValue(type, null, new JsonReader().parse(reader));
    }

    @Null
    public <T> T fromJson(@Null Class<T> type, @Null Class elementType, Reader reader) {
        return this.readValue(type, elementType, new JsonReader().parse(reader));
    }

    @Null
    public <T> T fromJson(@Null Class<T> type, InputStream input) {
        return this.readValue(type, null, new JsonReader().parse(input));
    }

    @Null
    public <T> T fromJson(@Null Class<T> type, @Null Class elementType, InputStream input) {
        return this.readValue(type, elementType, new JsonReader().parse(input));
    }

    @Null
    public <T> T fromJson(@Null Class<T> type, File file) {
        try {
            return this.readValue(type, null, new JsonReader().parse(file));
        }
        catch (Exception ex) {
            throw new JsonException("Error reading file: " + file, ex);
        }
    }

    @Null
    public <T> T fromJson(@Null Class<T> type, @Null Class elementType, File file) {
        try {
            return this.readValue(type, elementType, new JsonReader().parse(file));
        }
        catch (Exception ex) {
            throw new JsonException("Error reading file: " + file, ex);
        }
    }

    @Null
    public <T> T fromJson(@Null Class<T> type, char[] data, int offset, int length) {
        return this.readValue(type, null, new JsonReader().parse(data, offset, length));
    }

    public <T> T fromJson(@Null Class<T> type, @Null Class elementType, char[] data, int offset, int length) {
        return this.readValue(type, elementType, new JsonReader().parse(data, offset, length));
    }

    @Null
    public <T> T fromJson(@Null Class<T> type, String json) {
        return this.readValue(type, null, new JsonReader().parse(json));
    }

    @Null
    public <T> T fromJson(@Null Class<T> type, @Null Class elementType, String json) {
        return this.readValue(type, elementType, new JsonReader().parse(json));
    }

    public void readField(Object object, String name, JsonValue jsonData) {
        this.readField(object, name, name, null, jsonData);
    }

    public void readField(Object object, String name, @Null Class elementType, JsonValue jsonData) {
        this.readField(object, name, name, elementType, jsonData);
    }

    public void readField(Object object, String fieldName, String jsonName, JsonValue jsonData) {
        this.readField(object, fieldName, jsonName, null, jsonData);
    }

    public void readField(Object object, String fieldName, String jsonName, @Null Class elementType, JsonValue jsonMap) {
        Class<?> type = object.getClass();
        OrderedMap<String, FieldMetadata> fields = this.getFields(type);
        FieldMetadata metadata = (FieldMetadata)fields.get(fieldName);
        if (metadata == null) {
            throw new JsonException("Field not found: " + fieldName + " (" + type.getName() + ")");
        }
        Field field = metadata.field;
        if (elementType == null) {
            elementType = metadata.elementType;
        }
        this.readField(object, field, jsonName, elementType, jsonMap);
    }

    public void readField(@Null Object object, Field field, String jsonName, @Null Class elementType, JsonValue jsonMap) {
        JsonValue jsonValue = jsonMap.get(jsonName);
        if (jsonValue == null) {
            return;
        }
        try {
            field.set(object, this.readValue(field.getType(), elementType, jsonValue));
        }
        catch (IllegalAccessException ex) {
            throw new JsonException("Error accessing field: " + field.getName() + " (" + field.getDeclaringClass().getName() + ")", ex);
        }
        catch (JsonException ex) {
            ex.addTrace(field.getName() + " (" + field.getDeclaringClass().getName() + ")");
            throw ex;
        }
        catch (RuntimeException runtimeEx) {
            JsonException ex = new JsonException(runtimeEx);
            ex.addTrace(field.getName() + " (" + field.getDeclaringClass().getName() + ")");
            throw ex;
        }
    }

    public void readFields(Object object, JsonValue jsonMap) {
        Class<?> type = object.getClass();
        OrderedMap<String, FieldMetadata> fields = this.getFields(type);
        JsonValue child = jsonMap.child;
        while (child != null) {
            FieldMetadata metadata = (FieldMetadata)fields.get(child.name().replace(" ", "_"));
            if (metadata == null) {
                if (!this.ignoreUnknownFields) {
                    throw new JsonException("Field not found: " + child.name() + " (" + type.getName() + ")");
                }
            } else {
                Field field = metadata.field;
                try {
                    field.set(object, this.readValue(field.getType(), metadata.elementType, child));
                }
                catch (IllegalAccessException ex) {
                    throw new JsonException("Error accessing field: " + field.getName() + " (" + type.getName() + ")", ex);
                }
                catch (JsonException ex) {
                    ex.addTrace(field.getName() + " (" + type.getName() + ")");
                    throw ex;
                }
                catch (RuntimeException runtimeEx) {
                    JsonException ex = new JsonException(runtimeEx);
                    ex.addTrace(field.getName() + " (" + type.getName() + ")");
                    throw ex;
                }
            }
            child = child.next;
        }
    }

    @Null
    public <T> T readValue(String name, @Null Class<T> type, JsonValue jsonMap) {
        return this.readValue(type, null, jsonMap.get(name));
    }

    @Null
    public <T> T readValue(String name, @Null Class<T> type, @Null T defaultValue, JsonValue jsonMap) {
        JsonValue jsonValue = jsonMap.get(name);
        if (jsonValue == null) {
            return defaultValue;
        }
        return this.readValue(type, null, jsonValue);
    }

    @Null
    public <T> T readValue(String name, @Null Class<T> type, @Null Class elementType, JsonValue jsonMap) {
        return this.readValue(type, elementType, jsonMap.get(name));
    }

    @Null
    public <T> T readValue(String name, @Null Class<T> type, @Null Class elementType, @Null T defaultValue, JsonValue jsonMap) {
        JsonValue jsonValue = jsonMap.get(name);
        if (jsonValue == null) {
            return defaultValue;
        }
        return this.readValue(type, elementType, jsonValue);
    }

    @Null
    public <T> T readValue(@Null Class<T> type, @Null Class elementType, @Null T defaultValue, JsonValue jsonData) {
        return this.readValue(type, elementType, jsonData);
    }

    @Null
    public <T> T readValue(@Null Class<T> type, JsonValue jsonData) {
        return this.readValue(type, null, jsonData);
    }

    @Null
    public <T> T readValue(@Null Class<T> type, @Null Class elementType, JsonValue jsonData) {
        if (jsonData == null) {
            return null;
        }
        if (jsonData.isObject()) {
            String className;
            String string = className = this.typeName == null ? null : jsonData.getString(this.typeName, null);
            if (className != null) {
                jsonData.remove(this.typeName);
                type = this.getClass(className);
                if (type == null) {
                    try {
                        type = Class.forName(className);
                    }
                    catch (ClassNotFoundException ex) {
                        throw new JsonException(ex);
                    }
                }
            }
            if (type == null) {
                if (this.defaultSerializer != null) {
                    return this.defaultSerializer.read(this, jsonData, type);
                }
                return (T)jsonData;
            }
            if (type == String.class || type == Integer.class || type == Boolean.class || type == Float.class || type == Long.class || type == Double.class || type == Short.class || type == Byte.class || type == Character.class || Enum.class.isAssignableFrom(type)) {
                return (T)this.readValue("value", type, jsonData);
            }
            if (this.typeName != null && Collection.class.isAssignableFrom(type)) {
                if ((jsonData = jsonData.get("items")) == null) {
                    throw new JsonException("Unable to convert object to collection: " + jsonData + " (" + type.getName() + ")");
                }
            } else {
                JsonSerializer serializer = this.classToSerializer.get(type);
                if (serializer != null) {
                    return serializer.read(this, jsonData, type);
                }
                Object object = this.newInstance(type);
                if (object instanceof JsonSerializable) {
                    ((JsonSerializable)object).read(this, jsonData);
                    return (T)object;
                }
                if (object instanceof ObjectMap) {
                    ObjectMap result = (ObjectMap)object;
                    JsonValue child = jsonData.child;
                    while (child != null) {
                        result.put(child.name(), this.readValue(elementType, null, child));
                        child = child.next;
                    }
                    return (T)result;
                }
                if (object instanceof Map) {
                    Map result = (Map)object;
                    JsonValue child = jsonData.child;
                    while (child != null) {
                        result.put(child.name(), this.readValue(elementType, null, child));
                        child = child.next;
                    }
                    return (T)result;
                }
                this.readFields(object, jsonData);
                return (T)object;
            }
        }
        if (type != null) {
            JsonSerializer serializer = this.classToSerializer.get(type);
            if (serializer != null) {
                return serializer.read(this, jsonData, type);
            }
            if (JsonSerializable.class.isAssignableFrom(type)) {
                Object object = this.newInstance(type);
                ((JsonSerializable)object).read(this, jsonData);
                return (T)object;
            }
        }
        if (jsonData.isArray()) {
            if (type == null || type == Object.class) {
                type = ArrayList.class;
            }
            if (Collection.class.isAssignableFrom(type)) {
                Collection<?> result = type.isInterface() ? new ArrayList() : (Collection)this.newInstance(type);
                JsonValue child = jsonData.child;
                while (child != null) {
                    result.add(this.readValue(elementType, null, child));
                    child = child.next;
                }
                return (T)result;
            }
            if (type.isArray()) {
                Class<?> componentType = type.getComponentType();
                if (elementType == null) {
                    elementType = componentType;
                }
                Object result = Array.newInstance(componentType, jsonData.size);
                int i = 0;
                JsonValue child = jsonData.child;
                while (child != null) {
                    Array.set(result, i++, this.readValue(elementType, null, child));
                    child = child.next;
                }
                return (T)result;
            }
            throw new JsonException("Unable to convert value to required type: " + jsonData + " (" + type.getName() + ")");
        }
        if (jsonData.isNumber()) {
            try {
                if (type == null || type == Float.TYPE || type == Float.class) {
                    return (T)Float.valueOf(jsonData.asFloat());
                }
                if (type == Integer.TYPE || type == Integer.class) {
                    return (T)Integer.valueOf(jsonData.asInt());
                }
                if (type == Long.TYPE || type == Long.class) {
                    return (T)Long.valueOf(jsonData.asLong());
                }
                if (type == Double.TYPE || type == Double.class) {
                    return (T)Double.valueOf(jsonData.asDouble());
                }
                if (type == String.class) {
                    return (T)jsonData.asString();
                }
                if (type == Short.TYPE || type == Short.class) {
                    return (T)Short.valueOf(jsonData.asShort());
                }
                if (type == Byte.TYPE || type == Byte.class) {
                    return (T)Byte.valueOf(jsonData.asByte());
                }
            }
            catch (NumberFormatException componentType) {
                // empty catch block
            }
            jsonData = new JsonValue(jsonData.asString());
        }
        if (jsonData.isBoolean()) {
            try {
                if (type == null || type == Boolean.TYPE || type == Boolean.class) {
                    return (T)Boolean.valueOf(jsonData.asBoolean());
                }
            }
            catch (NumberFormatException componentType) {
                // empty catch block
            }
            jsonData = new JsonValue(jsonData.asString());
        }
        if (jsonData.isString()) {
            String string = jsonData.asString();
            if (type == null || type == String.class) {
                return (T)string;
            }
            try {
                if (type == Integer.TYPE || type == Integer.class) {
                    return (T)Integer.valueOf(string);
                }
                if (type == Float.TYPE || type == Float.class) {
                    return (T)Float.valueOf(string);
                }
                if (type == Long.TYPE || type == Long.class) {
                    return (T)Long.valueOf(string);
                }
                if (type == Double.TYPE || type == Double.class) {
                    return (T)Double.valueOf(string);
                }
                if (type == Short.TYPE || type == Short.class) {
                    return (T)Short.valueOf(string);
                }
                if (type == Byte.TYPE || type == Byte.class) {
                    return (T)Byte.valueOf(string);
                }
            }
            catch (NumberFormatException result) {
                // empty catch block
            }
            if (type == Boolean.TYPE || type == Boolean.class) {
                return (T)Boolean.valueOf(string);
            }
            if (type == Character.TYPE || type == Character.class) {
                return (T)Character.valueOf(string.charAt(0));
            }
            if (Enum.class.isAssignableFrom(type)) {
                for (Enum e : (Enum[])type.getEnumConstants()) {
                    if (!string.equals(this.convertToString(e))) continue;
                    return (T)e;
                }
            }
            if (type == CharSequence.class) {
                return (T)string;
            }
            throw new JsonException("Unable to convert value to required type: " + jsonData + " (" + type.getName() + ")");
        }
        return null;
    }

    private String convertToString(Enum e) {
        return this.enumNames ? e.name() : e.toString();
    }

    private String convertToString(Object object) {
        if (object instanceof Enum) {
            return this.convertToString((Enum)object);
        }
        if (object instanceof Class) {
            return ((Class)object).getName();
        }
        return String.valueOf(object);
    }

    protected Object newInstance(Class type) {
        try {
            return type.newInstance();
        }
        catch (Exception ex) {
            try {
                Constructor constructor = type.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return constructor.newInstance(new Object[0]);
            }
            catch (SecurityException constructor) {
            }
            catch (IllegalAccessException ignored) {
                if (Enum.class.isAssignableFrom(type)) {
                    if (type.getEnumConstants() == null) {
                        type = type.getSuperclass();
                    }
                    return type.getEnumConstants()[0];
                }
                if (type.isArray()) {
                    throw new JsonException("Encountered JSON object when expected array of type: " + type.getName(), ex);
                }
                if (type.isMemberClass() && !Modifier.isStatic(type.getModifiers())) {
                    throw new JsonException("Class cannot be created (non-static member class): " + type.getName(), ex);
                }
                throw new JsonException("Class cannot be created (missing no-arg constructor): " + type.getName(), ex);
            }
            catch (Exception privateConstructorException) {
                ex = privateConstructorException;
            }
            throw new JsonException("Error constructing instance of class: " + type.getName(), ex);
        }
    }

    public String prettyPrint(@Null Object object) {
        return this.prettyPrint(object, 0);
    }

    public String prettyPrint(String json) {
        return this.prettyPrint(json, 0);
    }

    public String prettyPrint(@Null Object object, int singleLineColumns) {
        return this.prettyPrint(this.toJson(object), singleLineColumns);
    }

    public String prettyPrint(String json, int singleLineColumns) {
        return new JsonReader().parse(json).prettyPrint(this.outputType, singleLineColumns);
    }

    public String prettyPrint(@Null Object object, JsonValue.PrettyPrintSettings settings) {
        return this.prettyPrint(this.toJson(object), settings);
    }

    public String prettyPrint(String json, JsonValue.PrettyPrintSettings settings) {
        return new JsonReader().parse(json).prettyPrint(settings);
    }

    private static class FieldMetadata {
        Field field;
        Class elementType;

        public FieldMetadata(Field field) {
            this.field = field;
            Type genericType = field.getGenericType();
            if (genericType instanceof ParameterizedType) {
                Type[] actualTypes = ((ParameterizedType)genericType).getActualTypeArguments();
                Type actualType = null;
                if (actualTypes.length == 1) {
                    actualType = actualTypes[0];
                } else if (actualTypes.length == 2 && Map.class.isAssignableFrom(field.getType())) {
                    actualType = actualTypes[1];
                }
                if (actualType != null) {
                    if (actualType instanceof Class) {
                        this.elementType = (Class)actualType;
                    } else if (actualType instanceof ParameterizedType) {
                        this.elementType = (Class)((ParameterizedType)actualType).getRawType();
                    }
                }
            }
        }
    }
}

