/*
 * Decompiled with CFR 0.152.
 */
package com.github.erosb.jsonsKema;

import com.github.erosb.jsonsKema.IJsonArray;
import com.github.erosb.jsonsKema.IJsonBoolean;
import com.github.erosb.jsonsKema.IJsonNull;
import com.github.erosb.jsonsKema.IJsonNumber;
import com.github.erosb.jsonsKema.IJsonObject;
import com.github.erosb.jsonsKema.IJsonString;
import com.github.erosb.jsonsKema.IJsonValue;
import com.github.erosb.jsonsKema.JsonVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0002J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0014\u0010\u0015\u001a\u00020\u00022\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00022\u000e\u0010\u0019\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001aH\u0016R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/github/erosb/jsonsKema/JsonPrintingVisitor;", "Lcom/github/erosb/jsonsKema/JsonVisitor;", "", "indentation", "<init>", "(Ljava/lang/String;)V", "indentLevel", "", "visitString", "str", "Lcom/github/erosb/jsonsKema/IJsonString;", "escape", "visitBoolean", "bool", "Lcom/github/erosb/jsonsKema/IJsonBoolean;", "visitNumber", "num", "Lcom/github/erosb/jsonsKema/IJsonNumber;", "visitNull", "nil", "Lcom/github/erosb/jsonsKema/IJsonNull;", "visitArray", "arr", "Lcom/github/erosb/jsonsKema/IJsonArray;", "visitObject", "obj", "Lcom/github/erosb/jsonsKema/IJsonObject;", "json-sKema"})
@SourceDebugExtension(value={"SMAP\nJsonPrintingVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonPrintingVisitor.kt\ncom/github/erosb/jsonsKema/JsonPrintingVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,47:1\n1557#2:48\n1628#2,3:49\n126#3:52\n153#3,3:53\n*S KotlinDebug\n*F\n+ 1 JsonPrintingVisitor.kt\ncom/github/erosb/jsonsKema/JsonPrintingVisitor\n*L\n22#1:48\n22#1:49,3\n37#1:52\n37#1:53,3\n*E\n"})
public final class JsonPrintingVisitor
implements JsonVisitor<String> {
    @NotNull
    private final String indentation;
    private int indentLevel;

    public JsonPrintingVisitor(@NotNull String indentation) {
        Intrinsics.checkNotNullParameter((Object)indentation, (String)"indentation");
        this.indentation = indentation;
    }

    public /* synthetic */ JsonPrintingVisitor(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "  ";
        }
        this(string);
    }

    @Override
    @NotNull
    public String visitString(@NotNull IJsonString str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        char c = '\"';
        String string = this.escape(str.getValue());
        return c + string + '\"';
    }

    private final String escape(String str) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)str, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null), (String)"\"", (String)"\\\"", (boolean)false, (int)4, null);
    }

    @Override
    @NotNull
    public String visitBoolean(@NotNull IJsonBoolean bool) {
        Intrinsics.checkNotNullParameter((Object)bool, (String)"bool");
        return String.valueOf(bool.getValue());
    }

    @Override
    @NotNull
    public String visitNumber(@NotNull IJsonNumber num) {
        Intrinsics.checkNotNullParameter((Object)num, (String)"num");
        return num.getValue().toString();
    }

    @Override
    @NotNull
    public String visitNull(@NotNull IJsonNull nil) {
        Intrinsics.checkNotNullParameter((Object)nil, (String)"nil");
        return "null";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String visitArray(@NotNull IJsonArray<?> arr) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(arr, (String)"arr");
        String baseIndent = StringsKt.repeat((CharSequence)this.indentation, (int)this.indentLevel);
        String nestedIndent = baseIndent + this.indentation;
        int n = this.indentLevel;
        this.indentLevel = n + 1;
        Object object = arr.getElements();
        boolean $i$f$map = false;
        String string = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void el;
            IJsonValue iJsonValue = (IJsonValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)el.accept(this));
        }
        List list = (List)destination$iv$iv;
        object = "[\n" + nestedIndent;
        String string2 = ",\n" + nestedIndent;
        string = '\n' + baseIndent + ']';
        String rval = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)string2, (CharSequence)((CharSequence)object), (CharSequence)string, (int)0, null, null, (int)56, null);
        int n2 = this.indentLevel;
        this.indentLevel = n2 + -1;
        return rval;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String visitObject(@NotNull IJsonObject<?, ?> obj) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(obj, (String)"obj");
        String baseIndent = StringsKt.repeat((CharSequence)this.indentation, (int)this.indentLevel);
        String nestedIndent = baseIndent + this.indentation;
        int n = this.indentLevel;
        this.indentLevel = n + 1;
        Object object = obj.getProperties();
        boolean $i$f$map = false;
        String string = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void entry;
            Map.Entry item$iv$iv;
            Map.Entry entry2 = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)((IJsonString)entry.getKey()).accept(this) + ": " + (String)((IJsonValue)entry.getValue()).accept(this));
        }
        List list = (List)destination$iv$iv;
        object = "{\n" + nestedIndent;
        String string2 = ",\n" + nestedIndent;
        string = '\n' + baseIndent + '}';
        String rval = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)string2, (CharSequence)((CharSequence)object), (CharSequence)string, (int)0, null, null, (int)56, null);
        int n2 = this.indentLevel;
        this.indentLevel = n2 + -1;
        return rval;
    }

    @Override
    @Nullable
    public String identity() {
        return JsonVisitor.DefaultImpls.identity(this);
    }

    @Override
    @Nullable
    public String accumulate(@Nullable String previous, @Nullable String current) {
        return JsonVisitor.DefaultImpls.accumulate(this, previous, current);
    }

    public JsonPrintingVisitor() {
        this(null, 1, null);
    }
}

