/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.loader.ArraySchemaLoader;
import org.everit.json.schema.loader.ExclusiveLimitHandler;
import org.everit.json.schema.loader.ExtractionResult;
import org.everit.json.schema.loader.JsonObject;
import org.everit.json.schema.loader.JsonValue;
import org.everit.json.schema.loader.LoaderConfig;
import org.everit.json.schema.loader.ObjectSchemaLoader;
import org.everit.json.schema.loader.PropertySnifferSchemaExtractor;
import org.everit.json.schema.loader.SchemaExtractor;
import org.everit.json.schema.loader.SchemaLoader;

abstract class AbstractSchemaExtractor
implements SchemaExtractor {
    static final List<String> NUMBER_SCHEMA_PROPS = Arrays.asList("minimum", "maximum", "exclusiveMinimum", "exclusiveMaximum", "multipleOf");
    static final List<String> STRING_SCHEMA_PROPS = Arrays.asList("minLength", "maxLength", "pattern", "format");
    protected JsonObject schemaJson;
    private Set<String> consumedKeys;
    final SchemaLoader defaultLoader;
    private ExclusiveLimitHandler exclusiveLimitHandler;

    AbstractSchemaExtractor(SchemaLoader defaultLoader) {
        this.defaultLoader = Objects.requireNonNull(defaultLoader, "defaultLoader cannot be null");
    }

    @Override
    public final ExtractionResult extract(JsonObject schemaJson) {
        this.schemaJson = Objects.requireNonNull(schemaJson, "schemaJson cannot be null");
        this.exclusiveLimitHandler = ExclusiveLimitHandler.ofSpecVersion(this.config().specVersion);
        this.consumedKeys = new HashSet<String>(schemaJson.keySet().size());
        return new ExtractionResult(this.consumedKeys, this.extract());
    }

    void keyConsumed(String key) {
        if (this.schemaJson.keySet().contains(key)) {
            this.consumedKeys.add(key);
        }
    }

    JsonValue require(String key) {
        this.keyConsumed(key);
        return this.schemaJson.require(key);
    }

    Optional<JsonValue> maybe(String key) {
        this.keyConsumed(key);
        return this.schemaJson.maybe(key);
    }

    boolean containsKey(String key) {
        return this.schemaJson.containsKey(key);
    }

    boolean schemaHasAnyOf(Collection<String> propNames) {
        return propNames.stream().anyMatch(this.schemaJson::containsKey);
    }

    LoaderConfig config() {
        return this.schemaJson.ls.config;
    }

    ObjectSchema.Builder buildObjectSchema() {
        this.config().specVersion.objectKeywords().forEach(this::keyConsumed);
        return new ObjectSchemaLoader(this.schemaJson.ls, this.config(), this.defaultLoader).load();
    }

    ArraySchema.Builder buildArraySchema() {
        this.config().specVersion.arrayKeywords().forEach(this::keyConsumed);
        return new ArraySchemaLoader(this.schemaJson.ls, this.config(), this.defaultLoader).load();
    }

    NumberSchema.Builder buildNumberSchema() {
        PropertySnifferSchemaExtractor.NUMBER_SCHEMA_PROPS.forEach(this::keyConsumed);
        NumberSchema.Builder builder = NumberSchema.builder();
        this.maybe("minimum").map(JsonValue::requireNumber).ifPresent(builder::minimum);
        this.maybe("maximum").map(JsonValue::requireNumber).ifPresent(builder::maximum);
        this.maybe("multipleOf").map(JsonValue::requireNumber).ifPresent(builder::multipleOf);
        this.maybe("exclusiveMinimum").ifPresent(exclMin -> this.exclusiveLimitHandler.handleExclusiveMinimum((JsonValue)exclMin, builder));
        this.maybe("exclusiveMaximum").ifPresent(exclMax -> this.exclusiveLimitHandler.handleExclusiveMaximum((JsonValue)exclMax, builder));
        return builder;
    }

    abstract List<Schema.Builder<?>> extract();
}

