/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.usb;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.os.Build;
import android.os.Handler;
import android.text.TextUtils;
import android.util.SparseArray;
import androidx.annotation.RequiresApi;
import com.jiangdg.usb.DeviceFilter;
import com.jiangdg.usb.USBVendorId;
import com.jiangdg.utils.BuildCheck;
import com.jiangdg.utils.HandlerThreadHandler;
import com.jiangdg.utils.XLogWrapper;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class USBMonitor {
    private static USBMonitor sInstance;
    public static boolean DEBUG;
    private static final String TAG = "USBMonitor";
    private static final String ACTION_USB_PERMISSION_BASE = "com.serenegiant.USB_PERMISSION.";
    private final String ACTION_USB_PERMISSION = "com.serenegiant.USB_PERMISSION." + this.hashCode();
    public static final String ACTION_USB_DEVICE_ATTACHED = "android.hardware.usb.action.USB_DEVICE_ATTACHED";
    private final ConcurrentHashMap<UsbDevice, UsbControlBlock> mCtrlBlocks = new ConcurrentHashMap();
    private final SparseArray<WeakReference<UsbDevice>> mHasPermissions = new SparseArray();
    private final WeakReference<Context> mWeakContext;
    private final UsbManager mUsbManager;
    private OnDeviceConnectListener mOnDeviceConnectListener;
    private PendingIntent mPermissionIntent = null;
    private List<DeviceFilter> mDeviceFilters = new ArrayList<DeviceFilter>();
    private final Handler mAsyncHandler;
    private volatile boolean destroyed;
    private final BroadcastReceiver mUsbReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            if (USBMonitor.this.destroyed) {
                XLogWrapper.w(USBMonitor.TAG, "onReceive: USBMonitor already destroyed, ignoring event");
                return;
            }
            String action = intent.getAction();
            XLogWrapper.i(USBMonitor.TAG, "onReceive: action=" + action);
            if (USBMonitor.this.ACTION_USB_PERMISSION.equals(action)) {
                USBMonitor uSBMonitor = USBMonitor.this;
                synchronized (uSBMonitor) {
                    UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                    if (device != null) {
                        boolean granted = intent.getBooleanExtra("permission", false);
                        XLogWrapper.i(USBMonitor.TAG, "onReceive: USB_PERMISSION for device=" + device.getDeviceName() + ", VendorId=" + device.getVendorId() + ", ProductId=" + device.getProductId() + ", granted=" + granted);
                        USBMonitor.this.updatePermission(device, granted);
                        if (granted) {
                            XLogWrapper.i(USBMonitor.TAG, "onReceive: Permission granted, processing connection");
                            USBMonitor.this.processConnect(device);
                        } else {
                            XLogWrapper.w(USBMonitor.TAG, "onReceive: Permission denied, processing cancellation");
                            USBMonitor.this.processCancel(device);
                        }
                    } else {
                        XLogWrapper.e(USBMonitor.TAG, "onReceive: USB_PERMISSION with null device");
                    }
                }
            }
            if (USBMonitor.ACTION_USB_DEVICE_ATTACHED.equals(action)) {
                UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                if (device != null) {
                    XLogWrapper.i(USBMonitor.TAG, "onReceive: USB_DEVICE_ATTACHED for device=" + device.getDeviceName() + ", VendorId=" + device.getVendorId() + ", ProductId=" + device.getProductId());
                    if (USBMonitor.this.hasPermission(device)) {
                        XLogWrapper.i(USBMonitor.TAG, "onReceive: Already have permission for attached device, processing connection");
                        USBMonitor.this.processConnect(device);
                    } else {
                        XLogWrapper.i(USBMonitor.TAG, "onReceive: Processing device attachment");
                        USBMonitor.this.processAttach(device);
                    }
                } else {
                    XLogWrapper.e(USBMonitor.TAG, "onReceive: USB_DEVICE_ATTACHED with null device");
                }
            } else if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action)) {
                UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                if (device != null) {
                    XLogWrapper.i(USBMonitor.TAG, "onReceive: USB_DEVICE_DETACHED for device=" + device.getDeviceName() + ", VendorId=" + device.getVendorId() + ", ProductId=" + device.getProductId());
                    UsbControlBlock ctrlBlock = (UsbControlBlock)USBMonitor.this.mCtrlBlocks.remove(device);
                    if (ctrlBlock != null) {
                        XLogWrapper.i(USBMonitor.TAG, "onReceive: Closing control block for detached device");
                        ctrlBlock.close();
                    }
                    SparseArray sparseArray = USBMonitor.this.mHasPermissions;
                    synchronized (sparseArray) {
                        int deviceKey = USBMonitor.getDeviceKey(device, true);
                        if (USBMonitor.this.mHasPermissions.get(deviceKey) != null) {
                            XLogWrapper.i(USBMonitor.TAG, "onReceive: Removing detached device from permission cache");
                            USBMonitor.this.mHasPermissions.remove(deviceKey);
                        }
                    }
                    XLogWrapper.i(USBMonitor.TAG, "onReceive: Processing device detachment");
                    USBMonitor.this.processDettach(device);
                } else {
                    XLogWrapper.e(USBMonitor.TAG, "onReceive: USB_DEVICE_DETACHED with null device");
                }
            }
        }
    };
    private volatile int mDeviceCounts = 0;
    private final Runnable mDeviceCheckRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int m;
            int hasPermissionCounts;
            if (USBMonitor.this.destroyed) {
                return;
            }
            List<UsbDevice> devices = USBMonitor.this.getDeviceList();
            int n = devices.size();
            boolean needsPermissionCheck = false;
            SparseArray sparseArray = USBMonitor.this.mHasPermissions;
            synchronized (sparseArray) {
                hasPermissionCounts = USBMonitor.this.mHasPermissions.size();
                if (n != USBMonitor.this.mDeviceCounts) {
                    needsPermissionCheck = true;
                    if (DEBUG) {
                        XLogWrapper.i(USBMonitor.TAG, "Device count changed from " + USBMonitor.this.mDeviceCounts + " to " + n + ", checking permissions");
                    }
                }
                if (needsPermissionCheck) {
                    USBMonitor.this.mHasPermissions.clear();
                    for (UsbDevice device : devices) {
                        USBMonitor.this.hasPermission(device);
                    }
                } else {
                    for (UsbDevice device : devices) {
                        USBMonitor.this.hasPermission(device);
                    }
                }
                m = USBMonitor.this.mHasPermissions.size();
            }
            if (n > USBMonitor.this.mDeviceCounts || m > hasPermissionCounts) {
                USBMonitor.this.mDeviceCounts = n;
                if (USBMonitor.this.mOnDeviceConnectListener != null) {
                    for (int i = 0; i < n; ++i) {
                        final UsbDevice device = devices.get(i);
                        USBMonitor.this.mAsyncHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                USBMonitor.this.mOnDeviceConnectListener.onAttach(device);
                            }
                        });
                    }
                }
            }
            long nextCheckDelay = needsPermissionCheck ? 2000L : 5000L;
            USBMonitor.this.mAsyncHandler.postDelayed((Runnable)this, nextCheckDelay);
        }
    };
    private static final int USB_DIR_OUT = 0;
    private static final int USB_DIR_IN = 128;
    private static final int USB_TYPE_MASK = 96;
    private static final int USB_TYPE_STANDARD = 0;
    private static final int USB_TYPE_CLASS = 32;
    private static final int USB_TYPE_VENDOR = 64;
    private static final int USB_TYPE_RESERVED = 96;
    private static final int USB_RECIP_MASK = 31;
    private static final int USB_RECIP_DEVICE = 0;
    private static final int USB_RECIP_INTERFACE = 1;
    private static final int USB_RECIP_ENDPOINT = 2;
    private static final int USB_RECIP_OTHER = 3;
    private static final int USB_RECIP_PORT = 4;
    private static final int USB_RECIP_RPIPE = 5;
    private static final int USB_REQ_GET_STATUS = 0;
    private static final int USB_REQ_CLEAR_FEATURE = 1;
    private static final int USB_REQ_SET_FEATURE = 3;
    private static final int USB_REQ_SET_ADDRESS = 5;
    private static final int USB_REQ_GET_DESCRIPTOR = 6;
    private static final int USB_REQ_SET_DESCRIPTOR = 7;
    private static final int USB_REQ_GET_CONFIGURATION = 8;
    private static final int USB_REQ_SET_CONFIGURATION = 9;
    private static final int USB_REQ_GET_INTERFACE = 10;
    private static final int USB_REQ_SET_INTERFACE = 11;
    private static final int USB_REQ_SYNCH_FRAME = 12;
    private static final int USB_REQ_SET_SEL = 48;
    private static final int USB_REQ_SET_ISOCH_DELAY = 49;
    private static final int USB_REQ_SET_ENCRYPTION = 13;
    private static final int USB_REQ_GET_ENCRYPTION = 14;
    private static final int USB_REQ_RPIPE_ABORT = 14;
    private static final int USB_REQ_SET_HANDSHAKE = 15;
    private static final int USB_REQ_RPIPE_RESET = 15;
    private static final int USB_REQ_GET_HANDSHAKE = 16;
    private static final int USB_REQ_SET_CONNECTION = 17;
    private static final int USB_REQ_SET_SECURITY_DATA = 18;
    private static final int USB_REQ_GET_SECURITY_DATA = 19;
    private static final int USB_REQ_SET_WUSB_DATA = 20;
    private static final int USB_REQ_LOOPBACK_DATA_WRITE = 21;
    private static final int USB_REQ_LOOPBACK_DATA_READ = 22;
    private static final int USB_REQ_SET_INTERFACE_DS = 23;
    private static final int USB_REQ_STANDARD_DEVICE_SET = 0;
    private static final int USB_REQ_STANDARD_DEVICE_GET = 128;
    private static final int USB_REQ_STANDARD_INTERFACE_SET = 1;
    private static final int USB_REQ_STANDARD_INTERFACE_GET = 129;
    private static final int USB_REQ_STANDARD_ENDPOINT_SET = 2;
    private static final int USB_REQ_STANDARD_ENDPOINT_GET = 130;
    private static final int USB_REQ_CS_DEVICE_SET = 32;
    private static final int USB_REQ_CS_DEVICE_GET = 160;
    private static final int USB_REQ_CS_INTERFACE_SET = 33;
    private static final int USB_REQ_CS_INTERFACE_GET = 161;
    private static final int USB_REQ_CS_ENDPOINT_SET = 34;
    private static final int USB_REQ_CS_ENDPOINT_GET = 162;
    private static final int USB_REQ_VENDER_DEVICE_SET = 32;
    private static final int USB_REQ_VENDER_DEVICE_GET = 160;
    private static final int USB_REQ_VENDER_INTERFACE_SET = 33;
    private static final int USB_REQ_VENDER_INTERFACE_GET = 161;
    private static final int USB_REQ_VENDER_ENDPOINT_SET = 34;
    private static final int USB_REQ_VENDER_ENDPOINT_GET = 162;
    private static final int USB_DT_DEVICE = 1;
    private static final int USB_DT_CONFIG = 2;
    private static final int USB_DT_STRING = 3;
    private static final int USB_DT_INTERFACE = 4;
    private static final int USB_DT_ENDPOINT = 5;
    private static final int USB_DT_DEVICE_QUALIFIER = 6;
    private static final int USB_DT_OTHER_SPEED_CONFIG = 7;
    private static final int USB_DT_INTERFACE_POWER = 8;
    private static final int USB_DT_OTG = 9;
    private static final int USB_DT_DEBUG = 10;
    private static final int USB_DT_INTERFACE_ASSOCIATION = 11;
    private static final int USB_DT_SECURITY = 12;
    private static final int USB_DT_KEY = 13;
    private static final int USB_DT_ENCRYPTION_TYPE = 14;
    private static final int USB_DT_BOS = 15;
    private static final int USB_DT_DEVICE_CAPABILITY = 16;
    private static final int USB_DT_WIRELESS_ENDPOINT_COMP = 17;
    private static final int USB_DT_WIRE_ADAPTER = 33;
    private static final int USB_DT_RPIPE = 34;
    private static final int USB_DT_CS_RADIO_CONTROL = 35;
    private static final int USB_DT_PIPE_USAGE = 36;
    private static final int USB_DT_SS_ENDPOINT_COMP = 48;
    private static final int USB_DT_CS_DEVICE = 33;
    private static final int USB_DT_CS_CONFIG = 34;
    private static final int USB_DT_CS_STRING = 35;
    private static final int USB_DT_CS_INTERFACE = 36;
    private static final int USB_DT_CS_ENDPOINT = 37;
    private static final int USB_DT_DEVICE_SIZE = 18;

    public static synchronized USBMonitor getInstance(Context context) {
        if (sInstance == null) {
            XLogWrapper.i(TAG, "Creating new USBMonitor singleton instance");
            sInstance = new USBMonitor(context);
        } else {
            XLogWrapper.i(TAG, "Returning existing USBMonitor singleton instance");
        }
        return sInstance;
    }

    public void setOnDeviceConnectListener(OnDeviceConnectListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("OnDeviceConnectListener should not be null.");
        }
        XLogWrapper.i(TAG, "Setting device connect listener");
        this.mOnDeviceConnectListener = listener;
    }

    public static USBMonitor getSingletonInstance() {
        return sInstance;
    }

    private USBMonitor(Context context) {
        if (DEBUG) {
            XLogWrapper.v(TAG, "USBMonitor:Constructor");
        }
        this.mWeakContext = new WeakReference<Context>(context.getApplicationContext());
        this.mUsbManager = (UsbManager)context.getSystemService("usb");
        this.mAsyncHandler = HandlerThreadHandler.createHandler(TAG);
        this.destroyed = false;
        XLogWrapper.i(TAG, "USBMonitor:mUsbManager=" + this.mUsbManager);
    }

    public void destroy() {
        XLogWrapper.i(TAG, "destroy: Cleaning up USB monitor resources");
        this.unregister();
        if (!this.destroyed) {
            this.destroyed = true;
            Set keys = this.mCtrlBlocks.keySet();
            if (keys != null) {
                try {
                    for (UsbDevice key : keys) {
                        UsbControlBlock ctrlBlock = this.mCtrlBlocks.remove(key);
                        if (ctrlBlock == null) continue;
                        ctrlBlock.close();
                    }
                }
                catch (Exception e) {
                    XLogWrapper.e(TAG, "destroy:", e);
                }
            }
            this.mCtrlBlocks.clear();
            try {
                this.mAsyncHandler.getLooper().quit();
            }
            catch (Exception e) {
                XLogWrapper.e(TAG, "destroy:", e);
            }
            this.mOnDeviceConnectListener = null;
        }
        if (sInstance == this) {
            XLogWrapper.i(TAG, "destroy: Clearing singleton instance");
            sInstance = null;
        }
    }

    @SuppressLint(value={"UnspecifiedImmutableFlag", "WrongConstant"})
    public synchronized void register() throws IllegalStateException {
        if (this.destroyed) {
            XLogWrapper.e(TAG, "register failed: already destroyed");
            throw new IllegalStateException("already destroyed");
        }
        XLogWrapper.i(TAG, "register: initializing USB monitor");
        Context context = (Context)this.mWeakContext.get();
        if (context == null) {
            XLogWrapper.e(TAG, "register failed: context is null");
            return;
        }
        XLogWrapper.i(TAG, "register: creating permission intent");
        Intent intent = new Intent(this.ACTION_USB_PERMISSION);
        intent.setPackage(context.getPackageName());
        intent.addFlags(0x24000000);
        XLogWrapper.i(TAG, "register: added FLAG_ACTIVITY_SINGLE_TOP and FLAG_ACTIVITY_CLEAR_TOP to intent");
        try {
            int flags = 0x8000000;
            if (Build.VERSION.SDK_INT >= 34) {
                XLogWrapper.i(TAG, "register: Android 14+ detected, using FLAG_IMMUTABLE");
                flags |= 0x4000000;
            } else if (Build.VERSION.SDK_INT >= 31) {
                XLogWrapper.i(TAG, "register: Android 12+ detected, using FLAG_MUTABLE");
                flags |= 0x2000000;
            }
            XLogWrapper.i(TAG, "register: creating PendingIntent with flags: " + flags);
            this.mPermissionIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)flags);
            XLogWrapper.i(TAG, "register: permission intent created successfully");
        }
        catch (Exception e) {
            XLogWrapper.e(TAG, "register: failed to create permission intent", e);
            return;
        }
        try {
            XLogWrapper.i(TAG, "register: creating intent filter");
            IntentFilter filter = new IntentFilter(this.ACTION_USB_PERMISSION);
            filter.addAction(ACTION_USB_DEVICE_ATTACHED);
            filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
            try {
                context.unregisterReceiver(this.mUsbReceiver);
                XLogWrapper.i(TAG, "register: unregistered existing receiver");
            }
            catch (IllegalArgumentException e) {
                XLogWrapper.i(TAG, "register: no existing receiver to unregister");
            }
            if (Build.VERSION.SDK_INT >= 34) {
                int RECEIVER_NOT_EXPORTED = 4;
                context.registerReceiver(this.mUsbReceiver, filter, RECEIVER_NOT_EXPORTED);
                XLogWrapper.i(TAG, "register: registered receiver with RECEIVER_NOT_EXPORTED flag");
            } else {
                context.registerReceiver(this.mUsbReceiver, filter);
                XLogWrapper.i(TAG, "register: registered receiver with default flags");
            }
        }
        catch (Exception e) {
            XLogWrapper.e(TAG, "register: failed to register receiver", e);
            return;
        }
        this.mDeviceCounts = 0;
        this.mAsyncHandler.postDelayed(this.mDeviceCheckRunnable, 1000L);
        XLogWrapper.i(TAG, "register: USB monitor initialization complete, device check scheduled");
    }

    public synchronized void unregister() throws IllegalStateException {
        XLogWrapper.i(TAG, "unregister: cleaning up USB monitor resources");
        this.mDeviceCounts = 0;
        if (!this.destroyed) {
            XLogWrapper.i(TAG, "unregister: removing device check callbacks");
            this.mAsyncHandler.removeCallbacks(this.mDeviceCheckRunnable);
        }
        if (this.mPermissionIntent != null) {
            XLogWrapper.i(TAG, "unregister: permission intent exists, unregistering receiver");
            Context context = (Context)this.mWeakContext.get();
            try {
                if (context != null) {
                    context.unregisterReceiver(this.mUsbReceiver);
                    XLogWrapper.i(TAG, "unregister: successfully unregistered USB receiver");
                } else {
                    XLogWrapper.w(TAG, "unregister: context is null, cannot unregister receiver");
                }
            }
            catch (Exception e) {
                XLogWrapper.e(TAG, "unregister: failed to unregister receiver", e);
            }
            this.mPermissionIntent = null;
            XLogWrapper.i(TAG, "unregister: cleared permission intent");
        }
    }

    public synchronized boolean isRegistered() {
        return !this.destroyed && this.mPermissionIntent != null;
    }

    public void setDeviceFilter(DeviceFilter filter) throws IllegalStateException {
        if (this.destroyed) {
            throw new IllegalStateException("already destroyed");
        }
        this.mDeviceFilters.clear();
        this.mDeviceFilters.add(filter);
    }

    public void addDeviceFilter(DeviceFilter filter) throws IllegalStateException {
        if (this.destroyed) {
            throw new IllegalStateException("already destroyed");
        }
        this.mDeviceFilters.add(filter);
    }

    public void removeDeviceFilter(DeviceFilter filter) throws IllegalStateException {
        if (this.destroyed) {
            throw new IllegalStateException("already destroyed");
        }
        this.mDeviceFilters.remove(filter);
    }

    public void setDeviceFilter(List<DeviceFilter> filters) throws IllegalStateException {
        if (this.destroyed) {
            throw new IllegalStateException("already destroyed");
        }
        this.mDeviceFilters.clear();
        this.mDeviceFilters.addAll(filters);
    }

    public void addDeviceFilter(List<DeviceFilter> filters) throws IllegalStateException {
        if (this.destroyed) {
            throw new IllegalStateException("already destroyed");
        }
        this.mDeviceFilters.addAll(filters);
    }

    public void removeDeviceFilter(List<DeviceFilter> filters) throws IllegalStateException {
        if (this.destroyed) {
            throw new IllegalStateException("already destroyed");
        }
        this.mDeviceFilters.removeAll(filters);
    }

    public int getDeviceCount() throws IllegalStateException {
        if (this.destroyed) {
            throw new IllegalStateException("already destroyed");
        }
        return this.getDeviceList().size();
    }

    public List<UsbDevice> getDeviceList() throws IllegalStateException {
        if (this.destroyed) {
            throw new IllegalStateException("already destroyed");
        }
        return this.getDeviceList(this.mDeviceFilters);
    }

    public List<UsbDevice> getDeviceList(List<DeviceFilter> filters) throws IllegalStateException {
        if (this.destroyed) {
            throw new IllegalStateException("already destroyed");
        }
        HashMap deviceList = this.mUsbManager.getDeviceList();
        ArrayList<UsbDevice> result = new ArrayList<UsbDevice>();
        if (deviceList != null) {
            if (filters == null || filters.isEmpty()) {
                result.addAll(deviceList.values());
            } else {
                block0: for (UsbDevice device : deviceList.values()) {
                    for (DeviceFilter filter : filters) {
                        if ((filter == null || !filter.matches(device)) && (filter == null || filter.mSubclass != device.getDeviceSubclass())) continue;
                        if (filter.isExclude) continue block0;
                        result.add(device);
                        continue block0;
                    }
                }
            }
        }
        return result;
    }

    public List<UsbDevice> getDeviceList(DeviceFilter filter) throws IllegalStateException {
        if (this.destroyed) {
            throw new IllegalStateException("already destroyed");
        }
        HashMap deviceList = this.mUsbManager.getDeviceList();
        ArrayList<UsbDevice> result = new ArrayList<UsbDevice>();
        if (deviceList != null) {
            for (UsbDevice device : deviceList.values()) {
                if (filter != null && (!filter.matches(device) || filter.isExclude)) continue;
                result.add(device);
            }
        }
        return result;
    }

    public Iterator<UsbDevice> getDevices() throws IllegalStateException {
        if (this.destroyed) {
            throw new IllegalStateException("already destroyed");
        }
        Iterator iterator = null;
        HashMap list = this.mUsbManager.getDeviceList();
        if (list != null) {
            iterator = list.values().iterator();
        }
        return iterator;
    }

    public final void dumpDevices() {
        HashMap list = this.mUsbManager.getDeviceList();
        if (list != null) {
            Set keys = list.keySet();
            if (keys != null && keys.size() > 0) {
                StringBuilder sb = new StringBuilder();
                for (String key : keys) {
                    UsbDevice device = (UsbDevice)list.get(key);
                    int num_interface = device != null ? device.getInterfaceCount() : 0;
                    sb.setLength(0);
                    for (int i = 0; i < num_interface; ++i) {
                        sb.append(String.format(Locale.US, "interface%d:%s", i, device.getInterface(i).toString()));
                    }
                    XLogWrapper.i(TAG, "key=" + key + ":" + device + ":" + sb.toString());
                }
            } else {
                XLogWrapper.i(TAG, "no device");
            }
        } else {
            XLogWrapper.i(TAG, "no device");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasPermission(UsbDevice device) throws IllegalStateException {
        block13: {
            if (device == null) {
                XLogWrapper.e(TAG, "hasPermission: device is null");
                return false;
            }
            if (this.destroyed) {
                XLogWrapper.e(TAG, "hasPermission failed: USBMonitor is destroyed");
                return false;
            }
            try {
                int deviceKey = USBMonitor.getDeviceKey(device, true);
                SparseArray<WeakReference<UsbDevice>> sparseArray = this.mHasPermissions;
                synchronized (sparseArray) {
                    WeakReference cachedDevice = (WeakReference)this.mHasPermissions.get(deviceKey);
                    if (cachedDevice != null && cachedDevice.get() != null) {
                        boolean systemHasPermission = this.mUsbManager.hasPermission(device);
                        if (systemHasPermission) {
                            return true;
                        }
                        if (DEBUG) {
                            XLogWrapper.i(TAG, "hasPermission: permission revoked for device: " + device.getDeviceName());
                        }
                        this.mHasPermissions.remove(deviceKey);
                        return false;
                    }
                }
            }
            catch (Exception e) {
                if (!DEBUG) break block13;
                XLogWrapper.e(TAG, "hasPermission: Error checking cache: " + e.getLocalizedMessage());
            }
        }
        if (DEBUG) {
            XLogWrapper.i(TAG, "hasPermission checking for device: " + device.getDeviceName() + ", VendorId: " + device.getVendorId() + ", ProductId: " + device.getProductId());
        }
        boolean systemHasPermission = this.mUsbManager.hasPermission(device);
        if (DEBUG) {
            XLogWrapper.i(TAG, "hasPermission: system reports permission: " + systemHasPermission);
        }
        boolean result = this.updatePermission(device, systemHasPermission);
        if (DEBUG) {
            XLogWrapper.i(TAG, "hasPermission: final result after updatePermission: " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updatePermission(UsbDevice device, boolean hasPermission) {
        if (device == null) {
            XLogWrapper.e(TAG, "updatePermission: device is null");
            return false;
        }
        try {
            int deviceKey = USBMonitor.getDeviceKey(device, true);
            if (DEBUG) {
                XLogWrapper.i(TAG, "updatePermission: device key = " + deviceKey);
            }
            SparseArray<WeakReference<UsbDevice>> sparseArray = this.mHasPermissions;
            synchronized (sparseArray) {
                boolean wasInCache;
                boolean bl = wasInCache = this.mHasPermissions.get(deviceKey) != null;
                if (hasPermission) {
                    if (!wasInCache) {
                        if (DEBUG) {
                            XLogWrapper.i(TAG, "updatePermission: adding device to permission cache: " + device.getDeviceName());
                        }
                        this.mHasPermissions.put(deviceKey, new WeakReference<UsbDevice>(device));
                    } else if (DEBUG) {
                        XLogWrapper.v(TAG, "updatePermission: device already in permission cache");
                    }
                } else if (wasInCache) {
                    if (DEBUG) {
                        XLogWrapper.i(TAG, "updatePermission: removing device from permission cache: " + device.getDeviceName());
                    }
                    this.mHasPermissions.remove(deviceKey);
                } else if (DEBUG) {
                    XLogWrapper.v(TAG, "updatePermission: device not in permission cache");
                }
            }
        }
        catch (SecurityException e) {
            XLogWrapper.e(TAG, "updatePermission: SecurityException: " + e.getLocalizedMessage(), e);
        }
        catch (Exception e) {
            XLogWrapper.e(TAG, "updatePermission: Exception: " + e.getLocalizedMessage(), e);
        }
        if (DEBUG) {
            XLogWrapper.v(TAG, "updatePermission: returning " + hasPermission);
        }
        return hasPermission;
    }

    public synchronized void resetDevicePermission(UsbDevice device) {
        if (device == null) {
            XLogWrapper.e(TAG, "resetDevicePermission: device is null");
            return;
        }
        XLogWrapper.i(TAG, "resetDevicePermission: " + device.getDeviceName() + ", VendorId: " + device.getVendorId() + ", ProductId: " + device.getProductId());
        boolean previousPermission = this.mUsbManager.hasPermission(device);
        this.updatePermission(device, false);
        XLogWrapper.i(TAG, "resetDevicePermission: permission before reset: " + previousPermission + ", after reset: " + this.mUsbManager.hasPermission(device));
        UsbControlBlock ctrlBlock = this.mCtrlBlocks.remove(device);
        if (ctrlBlock != null) {
            XLogWrapper.i(TAG, "resetDevicePermission: removing control block for device");
            ctrlBlock.close();
        } else {
            XLogWrapper.i(TAG, "resetDevicePermission: no control block found for device");
        }
        System.gc();
        try {
            XLogWrapper.i(TAG, "resetDevicePermission: sleeping for 200ms to ensure cleanup");
            Thread.sleep(200L);
            XLogWrapper.i(TAG, "resetDevicePermission: cleanup complete");
        }
        catch (InterruptedException e) {
            XLogWrapper.e(TAG, "resetDevicePermission: interrupted during cleanup", e);
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean requestPermission(UsbDevice device) {
        XLogWrapper.v(TAG, "requestPermission: device=" + (device != null ? device.getDeviceName() : "null"));
        boolean result = false;
        if (!this.isRegistered()) {
            XLogWrapper.e(TAG, "requestPermission failed: USBMonitor is not registered");
            XLogWrapper.e(TAG, "CRITICAL: Permission dialog will not show if USBMonitor is not registered");
            this.processCancel(device);
            return true;
        }
        if (device == null) {
            XLogWrapper.e(TAG, "requestPermission failed: device is null");
            this.processCancel(device);
            return true;
        }
        XLogWrapper.i(TAG, "requestPermission for device: " + device.getDeviceName() + ", VendorId: " + device.getVendorId() + ", ProductId: " + device.getProductId());
        Context context = (Context)this.mWeakContext.get();
        if (context == null) {
            XLogWrapper.e(TAG, "requestPermission failed: context is null or has been garbage collected");
            XLogWrapper.e(TAG, "CRITICAL: Permission dialog cannot be shown without valid context");
            this.processCancel(device);
            return true;
        }
        SharedPreferences prefs = context.getSharedPreferences("usb_monitor_prefs", 0);
        boolean firstRun = prefs.getBoolean("first_run", true);
        if (firstRun) {
            XLogWrapper.w(TAG, "FIRST RUN DETECTED: This is a fresh install, ensuring permission flow is correct");
            prefs.edit().putBoolean("first_run", false).apply();
        }
        if (Build.VERSION.SDK_INT >= 28) {
            XLogWrapper.i(TAG, "Android 9+ detected, resetting device permission first");
            this.resetDevicePermission(device);
            try {
                XLogWrapper.i(TAG, "Waiting 100ms after permission reset");
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                XLogWrapper.e(TAG, "Sleep interrupted", e);
                Thread.currentThread().interrupt();
            }
        }
        boolean hasPermission = this.mUsbManager.hasPermission(device);
        XLogWrapper.i(TAG, "Current permission status from UsbManager: " + (hasPermission ? "GRANTED" : "DENIED"));
        int deviceKey = USBMonitor.getDeviceKey(device, true);
        boolean inCache = false;
        SparseArray<WeakReference<UsbDevice>> sparseArray = this.mHasPermissions;
        synchronized (sparseArray) {
            inCache = this.mHasPermissions.get(deviceKey) != null;
        }
        XLogWrapper.i(TAG, "Permission status in internal cache: " + (inCache ? "GRANTED" : "DENIED") + ", deviceKey: " + deviceKey);
        if (hasPermission != inCache) {
            XLogWrapper.w(TAG, "PERMISSION STATE MISMATCH: UsbManager says " + (hasPermission ? "GRANTED" : "DENIED") + " but our cache says " + (inCache ? "GRANTED" : "DENIED"));
        }
        if (hasPermission) {
            XLogWrapper.i(TAG, "Permission already granted, processing connection");
            this.processConnect(device);
            return false;
        }
        try {
            if (this.mPermissionIntent == null) {
                XLogWrapper.e(TAG, "CRITICAL: Permission intent is null, cannot request permission");
                XLogWrapper.e(TAG, "This usually means register() was not called or failed");
                XLogWrapper.i(TAG, "Attempting to recreate permission intent as emergency fix");
                try {
                    Intent intent = new Intent(this.ACTION_USB_PERMISSION);
                    intent.setPackage(context.getPackageName());
                    intent.addFlags(0x24000000);
                    int flags = 0;
                    if (Build.VERSION.SDK_INT >= 31) {
                        flags = 0x2000000;
                    }
                    this.mPermissionIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)(flags |= 0x8000000));
                    XLogWrapper.i(TAG, "Emergency permission intent creation succeeded with flags: " + flags);
                }
                catch (Exception e) {
                    XLogWrapper.e(TAG, "Emergency permission intent creation failed", e);
                    this.processCancel(device);
                    return true;
                }
            }
            XLogWrapper.i(TAG, "Broadcast receiver status: " + (this.mUsbReceiver != null ? "initialized" : "NULL"));
            if (this.mUsbReceiver == null) {
                XLogWrapper.e(TAG, "CRITICAL: USB receiver is null, permission result cannot be received");
                this.processCancel(device);
                return true;
            }
            XLogWrapper.i(TAG, "About to request USB permission with:\n - Device: " + device.getDeviceName() + "\n - Permission Intent: " + this.mPermissionIntent + "\n - UsbManager: " + this.mUsbManager + "\n - Android version: " + Build.VERSION.SDK_INT);
            this.mUsbManager.requestPermission(device, this.mPermissionIntent);
            XLogWrapper.i(TAG, "Permission request sent successfully");
            try {
                XLogWrapper.i(TAG, "Waiting 100ms to check if permission was granted immediately");
                Thread.sleep(100L);
                boolean immediatePermission = this.mUsbManager.hasPermission(device);
                XLogWrapper.i(TAG, "Immediate permission check after request: " + (immediatePermission ? "GRANTED" : "DENIED/PENDING"));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return false;
        }
        catch (Exception e) {
            XLogWrapper.e(TAG, "requestPermission failed with exception", e);
            this.processCancel(device);
            return true;
        }
    }

    public UsbControlBlock openDevice(UsbDevice device) throws SecurityException {
        if (device == null) {
            XLogWrapper.e(TAG, "openDevice: device is null");
            throw new IllegalArgumentException("device is null");
        }
        XLogWrapper.i(TAG, "openDevice: " + device.getDeviceName() + ", VendorId: " + device.getVendorId() + ", ProductId: " + device.getProductId());
        boolean hasPermission = this.hasPermission(device);
        XLogWrapper.i(TAG, "openDevice: has permission: " + hasPermission);
        if (hasPermission) {
            UsbControlBlock result = this.mCtrlBlocks.get(device);
            if (result == null) {
                XLogWrapper.i(TAG, "openDevice: creating new UsbControlBlock");
                try {
                    result = new UsbControlBlock(this, device);
                    this.mCtrlBlocks.put(device, result);
                    XLogWrapper.i(TAG, "openDevice: successfully created UsbControlBlock");
                }
                catch (Exception e) {
                    XLogWrapper.e(TAG, "openDevice: failed to create UsbControlBlock", e);
                    throw new RuntimeException("Failed to open device: " + e.getMessage(), e);
                }
            } else {
                XLogWrapper.i(TAG, "openDevice: reusing existing UsbControlBlock");
            }
            return result;
        }
        XLogWrapper.e(TAG, "openDevice: no permission for device " + device.getDeviceName());
        throw new SecurityException("No permission to access USB device");
    }

    private void processConnect(UsbDevice device) {
        if (this.destroyed) {
            return;
        }
        this.updatePermission(device, true);
        this.mAsyncHandler.post(() -> {
            boolean createNew;
            UsbControlBlock ctrlBlock;
            if (DEBUG) {
                XLogWrapper.v(TAG, "processConnect:device=" + device.getDeviceName());
            }
            if ((ctrlBlock = this.mCtrlBlocks.get(device)) == null) {
                ctrlBlock = new UsbControlBlock(this, device);
                this.mCtrlBlocks.put(device, ctrlBlock);
                createNew = true;
            } else {
                createNew = false;
            }
            if (this.mOnDeviceConnectListener != null) {
                if (ctrlBlock.getConnection() == null) {
                    XLogWrapper.e(TAG, "processConnect: Open device failed");
                    this.mOnDeviceConnectListener.onCancel(device);
                    return;
                }
                this.mOnDeviceConnectListener.onConnect(device, ctrlBlock, createNew);
            }
        });
    }

    private void processCancel(final UsbDevice device) {
        if (this.destroyed) {
            XLogWrapper.w(TAG, "processCancel: USBMonitor already destroyed, ignoring");
            return;
        }
        XLogWrapper.i(TAG, "processCancel: Processing permission denial for device: " + (device != null ? device.getDeviceName() + ", VendorId: " + device.getVendorId() + ", ProductId: " + device.getProductId() : "null"));
        SharedPreferences prefs = null;
        boolean isFirstRun = false;
        Context context = (Context)this.mWeakContext.get();
        if (context != null && (isFirstRun = (prefs = context.getSharedPreferences("usb_monitor_prefs", 0)).getBoolean("first_run", true))) {
            XLogWrapper.w(TAG, "processCancel: This appears to be a first run, permission dialog may not have been shown");
            prefs.edit().putBoolean("first_run", false).apply();
            if (device != null) {
                XLogWrapper.i(TAG, "processCancel: First run detected, trying to request permission again");
                this.mAsyncHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        USBMonitor.this.requestPermission(device);
                    }
                }, 500L);
                return;
            }
        }
        XLogWrapper.i(TAG, "processCancel: Permission intent status: " + (this.mPermissionIntent != null ? "valid" : "NULL"));
        boolean previousPermission = device != null && this.mUsbManager.hasPermission(device);
        XLogWrapper.i(TAG, "processCancel: System permission before update: " + previousPermission);
        this.updatePermission(device, false);
        XLogWrapper.i(TAG, "processCancel: Updated internal permission cache to DENIED");
        if (this.mOnDeviceConnectListener != null) {
            XLogWrapper.i(TAG, "processCancel: Notifying listener about cancellation");
            this.mAsyncHandler.post(new Runnable(){

                @Override
                public void run() {
                    USBMonitor.this.mOnDeviceConnectListener.onCancel(device);
                    XLogWrapper.i(USBMonitor.TAG, "processCancel: Listener notified");
                }
            });
        } else {
            XLogWrapper.w(TAG, "processCancel: No listener registered to notify about cancellation");
        }
    }

    private void processAttach(final UsbDevice device) {
        if (this.destroyed) {
            return;
        }
        if (DEBUG) {
            XLogWrapper.v(TAG, "processAttach:");
        }
        if (this.mOnDeviceConnectListener != null) {
            this.mAsyncHandler.post(new Runnable(){

                @Override
                public void run() {
                    USBMonitor.this.mOnDeviceConnectListener.onAttach(device);
                }
            });
        }
    }

    private void processDettach(final UsbDevice device) {
        if (this.destroyed) {
            return;
        }
        if (DEBUG) {
            XLogWrapper.v(TAG, "processDettach:");
        }
        if (this.mOnDeviceConnectListener != null) {
            this.mAsyncHandler.post(new Runnable(){

                @Override
                public void run() {
                    USBMonitor.this.mOnDeviceConnectListener.onDetach(device);
                }
            });
        }
    }

    public static final String getDeviceKeyName(UsbDevice device) {
        return USBMonitor.getDeviceKeyName(device, null, false);
    }

    public static final String getDeviceKeyName(UsbDevice device, boolean useNewAPI) {
        return USBMonitor.getDeviceKeyName(device, null, useNewAPI);
    }

    @SuppressLint(value={"NewApi"})
    public static final String getDeviceKeyName(UsbDevice device, String serial, boolean useNewAPI) {
        if (device == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(device.getVendorId());
        sb.append("#");
        sb.append(device.getProductId());
        sb.append("#");
        sb.append(device.getDeviceClass());
        sb.append("#");
        sb.append(device.getDeviceSubclass());
        sb.append("#");
        sb.append(device.getDeviceProtocol());
        if (!TextUtils.isEmpty((CharSequence)serial)) {
            sb.append("#");
            sb.append(serial);
        }
        if (useNewAPI && BuildCheck.isAndroid5()) {
            sb.append("#");
            if (TextUtils.isEmpty((CharSequence)serial)) {
                try {
                    sb.append(device.getSerialNumber());
                    sb.append("#");
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            sb.append(device.getManufacturerName());
            sb.append("#");
            sb.append(device.getConfigurationCount());
            sb.append("#");
            if (BuildCheck.isMarshmallow()) {
                sb.append(device.getVersion());
                sb.append("#");
            }
        }
        return sb.toString();
    }

    public static final int getDeviceKey(UsbDevice device) {
        return device != null ? USBMonitor.getDeviceKeyName(device, null, false).hashCode() : 0;
    }

    public static final int getDeviceKey(UsbDevice device, boolean useNewAPI) {
        return device != null ? USBMonitor.getDeviceKeyName(device, null, useNewAPI).hashCode() : 0;
    }

    public static final int getDeviceKey(UsbDevice device, String serial, boolean useNewAPI) {
        return device != null ? USBMonitor.getDeviceKeyName(device, serial, useNewAPI).hashCode() : 0;
    }

    private static String getString(UsbDeviceConnection connection, int id, int languageCount, byte[] languages) {
        byte[] work = new byte[256];
        String result = null;
        for (int i = 1; i <= languageCount; ++i) {
            int ret = connection.controlTransfer(128, 6, 0x300 | id, (int)languages[i], work, 256, 0);
            if (ret <= 2 || work[0] != ret || work[1] != 3) continue;
            try {
                result = new String(work, 2, ret - 2, "UTF-16LE");
                if (!"\u0409".equals(result)) break;
                result = null;
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return result;
    }

    public UsbDeviceInfo getDeviceInfo(UsbDevice device) {
        return USBMonitor.updateDeviceInfo(this.mUsbManager, device, null);
    }

    public static UsbDeviceInfo getDeviceInfo(Context context, UsbDevice device) {
        return USBMonitor.updateDeviceInfo((UsbManager)context.getSystemService("usb"), device, new UsbDeviceInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=23)
    public static UsbDeviceInfo updateDeviceInfo(UsbManager manager, UsbDevice device, UsbDeviceInfo _info) {
        UsbDeviceInfo info = _info != null ? _info : new UsbDeviceInfo();
        info.clear();
        if (device != null) {
            if (BuildCheck.isLollipop()) {
                info.manufacturer = device.getManufacturerName();
                info.product = device.getProductName();
                info.serial = device.getSerialNumber();
            }
            if (BuildCheck.isMarshmallow()) {
                info.usb_version = device.getVersion();
            }
            if (manager != null && manager.hasPermission(device)) {
                UsbDeviceConnection connection = manager.openDevice(device);
                if (connection == null) {
                    return null;
                }
                byte[] desc = connection.getRawDescriptors();
                if (TextUtils.isEmpty((CharSequence)info.usb_version)) {
                    info.usb_version = String.format("%x.%02x", desc[3] & 0xFF, desc[2] & 0xFF);
                }
                if (TextUtils.isEmpty((CharSequence)info.version)) {
                    info.version = String.format("%x.%02x", desc[13] & 0xFF, desc[12] & 0xFF);
                }
                if (TextUtils.isEmpty((CharSequence)info.serial)) {
                    info.serial = connection.getSerial();
                }
                byte[] languages = new byte[256];
                int languageCount = 0;
                try {
                    int result = connection.controlTransfer(128, 6, 768, 0, languages, 256, 0);
                    if (result > 0) {
                        languageCount = (result - 2) / 2;
                    }
                    if (languageCount > 0) {
                        if (TextUtils.isEmpty((CharSequence)info.manufacturer)) {
                            info.manufacturer = USBMonitor.getString(connection, desc[14], languageCount, languages);
                        }
                        if (TextUtils.isEmpty((CharSequence)info.product)) {
                            info.product = USBMonitor.getString(connection, desc[15], languageCount, languages);
                        }
                        if (TextUtils.isEmpty((CharSequence)info.serial)) {
                            info.serial = USBMonitor.getString(connection, desc[16], languageCount, languages);
                        }
                    }
                }
                finally {
                    connection.close();
                }
            }
            if (TextUtils.isEmpty((CharSequence)info.manufacturer)) {
                info.manufacturer = USBVendorId.vendorName(device.getVendorId());
            }
            if (TextUtils.isEmpty((CharSequence)info.manufacturer)) {
                info.manufacturer = String.format("%04x", device.getVendorId());
            }
            if (TextUtils.isEmpty((CharSequence)info.product)) {
                info.product = String.format("%04x", device.getProductId());
            }
        }
        return info;
    }

    static {
        DEBUG = true;
    }

    public static interface OnDeviceConnectListener {
        public void onAttach(UsbDevice var1);

        public void onDetach(UsbDevice var1);

        public void onConnect(UsbDevice var1, UsbControlBlock var2, boolean var3);

        public void onDisconnect(UsbDevice var1, UsbControlBlock var2);

        public void onCancel(UsbDevice var1);
    }

    public static final class UsbControlBlock
    implements Cloneable {
        private final WeakReference<USBMonitor> mWeakMonitor;
        private final WeakReference<UsbDevice> mWeakDevice;
        protected UsbDeviceConnection mConnection;
        protected final UsbDeviceInfo mInfo;
        private final int mBusNum;
        private final int mDevNum;
        private final SparseArray<SparseArray<UsbInterface>> mInterfaces = new SparseArray();

        private UsbControlBlock(USBMonitor monitor, UsbDevice device) {
            if (DEBUG) {
                XLogWrapper.i(USBMonitor.TAG, "UsbControlBlock:constructor");
            }
            this.mWeakMonitor = new WeakReference<USBMonitor>(monitor);
            this.mWeakDevice = new WeakReference<UsbDevice>(device);
            this.mConnection = monitor.mUsbManager.openDevice(device);
            if (this.mConnection == null) {
                XLogWrapper.w(USBMonitor.TAG, "openDevice failed in UsbControlBlock11, wait and try again");
                int retryCount = 0;
                int maxRetries = Build.VERSION.SDK_INT >= 28 ? 5 : 3;
                long retryDelay = 500L;
                while (this.mConnection == null && retryCount < maxRetries) {
                    try {
                        Thread.sleep(retryDelay);
                        XLogWrapper.i(USBMonitor.TAG, "Retry attempt " + ++retryCount + " for device: " + device.getDeviceName());
                        this.mConnection = monitor.mUsbManager.openDevice(device);
                        retryDelay += 200L;
                    }
                    catch (InterruptedException e) {
                        XLogWrapper.e(USBMonitor.TAG, "Interrupted during retry", e);
                        break;
                    }
                }
                if (this.mConnection == null) {
                    XLogWrapper.e(USBMonitor.TAG, "Failed to open device after " + maxRetries + " attempts");
                }
            }
            this.mInfo = USBMonitor.updateDeviceInfo(monitor.mUsbManager, device, null);
            String name = device.getDeviceName();
            String[] v = !TextUtils.isEmpty((CharSequence)name) ? name.split("/") : null;
            int busnum = 0;
            int devnum = 0;
            if (v != null) {
                busnum = Integer.parseInt(v[v.length - 2]);
                devnum = Integer.parseInt(v[v.length - 1]);
            }
            this.mBusNum = busnum;
            this.mDevNum = devnum;
            if (DEBUG) {
                if (this.mConnection != null) {
                    int desc = this.mConnection.getFileDescriptor();
                    byte[] rawDesc = this.mConnection.getRawDescriptors();
                    XLogWrapper.i(USBMonitor.TAG, String.format(Locale.US, "name=%s,desc=%d,busnum=%d,devnum=%d,rawDesc=", name, desc, busnum, devnum));
                } else {
                    XLogWrapper.e(USBMonitor.TAG, "could not connect to device(mConnection=null) " + name);
                }
            }
        }

        private UsbControlBlock(UsbControlBlock src) throws IllegalStateException {
            USBMonitor monitor = src.getUSBMonitor();
            UsbDevice device = src.getDevice();
            if (device == null) {
                throw new IllegalStateException("device may already be removed");
            }
            this.mConnection = monitor.mUsbManager.openDevice(device);
            if (this.mConnection == null) {
                XLogWrapper.w(USBMonitor.TAG, "openDevice failed in UsbControlBlock, wait and try again");
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.mConnection = monitor.mUsbManager.openDevice(device);
                if (this.mConnection == null) {
                    throw new IllegalStateException("openDevice failed. device may already be removed or have no permission, dev = " + device);
                }
            }
            this.mInfo = USBMonitor.updateDeviceInfo(monitor.mUsbManager, device, null);
            this.mWeakMonitor = new WeakReference<USBMonitor>(monitor);
            this.mWeakDevice = new WeakReference<UsbDevice>(device);
            this.mBusNum = src.mBusNum;
            this.mDevNum = src.mDevNum;
        }

        public UsbControlBlock clone() throws CloneNotSupportedException {
            UsbControlBlock ctrlblock;
            try {
                ctrlblock = new UsbControlBlock(this);
            }
            catch (IllegalStateException e) {
                throw new CloneNotSupportedException(e.getMessage());
            }
            return ctrlblock;
        }

        public USBMonitor getUSBMonitor() {
            return (USBMonitor)this.mWeakMonitor.get();
        }

        public final UsbDevice getDevice() {
            return (UsbDevice)this.mWeakDevice.get();
        }

        public String getDeviceName() {
            UsbDevice device = (UsbDevice)this.mWeakDevice.get();
            return device != null ? device.getDeviceName() : "";
        }

        public int getDeviceId() {
            UsbDevice device = (UsbDevice)this.mWeakDevice.get();
            return device != null ? device.getDeviceId() : 0;
        }

        public String getDeviceKeyName() {
            return USBMonitor.getDeviceKeyName((UsbDevice)this.mWeakDevice.get());
        }

        public String getDeviceKeyName(boolean useNewAPI) throws IllegalStateException {
            if (useNewAPI) {
                this.checkConnection();
            }
            return USBMonitor.getDeviceKeyName((UsbDevice)this.mWeakDevice.get(), this.mInfo.serial, useNewAPI);
        }

        public int getDeviceKey() throws IllegalStateException {
            this.checkConnection();
            return USBMonitor.getDeviceKey((UsbDevice)this.mWeakDevice.get());
        }

        public int getDeviceKey(boolean useNewAPI) throws IllegalStateException {
            if (useNewAPI) {
                this.checkConnection();
            }
            return USBMonitor.getDeviceKey((UsbDevice)this.mWeakDevice.get(), this.mInfo.serial, useNewAPI);
        }

        public String getDeviceKeyNameWithSerial() {
            return USBMonitor.getDeviceKeyName((UsbDevice)this.mWeakDevice.get(), this.mInfo.serial, false);
        }

        public int getDeviceKeyWithSerial() {
            return this.getDeviceKeyNameWithSerial().hashCode();
        }

        public synchronized UsbDeviceConnection getConnection() {
            return this.mConnection;
        }

        public synchronized int getFileDescriptor() throws IllegalStateException {
            this.checkConnection();
            return this.mConnection.getFileDescriptor();
        }

        public synchronized byte[] getRawDescriptors() throws IllegalStateException {
            this.checkConnection();
            return this.mConnection.getRawDescriptors();
        }

        public int getVenderId() {
            UsbDevice device = (UsbDevice)this.mWeakDevice.get();
            return device != null ? device.getVendorId() : 0;
        }

        public int getProductId() {
            UsbDevice device = (UsbDevice)this.mWeakDevice.get();
            return device != null ? device.getProductId() : 0;
        }

        public String getUsbVersion() {
            return this.mInfo.usb_version;
        }

        public String getManufacture() {
            return this.mInfo.manufacturer;
        }

        public String getProductName() {
            return this.mInfo.product;
        }

        public String getVersion() {
            return this.mInfo.version;
        }

        public String getSerial() {
            return this.mInfo.serial;
        }

        public int getBusNum() {
            return this.mBusNum;
        }

        public int getDevNum() {
            return this.mDevNum;
        }

        public synchronized UsbInterface getInterface(int interface_id) throws IllegalStateException {
            return this.getInterface(interface_id, 0);
        }

        @RequiresApi(api=21)
        public synchronized UsbInterface getInterface(int interface_id, int altsetting) throws IllegalStateException {
            UsbInterface intf;
            this.checkConnection();
            SparseArray intfs = (SparseArray)this.mInterfaces.get(interface_id);
            if (intfs == null) {
                intfs = new SparseArray();
                this.mInterfaces.put(interface_id, (Object)intfs);
            }
            if ((intf = (UsbInterface)intfs.get(altsetting)) == null) {
                UsbDevice device = (UsbDevice)this.mWeakDevice.get();
                int n = device.getInterfaceCount();
                for (int i = 0; i < n; ++i) {
                    UsbInterface temp = device.getInterface(i);
                    if (temp.getId() != interface_id || temp.getAlternateSetting() != altsetting) continue;
                    intf = temp;
                    break;
                }
                if (intf != null) {
                    intfs.append(altsetting, (Object)intf);
                }
            }
            return intf;
        }

        public synchronized void claimInterface(UsbInterface intf) {
            this.claimInterface(intf, true);
        }

        public synchronized void claimInterface(UsbInterface intf, boolean force) {
            this.checkConnection();
            this.mConnection.claimInterface(intf, force);
        }

        public synchronized void releaseInterface(UsbInterface intf) throws IllegalStateException {
            this.checkConnection();
            SparseArray intfs = (SparseArray)this.mInterfaces.get(intf.getId());
            if (intfs != null) {
                int index = intfs.indexOfValue((Object)intf);
                intfs.removeAt(index);
                if (intfs.size() == 0) {
                    this.mInterfaces.remove(intf.getId());
                }
            }
            this.mConnection.releaseInterface(intf);
        }

        public synchronized void close() {
            if (DEBUG) {
                XLogWrapper.i(USBMonitor.TAG, "UsbControlBlock#close:");
            }
            if (this.mConnection != null) {
                int n = this.mInterfaces.size();
                for (int i = 0; i < n; ++i) {
                    SparseArray intfs = (SparseArray)this.mInterfaces.valueAt(i);
                    if (intfs == null) continue;
                    int m = intfs.size();
                    for (int j = 0; j < m; ++j) {
                        UsbInterface intf = (UsbInterface)intfs.valueAt(j);
                        this.mConnection.releaseInterface(intf);
                    }
                    intfs.clear();
                }
                this.mInterfaces.clear();
                this.mConnection.close();
                this.mConnection = null;
                USBMonitor monitor = (USBMonitor)this.mWeakMonitor.get();
                if (monitor != null) {
                    if (monitor.mOnDeviceConnectListener != null) {
                        monitor.mOnDeviceConnectListener.onDisconnect((UsbDevice)this.mWeakDevice.get(), this);
                    }
                    monitor.mCtrlBlocks.remove(this.getDevice());
                }
            }
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof UsbControlBlock) {
                UsbDevice device = ((UsbControlBlock)o).getDevice();
                return device == null ? this.mWeakDevice.get() == null : device.equals(this.mWeakDevice.get());
            }
            if (o instanceof UsbDevice) {
                return o.equals(this.mWeakDevice.get());
            }
            return super.equals(o);
        }

        private synchronized void checkConnection() throws IllegalStateException {
            if (this.mConnection == null) {
                throw new IllegalStateException("already closed");
            }
        }
    }

    public static class UsbDeviceInfo {
        public String usb_version;
        public String manufacturer;
        public String product;
        public String version;
        public String serial;

        private void clear() {
            this.serial = null;
            this.version = null;
            this.product = null;
            this.manufacturer = null;
            this.usb_version = null;
        }

        public String toString() {
            return String.format("UsbDevice:usb_version=%s,manufacturer=%s,product=%s,version=%s,serial=%s", this.usb_version != null ? this.usb_version : "", this.manufacturer != null ? this.manufacturer : "", this.product != null ? this.product : "", this.version != null ? this.version : "", this.serial != null ? this.serial : "");
        }
    }
}

