/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.View;
import com.jiangdg.ausbc.utils.Logger;
import com.jiangdg.ausbc.widget.IAspectRatio;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0001\u001eB\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001b\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u0005\u0010\tB#\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0005\u0010\fJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J\b\u0010\u0013\u001a\u00020\u000bH\u0016J\b\u0010\u0014\u001a\u00020\u000bH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\u0017\u001a\u00020\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u0019H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u000eH\u0002J\u0018\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000bH\u0014R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jiangdg/ausbc/widget/AspectRatioSurfaceView;", "Landroid/view/SurfaceView;", "Lcom/jiangdg/ausbc/widget/IAspectRatio;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "attributeSet", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "mAspectRatio", "", "setAspectRatio", "", "width", "height", "getSurfaceWidth", "getSurfaceHeight", "getSurface", "Landroid/view/Surface;", "postUITask", "task", "Lkotlin/Function0;", "aspectRatio", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "Companion", "libausbc_release"})
public final class AspectRatioSurfaceView
extends SurfaceView
implements IAspectRatio {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double mAspectRatio;
    @NotNull
    private static final String TAG = "AspectRatioTextureView";

    public AspectRatioSurfaceView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null);
    }

    public AspectRatioSurfaceView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attributeSet, 0);
    }

    public AspectRatioSurfaceView(@NotNull Context context, @Nullable AttributeSet attributeSet, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attributeSet, defStyleAttr);
        this.mAspectRatio = -1.0;
    }

    @Override
    public void setAspectRatio(int width, int height) {
        this.post(() -> AspectRatioSurfaceView.setAspectRatio$lambda$0(this, width, height));
    }

    @Override
    public int getSurfaceWidth() {
        return this.getMeasuredWidth();
    }

    @Override
    public int getSurfaceHeight() {
        return this.getMeasuredHeight();
    }

    @Override
    @NotNull
    public Surface getSurface() {
        Surface surface = this.getHolder().getSurface();
        Intrinsics.checkNotNullExpressionValue((Object)surface, (String)"getSurface(...)");
        return surface;
    }

    @Override
    public void postUITask(@NotNull Function0<Unit> task) {
        Intrinsics.checkNotNullParameter(task, (String)"task");
        this.post(() -> AspectRatioSurfaceView.postUITask$lambda$1(task));
    }

    private final void setAspectRatio(double aspectRatio) {
        if (aspectRatio < 0.0 || this.mAspectRatio == aspectRatio) {
            return;
        }
        this.mAspectRatio = aspectRatio;
        Logger.INSTANCE.i(TAG, "AspectRatio = " + this.mAspectRatio);
        this.requestLayout();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int initialWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int initialHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int horizontalPadding = this.getPaddingLeft() - this.getPaddingRight();
        int verticalPadding = this.getPaddingTop() - this.getPaddingBottom();
        double viewAspectRatio = (double)(initialWidth -= horizontalPadding) / (double)(initialHeight -= verticalPadding);
        double diff = this.mAspectRatio / viewAspectRatio - 1.0;
        int wMeasureSpec = widthMeasureSpec;
        int hMeasureSpec = heightMeasureSpec;
        if (this.mAspectRatio > 0.0 && Math.abs(diff) > 0.01) {
            if (diff > 0.0) {
                initialHeight = (int)((double)initialWidth / this.mAspectRatio);
            } else {
                initialWidth = (int)((double)initialHeight * this.mAspectRatio);
            }
            wMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(initialWidth += horizontalPadding), (int)0x40000000);
            hMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(initialHeight += verticalPadding), (int)0x40000000);
        }
        super.onMeasure(wMeasureSpec, hMeasureSpec);
    }

    private static final void setAspectRatio$lambda$0(AspectRatioSurfaceView this$0, int $width, int $height) {
        this$0.setAspectRatio((double)$width / (double)$height);
    }

    private static final void postUITask$lambda$1(Function0 $task) {
        $task.invoke();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jiangdg/ausbc/widget/AspectRatioSurfaceView$Companion;", "", "<init>", "()V", "TAG", "", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

