/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.utils;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Process;
import com.jiangdg.ausbc.utils.ActivityStackUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\u0006\u0010\b\u001a\u00020\u0005J\u0006\u0010\t\u001a\u00020\u0005J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u000b\u00a8\u0006\u0010"}, d2={"Lcom/jiangdg/ausbc/utils/AppUtils;", "", "<init>", "()V", "restartApp", "", "ctx", "Landroid/content/Context;", "releaseAppResource", "removeAllActivity", "getAppName", "", "isServiceRunning", "", "context", "className", "libausbc_release"})
public final class AppUtils {
    @NotNull
    public static final AppUtils INSTANCE = new AppUtils();

    private AppUtils() {
    }

    @SuppressLint(value={"UnspecifiedImmutableFlag"})
    public final void restartApp(@Nullable Context ctx) {
        Intent intent;
        if (ctx == null) {
            return;
        }
        PackageManager packageManager = ctx.getApplicationContext().getPackageManager();
        Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"getPackageManager(...)");
        PackageManager pckgManager = packageManager;
        Intent intent2 = intent = pckgManager.getLaunchIntentForPackage(ctx.getPackageName());
        if (intent2 != null) {
            intent2.addFlags(0x10000000);
        }
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)ctx.getApplicationContext(), (int)0, (Intent)intent, (int)0x40000000);
        Intrinsics.checkNotNullExpressionValue((Object)pendingIntent, (String)"getActivity(...)");
        PendingIntent pendingIntent2 = pendingIntent;
        Object object = ctx.getApplicationContext().getSystemService("alarm");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.AlarmManager");
        AlarmManager manager = (AlarmManager)object;
        manager.set(1, System.currentTimeMillis() + (long)1000, pendingIntent2);
    }

    public final void releaseAppResource() {
        Process.killProcess((int)Process.myPid());
        System.exit(0);
    }

    public final void removeAllActivity() {
        ActivityStackUtils.INSTANCE.popAllActivity();
    }

    @Nullable
    public final String getAppName(@NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        PackageManager packageManager = ctx.getPackageManager();
        Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"getPackageManager(...)");
        PackageManager packageManager2 = packageManager;
        try {
            PackageInfo packageInfo = packageManager2.getPackageInfo(ctx.getPackageName(), 0);
            Intrinsics.checkNotNullExpressionValue((Object)packageInfo, (String)"getPackageInfo(...)");
            PackageInfo packageInfo2 = packageInfo;
            int labelRes = packageInfo2.applicationInfo.labelRes;
            return ctx.getString(labelRes);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public final boolean isServiceRunning(@NotNull Context context, @NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        boolean isRunning = false;
        Object object = context.getSystemService("activity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.ActivityManager");
        ActivityManager activityManager = (ActivityManager)object;
        List services = activityManager.getRunningServices(Integer.MAX_VALUE);
        if (services != null && services.size() > 0) {
            for (ActivityManager.RunningServiceInfo service : services) {
                if (!Intrinsics.areEqual((Object)className, (Object)service.service.getClassName())) continue;
                isRunning = true;
                break;
            }
        }
        return isRunning;
    }
}

