/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.encode;

import android.media.AudioTrack;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Process;
import com.jiangdg.ausbc.callback.ICaptureCallBack;
import com.jiangdg.ausbc.callback.IEncodeDataCallBack;
import com.jiangdg.ausbc.callback.IPlayCallBack;
import com.jiangdg.ausbc.encode.AbstractProcessor;
import com.jiangdg.ausbc.encode.audio.AudioStrategySystem;
import com.jiangdg.ausbc.encode.audio.IAudioStrategy;
import com.jiangdg.ausbc.encode.bean.RawData;
import com.jiangdg.ausbc.utils.Logger;
import com.jiangdg.ausbc.utils.MediaUtils;
import com.jiangdg.ausbc.utils.Utils;
import com.jiangdg.natives.LameMp3;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 I2\u00020\u0001:\u0001IB\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010)\u001a\u00020*H\u0014J\b\u0010+\u001a\u00020,H\u0014J\b\u0010-\u001a\u00020,H\u0014J\u0010\u0010.\u001a\u00020\t2\u0006\u0010/\u001a\u00020(H\u0014J$\u00100\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u000203012\u0006\u00104\u001a\u0002032\u0006\u00105\u001a\u000206H\u0014J\u0012\u00107\u001a\u0004\u0018\u0001082\u0006\u00109\u001a\u000208H\u0014J\u0010\u0010:\u001a\u00020,2\b\u0010;\u001a\u0004\u0018\u00010<J\u0006\u0010=\u001a\u00020,J\u0018\u0010>\u001a\u00020,2\b\u0010?\u001a\u0004\u0018\u00010*2\u0006\u0010;\u001a\u00020@J\u0006\u0010A\u001a\u00020,J\b\u0010B\u001a\u00020,H\u0002J\b\u0010C\u001a\u00020,H\u0002J\b\u0010D\u001a\u00020,H\u0002J\b\u0010E\u001a\u00020,H\u0002J\u0018\u0010F\u001a\u00020,2\u0006\u0010G\u001a\u0002082\u0006\u0010H\u001a\u00020(H\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R!\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0012\u001a\u0004\b\u0014\u0010\u0010R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0012\u001a\u0004\b\u0018\u0010\u0019R\u001b\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0012\u001a\u0004\b\u001d\u0010\u001eR\u001b\u0010 \u001a\u00020\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u0012\u001a\u0004\b!\u0010\u001eR\u001b\u0010#\u001a\u00020\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\u0012\u001a\u0004\b$\u0010\u001eR\u000e\u0010&\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lcom/jiangdg/ausbc/encode/AACEncodeProcessor;", "Lcom/jiangdg/ausbc/encode/AbstractProcessor;", "strategy", "Lcom/jiangdg/ausbc/encode/audio/IAudioStrategy;", "<init>", "(Lcom/jiangdg/ausbc/encode/audio/IAudioStrategy;)V", "mAudioTrack", "Landroid/media/AudioTrack;", "mPresentationTimeUs", "", "mCountDownLatch", "Ljava/util/concurrent/CountDownLatch;", "mPlayQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/jiangdg/ausbc/encode/bean/RawData;", "getMPlayQueue", "()Ljava/util/concurrent/ConcurrentLinkedQueue;", "mPlayQueue$delegate", "Lkotlin/Lazy;", "mRecordMp3Queue", "getMRecordMp3Queue", "mRecordMp3Queue$delegate", "mAudioThreadPool", "Ljava/util/concurrent/ExecutorService;", "getMAudioThreadPool", "()Ljava/util/concurrent/ExecutorService;", "mAudioThreadPool$delegate", "mAudioRecordState", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getMAudioRecordState", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "mAudioRecordState$delegate", "mAudioPlayState", "getMAudioPlayState", "mAudioPlayState$delegate", "mRecordMp3State", "getMRecordMp3State", "mRecordMp3State$delegate", "mAudioRecord", "mSamplingRateIndex", "", "getThreadName", "", "handleStartEncode", "", "handleStopEncode", "getPTSUs", "bufferSize", "processOutputData", "Lkotlin/Pair;", "Lcom/jiangdg/ausbc/callback/IEncodeDataCallBack$DataType;", "Ljava/nio/ByteBuffer;", "encodeData", "bufferInfo", "Landroid/media/MediaCodec$BufferInfo;", "processInputData", "", "data", "playAudioStart", "callBack", "Lcom/jiangdg/ausbc/callback/IPlayCallBack;", "playAudioStop", "recordMp3Start", "audioPath", "Lcom/jiangdg/ausbc/callback/ICaptureCallBack;", "recordMp3Stop", "initAudioRecord", "releaseAudioRecord", "initAudioTrack", "releaseAudioTrack", "addADTStoPacket", "packet", "packetLen", "Companion", "libausbc_release"})
public final class AACEncodeProcessor
extends AbstractProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private AudioTrack mAudioTrack;
    private long mPresentationTimeUs;
    @Nullable
    private CountDownLatch mCountDownLatch;
    @NotNull
    private final Lazy mPlayQueue$delegate;
    @NotNull
    private final Lazy mRecordMp3Queue$delegate;
    @NotNull
    private final Lazy mAudioThreadPool$delegate;
    @NotNull
    private final Lazy mAudioRecordState$delegate;
    @NotNull
    private final Lazy mAudioPlayState$delegate;
    @NotNull
    private final Lazy mRecordMp3State$delegate;
    @NotNull
    private IAudioStrategy mAudioRecord;
    private int mSamplingRateIndex;
    @NotNull
    private static final String TAG = "AACEncodeProcessor";
    @NotNull
    private static final String MIME_TYPE = "audio/mp4a-latm";
    public static final int BIT_RATE = 32768;
    private static final int MAX_INPUT_SIZE = 48000;
    public static final int CHANNEL_OUT_CONFIG = 4;
    private static final int AUDIO_TRACK_MODE = 1;
    private static final int CODEC_AAC_PROFILE = 2;
    private static final int DEGREE_RECORD_MP3 = 7;

    public AACEncodeProcessor(@Nullable IAudioStrategy strategy) {
        super(false);
        this.mPlayQueue$delegate = LazyKt.lazy(AACEncodeProcessor::mPlayQueue_delegate$lambda$0);
        this.mRecordMp3Queue$delegate = LazyKt.lazy(AACEncodeProcessor::mRecordMp3Queue_delegate$lambda$1);
        this.mAudioThreadPool$delegate = LazyKt.lazy(AACEncodeProcessor::mAudioThreadPool_delegate$lambda$2);
        this.mAudioRecordState$delegate = LazyKt.lazy(AACEncodeProcessor::mAudioRecordState_delegate$lambda$3);
        this.mAudioPlayState$delegate = LazyKt.lazy(AACEncodeProcessor::mAudioPlayState_delegate$lambda$4);
        this.mRecordMp3State$delegate = LazyKt.lazy(AACEncodeProcessor::mRecordMp3State_delegate$lambda$5);
        IAudioStrategy iAudioStrategy = strategy;
        if (iAudioStrategy == null) {
            iAudioStrategy = new AudioStrategySystem();
        }
        this.mAudioRecord = iAudioStrategy;
        this.mSamplingRateIndex = -1;
    }

    public /* synthetic */ AACEncodeProcessor(IAudioStrategy iAudioStrategy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            iAudioStrategy = null;
        }
        this(iAudioStrategy);
    }

    private final ConcurrentLinkedQueue<RawData> getMPlayQueue() {
        Lazy lazy = this.mPlayQueue$delegate;
        return (ConcurrentLinkedQueue)lazy.getValue();
    }

    private final ConcurrentLinkedQueue<RawData> getMRecordMp3Queue() {
        Lazy lazy = this.mRecordMp3Queue$delegate;
        return (ConcurrentLinkedQueue)lazy.getValue();
    }

    private final ExecutorService getMAudioThreadPool() {
        Lazy lazy = this.mAudioThreadPool$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (ExecutorService)object;
    }

    private final AtomicBoolean getMAudioRecordState() {
        Lazy lazy = this.mAudioRecordState$delegate;
        return (AtomicBoolean)lazy.getValue();
    }

    private final AtomicBoolean getMAudioPlayState() {
        Lazy lazy = this.mAudioPlayState$delegate;
        return (AtomicBoolean)lazy.getValue();
    }

    private final AtomicBoolean getMRecordMp3State() {
        Lazy lazy = this.mRecordMp3State$delegate;
        return (AtomicBoolean)lazy.getValue();
    }

    @Override
    @NotNull
    protected String getThreadName() {
        return TAG;
    }

    @Override
    protected void handleStartEncode() {
        this.initAudioRecord();
        try {
            MediaFormat mediaFormat;
            int sampleRate = this.mAudioRecord.getSampleRate();
            int channelCount = this.mAudioRecord.getChannelCount();
            MediaFormat $this$handleStartEncode_u24lambda_u246 = mediaFormat = new MediaFormat();
            boolean bl = false;
            $this$handleStartEncode_u24lambda_u246.setString("mime", MIME_TYPE);
            $this$handleStartEncode_u24lambda_u246.setInteger("bitrate", 32768);
            $this$handleStartEncode_u24lambda_u246.setInteger("channel-count", channelCount);
            $this$handleStartEncode_u24lambda_u246.setInteger("sample-rate", sampleRate);
            $this$handleStartEncode_u24lambda_u246.setInteger("aac-profile", 2);
            $this$handleStartEncode_u24lambda_u246.setInteger("max-input-size", 48000);
            MediaFormat format = mediaFormat;
            boolean bl2 = false;
            this.setMMediaCodec(MediaCodec.createEncoderByType((String)MIME_TYPE));
            MediaCodec mediaCodec = this.getMMediaCodec();
            if (mediaCodec != null) {
                mediaCodec.configure(format, null, null, 1);
            }
            MediaCodec mediaCodec2 = this.getMMediaCodec();
            if (mediaCodec2 != null) {
                mediaCodec2.start();
            }
            this.getMEncodeState().set(true);
            if (Utils.INSTANCE.getDebugCamera()) {
                Logger.INSTANCE.i(TAG, "init aac media codec success.");
            }
            this.doEncodeData();
        }
        catch (Exception e) {
            Logger.INSTANCE.e(TAG, "init aac media codec failed, err = " + e.getLocalizedMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleStopEncode() {
        try {
            this.getMEncodeState().set(false);
            MediaCodec mediaCodec = this.getMMediaCodec();
            if (mediaCodec != null) {
                mediaCodec.stop();
            }
            MediaCodec mediaCodec2 = this.getMMediaCodec();
            if (mediaCodec2 != null) {
                mediaCodec2.release();
            }
            if (Utils.INSTANCE.getDebugCamera()) {
                Logger.INSTANCE.i(TAG, "release aac media codec success.");
            }
        }
        catch (Exception e) {
            Logger.INSTANCE.e(TAG, "release aac media codec failed, err = " + e.getLocalizedMessage(), e);
        }
        finally {
            this.releaseAudioRecord();
            this.getMRawDataQueue().clear();
            this.setMMediaCodec(null);
        }
    }

    @Override
    protected long getPTSUs(int bufferSize) {
        int sampleRate = this.mAudioRecord.getSampleRate();
        int channelCount = this.mAudioRecord.getChannelCount();
        int format = this.mAudioRecord.getAudioFormat();
        int formatBit = format == 2 ? 18 : 8;
        this.mPresentationTimeUs += (long)(1.0 * (double)bufferSize / (double)(sampleRate * channelCount * (formatBit / 8)) * 1000000.0);
        return this.mPresentationTimeUs;
    }

    @Override
    @NotNull
    protected Pair<IEncodeDataCallBack.DataType, ByteBuffer> processOutputData(@NotNull ByteBuffer encodeData, @NotNull MediaCodec.BufferInfo bufferInfo) {
        Intrinsics.checkNotNullParameter((Object)encodeData, (String)"encodeData");
        Intrinsics.checkNotNullParameter((Object)bufferInfo, (String)"bufferInfo");
        return new Pair((Object)IEncodeDataCallBack.DataType.AAC, (Object)encodeData);
    }

    @Override
    @Nullable
    protected byte[] processInputData(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return data;
    }

    public final void playAudioStart(@Nullable IPlayCallBack callBack) {
        this.getMAudioThreadPool().submit(() -> AACEncodeProcessor.playAudioStart$lambda$12(this, callBack));
    }

    public final void playAudioStop() {
        this.getMAudioPlayState().set(false);
    }

    public final void recordMp3Start(@Nullable String audioPath, @NotNull ICaptureCallBack callBack) {
        Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
        this.getMAudioThreadPool().submit(() -> AACEncodeProcessor.recordMp3Start$lambda$19(audioPath, this, callBack));
    }

    public final void recordMp3Stop() {
        this.getMRecordMp3State().set(false);
    }

    private final void initAudioRecord() {
        if (this.getMAudioRecordState().get()) {
            return;
        }
        this.getMAudioThreadPool().submit(() -> AACEncodeProcessor.initAudioRecord$lambda$20(this));
    }

    private final void releaseAudioRecord() {
        if (this.getMEncodeState().get() || this.getMAudioPlayState().get() || this.getMRecordMp3State().get()) {
            Logger.INSTANCE.w(TAG, "audio is using, cancel release");
            return;
        }
        this.getMAudioRecordState().set(false);
    }

    private final void initAudioTrack() {
        if (this.getMAudioPlayState().get()) {
            Logger.INSTANCE.w(TAG, "initAudioTracker has ready execute!");
            return;
        }
        int sampleRate = this.mAudioRecord.getSampleRate();
        int audioFormat = this.mAudioRecord.getAudioFormat();
        int channelCount = this.mAudioRecord.getChannelCount();
        int channelConfig = this.mAudioRecord.getChannelConfig();
        Logger.INSTANCE.i(TAG, "initAudioTrack: sample=" + sampleRate + ",format=" + audioFormat + ",count=" + channelCount);
        Process.setThreadPriority((int)-19);
        int minBufferSize = AudioTrack.getMinBufferSize((int)sampleRate, (int)channelConfig, (int)audioFormat);
        this.mAudioTrack = new AudioTrack(3, sampleRate, channelConfig, audioFormat, minBufferSize, 1);
        this.getMAudioPlayState().set(true);
    }

    private final void releaseAudioTrack() {
        try {
            AudioTrack audioTrack = this.mAudioTrack;
            if (audioTrack != null) {
                audioTrack.release();
            }
            this.mAudioTrack = null;
        }
        catch (Exception e) {
            Logger.INSTANCE.e(TAG, "releaseAudioTracker failed, err = " + e.getLocalizedMessage(), e);
        }
    }

    private final void addADTStoPacket(byte[] packet, int packetLen) {
        packet[0] = -1;
        packet[1] = -15;
        packet[2] = (byte)(64 + (this.mSamplingRateIndex << 2) + 0);
        packet[3] = (byte)(64 + (packetLen >> 11));
        packet[4] = (byte)((packetLen & 0x7FF) >> 3);
        packet[5] = (byte)(((packetLen & 7) << 5) + 31);
        packet[6] = -4;
    }

    private static final ConcurrentLinkedQueue mPlayQueue_delegate$lambda$0() {
        return new ConcurrentLinkedQueue();
    }

    private static final ConcurrentLinkedQueue mRecordMp3Queue_delegate$lambda$1() {
        return new ConcurrentLinkedQueue();
    }

    private static final ExecutorService mAudioThreadPool_delegate$lambda$2() {
        return Executors.newFixedThreadPool(3);
    }

    private static final AtomicBoolean mAudioRecordState_delegate$lambda$3() {
        return new AtomicBoolean(false);
    }

    private static final AtomicBoolean mAudioPlayState_delegate$lambda$4() {
        return new AtomicBoolean(false);
    }

    private static final AtomicBoolean mRecordMp3State_delegate$lambda$5() {
        return new AtomicBoolean(false);
    }

    private static final void playAudioStart$lambda$12$lambda$8(IPlayCallBack $callBack) {
        block0: {
            IPlayCallBack iPlayCallBack = $callBack;
            if (iPlayCallBack == null) break block0;
            iPlayCallBack.onBegin();
        }
    }

    private static final void playAudioStart$lambda$12$lambda$10(IPlayCallBack $callBack) {
        block0: {
            IPlayCallBack iPlayCallBack = $callBack;
            if (iPlayCallBack == null) break block0;
            iPlayCallBack.onComplete();
        }
    }

    private static final void playAudioStart$lambda$12$lambda$11(IPlayCallBack $callBack, Exception $e) {
        block1: {
            IPlayCallBack iPlayCallBack = $callBack;
            if (iPlayCallBack == null) break block1;
            String string = $e.getLocalizedMessage();
            if (string == null) {
                string = "unknown exception";
            }
            iPlayCallBack.onError(string);
        }
    }

    private static final void playAudioStart$lambda$12(AACEncodeProcessor this$0, IPlayCallBack $callBack) {
        try {
            this$0.mCountDownLatch = new CountDownLatch(1);
            this$0.initAudioRecord();
            CountDownLatch countDownLatch = this$0.mCountDownLatch;
            boolean bl = countDownLatch != null ? !countDownLatch.await(3L, TimeUnit.SECONDS) : false;
            if (bl) {
                IPlayCallBack iPlayCallBack = $callBack;
                if (iPlayCallBack != null) {
                    iPlayCallBack.onError("times out, init audio failed");
                }
                return;
            }
            this$0.initAudioTrack();
            this$0.getMMainHandler().post(() -> AACEncodeProcessor.playAudioStart$lambda$12$lambda$8($callBack));
            if (Utils.INSTANCE.getDebugCamera()) {
                Logger.INSTANCE.i(TAG, "start play mic success.");
            }
            while (this$0.getMAudioPlayState().get()) {
                RawData rawData;
                Integer state;
                AudioTrack audioTrack = this$0.mAudioTrack;
                Integer n = state = audioTrack != null ? Integer.valueOf(audioTrack.getState()) : null;
                int n2 = 1;
                if (n == null || n != n2) break;
                if (this$0.getMPlayQueue().poll() == null) continue;
                RawData $this$playAudioStart_u24lambda_u2412_u24lambda_u249 = rawData;
                boolean bl2 = false;
                AudioTrack audioTrack2 = this$0.mAudioTrack;
                if (audioTrack2 != null) {
                    audioTrack2.play();
                }
                AudioTrack audioTrack3 = this$0.mAudioTrack;
                if (audioTrack3 == null) continue;
                audioTrack3.write($this$playAudioStart_u24lambda_u2412_u24lambda_u249.getData(), 0, $this$playAudioStart_u24lambda_u2412_u24lambda_u249.getSize());
            }
            this$0.releaseAudioTrack();
            this$0.releaseAudioRecord();
            this$0.getMMainHandler().post(() -> AACEncodeProcessor.playAudioStart$lambda$12$lambda$10($callBack));
            if (Utils.INSTANCE.getDebugCamera()) {
                Logger.INSTANCE.i(TAG, "stop play mic success.");
            }
        }
        catch (Exception e) {
            this$0.getMMainHandler().post(() -> AACEncodeProcessor.playAudioStart$lambda$12$lambda$11($callBack, e));
            Logger.INSTANCE.e(TAG, "start/stop play mic failed, err = " + e.getLocalizedMessage(), e);
        }
    }

    private static final void recordMp3Start$lambda$19$lambda$13(ICaptureCallBack $callBack, String $audioPath) {
        $callBack.onError("save path(" + $audioPath + ") invalid");
    }

    private static final void recordMp3Start$lambda$19$lambda$14(ICaptureCallBack $callBack) {
        $callBack.onBegin();
    }

    private static final void recordMp3Start$lambda$19$lambda$16(ICaptureCallBack $callBack, Exception $e) {
        String string = $e.getLocalizedMessage();
        if (string == null) {
            string = "unknown exception";
        }
        $callBack.onError(string);
    }

    private static final void recordMp3Start$lambda$19$lambda$17(ICaptureCallBack $callBack, String $audioPath) {
        $callBack.onComplete($audioPath);
    }

    private static final void recordMp3Start$lambda$19$lambda$18(ICaptureCallBack $callBack, Exception $e) {
        String string = $e.getLocalizedMessage();
        if (string == null) {
            string = "unknown exception";
        }
        $callBack.onError(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void recordMp3Start$lambda$19(String $audioPath, AACEncodeProcessor this$0, ICaptureCallBack $callBack) {
        fos = null;
        try {
            block24: {
                block23: {
                    var4_4 = $audioPath;
                    if (!(var4_4 == null || var4_4.length() == 0)) break block23;
                    this$0.getMMainHandler().post((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, recordMp3Start$lambda$19$lambda$13(com.jiangdg.ausbc.callback.ICaptureCallBack java.lang.String ), ()V)((ICaptureCallBack)$callBack, (String)$audioPath));
                    ** try [egrp 1[TRYBLOCK] [0 : 48->100)] { 
lbl10:
                    // 1 sources

                    ** GOTO lbl-1000
                }
                this$0.mCountDownLatch = new CountDownLatch(1);
                this$0.initAudioRecord();
                v0 = this$0.mCountDownLatch;
                v1 = v0 != null ? !v0.await(3L, TimeUnit.SECONDS) : false;
                if (!v1) break block24;
                $callBack.onError("times out, init audio failed");
                ** try [egrp 3[TRYBLOCK] [1 : 215->267)] { 
lbl20:
                // 1 sources

                ** GOTO lbl-1000
            }
            file = new File($audioPath);
            if (file.exists()) {
                file.delete();
            }
            fos = new FileOutputStream(file);
            mp3Buf = new byte[2048];
            sampleRate = this$0.mAudioRecord.getSampleRate();
            channelCount = this$0.mAudioRecord.getChannelCount();
            if (Utils.INSTANCE.getDebugCamera()) {
                Logger.INSTANCE.i("AACEncodeProcessor", "start record mp3 success, " + sampleRate + ", " + channelCount + ", " + $audioPath);
            }
            LameMp3.INSTANCE.lameInit(sampleRate, channelCount, sampleRate, 32768, 7);
            this$0.getMMainHandler().post((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, recordMp3Start$lambda$19$lambda$14(com.jiangdg.ausbc.callback.ICaptureCallBack ), ()V)((ICaptureCallBack)$callBack));
            this$0.getMRecordMp3State().set(true);
            while (this$0.getMRecordMp3State().get()) {
                if (this$0.getMRecordMp3Queue().poll() == null) continue;
                $this$recordMp3Start_u24lambda_u2419_u24lambda_u2415 = var9_15;
                $i$a$-apply-AACEncodeProcessor$recordMp3Start$1$3 = false;
                tmpData = MediaUtils.INSTANCE.transferByte2Short($this$recordMp3Start_u24lambda_u2419_u24lambda_u2415.getData(), $this$recordMp3Start_u24lambda_u2419_u24lambda_u2415.getSize());
                encodeSize = LameMp3.INSTANCE.lameEncode(tmpData, null, tmpData.length, mp3Buf);
                Logger.INSTANCE.i("AACEncodeProcessor", "encode, " + $this$recordMp3Start_u24lambda_u2419_u24lambda_u2415.getSize() + ", " + encodeSize);
                if (encodeSize <= 0) continue;
                fos.write(mp3Buf, 0, encodeSize);
            }
            flushSize = LameMp3.INSTANCE.lameFlush(mp3Buf);
            if (flushSize > 0) {
                fos.write(mp3Buf, 0, flushSize);
            }
            ** try [egrp 5[TRYBLOCK] [2 : 639->694)] { 
lbl51:
            // 1 sources

            ** GOTO lbl-1000
        }
        catch (Exception e) {
            this$0.getMMainHandler().post((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, recordMp3Start$lambda$19$lambda$16(com.jiangdg.ausbc.callback.ICaptureCallBack java.lang.Exception ), ()V)((ICaptureCallBack)$callBack, (Exception)e));
            Logger.INSTANCE.e("AACEncodeProcessor", "start/stop record mp3 failed, err = " + e.getLocalizedMessage(), e);
            return;
        }
lbl-1000:
        // 1 sources

        {
            fos = null;
            LameMp3.INSTANCE.lameClose();
            this$0.releaseAudioRecord();
            this$0.getMMainHandler().post((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, recordMp3Start$lambda$19$lambda$17(com.jiangdg.ausbc.callback.ICaptureCallBack java.lang.String ), ()V)((ICaptureCallBack)$callBack, (String)$audioPath));
            if (Utils.INSTANCE.getDebugCamera() == false) return;
            Logger.INSTANCE.i("AACEncodeProcessor", "stop record mp3 success.");
            return;
        }
lbl68:
        // 1 sources

        catch (Exception e) {
            this$0.getMMainHandler().post((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, recordMp3Start$lambda$19$lambda$18(com.jiangdg.ausbc.callback.ICaptureCallBack java.lang.Exception ), ()V)((ICaptureCallBack)$callBack, (Exception)e));
            Logger.INSTANCE.e("AACEncodeProcessor", "stop record mp3 failed, err = " + e.getLocalizedMessage(), e);
        }
        return;
lbl-1000:
        // 1 sources

        {
            fos = null;
            LameMp3.INSTANCE.lameClose();
            this$0.releaseAudioRecord();
            this$0.getMMainHandler().post((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, recordMp3Start$lambda$19$lambda$17(com.jiangdg.ausbc.callback.ICaptureCallBack java.lang.String ), ()V)((ICaptureCallBack)$callBack, (String)$audioPath));
            if (Utils.INSTANCE.getDebugCamera() == false) return;
            Logger.INSTANCE.i("AACEncodeProcessor", "stop record mp3 success.");
            return;
        }
lbl81:
        // 1 sources

        catch (Exception e) {
            this$0.getMMainHandler().post((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, recordMp3Start$lambda$19$lambda$18(com.jiangdg.ausbc.callback.ICaptureCallBack java.lang.Exception ), ()V)((ICaptureCallBack)$callBack, (Exception)e));
            Logger.INSTANCE.e("AACEncodeProcessor", "stop record mp3 failed, err = " + e.getLocalizedMessage(), e);
        }
        return;
lbl-1000:
        // 1 sources

        {
            fos.close();
            fos = null;
            LameMp3.INSTANCE.lameClose();
            this$0.releaseAudioRecord();
            this$0.getMMainHandler().post((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, recordMp3Start$lambda$19$lambda$17(com.jiangdg.ausbc.callback.ICaptureCallBack java.lang.String ), ()V)((ICaptureCallBack)$callBack, (String)$audioPath));
            if (Utils.INSTANCE.getDebugCamera() == false) return;
            Logger.INSTANCE.i("AACEncodeProcessor", "stop record mp3 success.");
            return;
        }
lbl95:
        // 1 sources

        catch (Exception e) {
            this$0.getMMainHandler().post((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, recordMp3Start$lambda$19$lambda$18(com.jiangdg.ausbc.callback.ICaptureCallBack java.lang.Exception ), ()V)((ICaptureCallBack)$callBack, (Exception)e));
            Logger.INSTANCE.e("AACEncodeProcessor", "stop record mp3 failed, err = " + e.getLocalizedMessage(), e);
            return;
        }
        finally {
            try {
                v2 = fos;
                if (v2 != null) {
                    v2.close();
                }
                fos = null;
                LameMp3.INSTANCE.lameClose();
                this$0.releaseAudioRecord();
                this$0.getMMainHandler().post((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, recordMp3Start$lambda$19$lambda$17(com.jiangdg.ausbc.callback.ICaptureCallBack java.lang.String ), ()V)((ICaptureCallBack)$callBack, (String)$audioPath));
                if (Utils.INSTANCE.getDebugCamera()) {
                    Logger.INSTANCE.i("AACEncodeProcessor", "stop record mp3 success.");
                }
            }
            catch (Exception e) {
                this$0.getMMainHandler().post((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, recordMp3Start$lambda$19$lambda$18(com.jiangdg.ausbc.callback.ICaptureCallBack java.lang.Exception ), ()V)((ICaptureCallBack)$callBack, (Exception)e));
                Logger.INSTANCE.e("AACEncodeProcessor", "stop record mp3 failed, err = " + e.getLocalizedMessage(), e);
            }
        }
    }

    private static final void initAudioRecord$lambda$20(AACEncodeProcessor this$0) {
        this$0.mAudioRecord.initAudioRecord();
        this$0.mAudioRecord.startRecording();
        this$0.getMAudioRecordState().set(true);
        CountDownLatch countDownLatch = this$0.mCountDownLatch;
        if (countDownLatch != null) {
            countDownLatch.countDown();
        }
        while (this$0.getMAudioRecordState().get()) {
            RawData data = this$0.mAudioRecord.read();
            if (data == null) continue;
            this$0.putRawData(data);
            if (this$0.getMPlayQueue().size() >= 5) {
                this$0.getMPlayQueue().poll();
            }
            this$0.getMPlayQueue().offer(data);
            if (this$0.getMRecordMp3Queue().size() >= 5) {
                this$0.getMRecordMp3Queue().poll();
            }
            this$0.getMRecordMp3Queue().offer(data);
        }
        this$0.mAudioRecord.stopRecording();
        this$0.mAudioRecord.releaseAudioRecord();
        this$0.getMAudioRecordState().set(false);
        this$0.getMPlayQueue().clear();
        this$0.getMRecordMp3Queue().clear();
        this$0.getMRawDataQueue().clear();
    }

    public AACEncodeProcessor() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jiangdg/ausbc/encode/AACEncodeProcessor$Companion;", "", "<init>", "()V", "TAG", "", "MIME_TYPE", "BIT_RATE", "", "MAX_INPUT_SIZE", "CHANNEL_OUT_CONFIG", "AUDIO_TRACK_MODE", "CODEC_AAC_PROFILE", "DEGREE_RECORD_MP3", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

