/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.camera;

import android.content.ContentValues;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.usb.UsbDevice;
import android.location.Location;
import android.os.Build;
import android.provider.MediaStore;
import android.view.SurfaceHolder;
import com.jiangdg.ausbc.callback.ICaptureCallBack;
import com.jiangdg.ausbc.callback.IDeviceConnectCallBack;
import com.jiangdg.ausbc.callback.IPreviewDataCallBack;
import com.jiangdg.ausbc.camera.ICameraStrategy;
import com.jiangdg.ausbc.camera.bean.CameraInfo;
import com.jiangdg.ausbc.camera.bean.CameraRequest;
import com.jiangdg.ausbc.camera.bean.CameraStatus;
import com.jiangdg.ausbc.camera.bean.CameraUvcInfo;
import com.jiangdg.ausbc.camera.bean.PreviewSize;
import com.jiangdg.ausbc.utils.CameraUtils;
import com.jiangdg.ausbc.utils.Logger;
import com.jiangdg.ausbc.utils.MediaUtils;
import com.jiangdg.ausbc.utils.SettableFuture;
import com.jiangdg.ausbc.utils.Utils;
import com.jiangdg.usb.DeviceFilter;
import com.jiangdg.usb.USBMonitor;
import com.jiangdg.utils.Size;
import com.jiangdg.uvc.IFrameCallback;
import com.jiangdg.uvc.UVCCamera;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="Deprecated since version 3.3.0")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b/\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 j2\u00020\u0001:\u0001jB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010!\u001a\u00020\"H\u0014J\u0010\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\bH\u0002J\b\u0010%\u001a\u00020\"H\u0014J\u000f\u0010&\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010'J\u0018\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0002J\u000f\u0010,\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010'J\b\u0010-\u001a\u00020\"H\u0014J\u0012\u0010.\u001a\u00020\"2\b\u0010/\u001a\u0004\u0018\u000100H\u0014J\u0012\u00101\u001a\u00020\"2\b\u00102\u001a\u0004\u0018\u000100H\u0014J\u0018\u00103\u001a\u00020\"2\u0006\u00104\u001a\u00020*2\u0006\u00105\u001a\u00020*H\u0014J\u001f\u00106\u001a\n\u0012\u0004\u0012\u000207\u0018\u00010 2\b\u00108\u001a\u0004\u0018\u000109H\u0016\u00a2\u0006\u0002\u0010:J\b\u0010;\u001a\u00020\"H\u0016J\b\u0010<\u001a\u00020\"H\u0016J\u000e\u0010=\u001a\u00020\"2\u0006\u0010>\u001a\u00020\u001eJ\u001f\u0010?\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010 2\n\b\u0002\u0010@\u001a\u0004\u0018\u00010*\u00a2\u0006\u0002\u0010AJ\b\u0010B\u001a\u0004\u0018\u00010\bJ\b\u0010C\u001a\u0004\u0018\u00010\nJ\u0006\u0010D\u001a\u00020\fJ\u0015\u0010E\u001a\u0004\u0018\u00010*2\u0006\u0010F\u001a\u00020*\u00a2\u0006\u0002\u0010GJ\u000e\u0010H\u001a\u00020\"2\u0006\u0010I\u001a\u00020\fJ\u000e\u0010J\u001a\u00020\"2\u0006\u0010K\u001a\u00020\fJ\u000e\u0010L\u001a\u00020\"2\u0006\u0010M\u001a\u00020*J\r\u0010N\u001a\u0004\u0018\u00010*\u00a2\u0006\u0002\u0010OJ\u000e\u0010P\u001a\u00020\"2\u0006\u0010Q\u001a\u00020*J\r\u0010R\u001a\u0004\u0018\u00010*\u00a2\u0006\u0002\u0010OJ\u000e\u0010S\u001a\u00020\"2\u0006\u0010T\u001a\u00020*J\r\u0010U\u001a\u0004\u0018\u00010*\u00a2\u0006\u0002\u0010OJ\u000e\u0010V\u001a\u00020\"2\u0006\u0010W\u001a\u00020*J\r\u0010X\u001a\u0004\u0018\u00010*\u00a2\u0006\u0002\u0010OJ\u000e\u0010Y\u001a\u00020\"2\u0006\u0010Z\u001a\u00020*J\r\u0010[\u001a\u0004\u0018\u00010*\u00a2\u0006\u0002\u0010OJ\u000e\u0010\\\u001a\u00020\"2\u0006\u0010]\u001a\u00020*J\r\u0010^\u001a\u0004\u0018\u00010*\u00a2\u0006\u0002\u0010OJ\u000e\u0010_\u001a\u00020\"2\u0006\u0010`\u001a\u00020*J\r\u0010a\u001a\u0004\u0018\u00010*\u00a2\u0006\u0002\u0010OJ\u000e\u0010b\u001a\u00020\"2\u0006\u0010c\u001a\u00020*J\r\u0010d\u001a\u0004\u0018\u00010*\u00a2\u0006\u0002\u0010OJ\u0010\u0010e\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010 H\u0002J\u0012\u0010f\u001a\u00020\"2\b\u0010g\u001a\u0004\u0018\u00010\bH\u0002R\u0018\u0010\u0006\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0013\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010h\u001a\u00020iX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006k"}, d2={"Lcom/jiangdg/ausbc/camera/CameraUvcStrategy;", "Lcom/jiangdg/ausbc/camera/ICameraStrategy;", "ctx", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "mDevSettableFuture", "Lcom/jiangdg/ausbc/utils/SettableFuture;", "Landroid/hardware/usb/UsbDevice;", "mCtrlBlockSettableFuture", "Lcom/jiangdg/usb/USBMonitor$UsbControlBlock;", "mConnectSettableFuture", "", "mNV21DataQueue", "Ljava/util/concurrent/LinkedBlockingDeque;", "", "getMNV21DataQueue", "()Ljava/util/concurrent/LinkedBlockingDeque;", "mNV21DataQueue$delegate", "Lkotlin/Lazy;", "mRequestPermission", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getMRequestPermission", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "mRequestPermission$delegate", "mUsbMonitor", "Lcom/jiangdg/usb/USBMonitor;", "mUVCCamera", "Lcom/jiangdg/uvc/UVCCamera;", "mDevConnectCallBack", "Lcom/jiangdg/ausbc/callback/IDeviceConnectCallBack;", "mCacheDeviceList", "", "loadCameraInfo", "", "loadCameraInfoInternal", "dev", "startPreviewInternal", "createCamera", "()Ljava/lang/Boolean;", "isPreviewSizeSupported", "previewWidth", "", "previewHeight", "realStartPreview", "stopPreviewInternal", "captureImageInternal", "savePath", "", "switchCameraInternal", "cameraId", "updateResolutionInternal", "width", "height", "getAllPreviewSizes", "Lcom/jiangdg/ausbc/camera/bean/PreviewSize;", "aspectRatio", "", "(Ljava/lang/Double;)Ljava/util/List;", "register", "unRegister", "setDeviceConnectStatusListener", "cb", "getUsbDeviceList", "resId", "(Ljava/lang/Integer;)Ljava/util/List;", "getCurrentDevice", "getUsbControlBlock", "isMicSupported", "sendCameraCommand", "command", "(I)Ljava/lang/Integer;", "setAutoFocus", "enable", "setAutoWhiteBalance", "autoWhiteBalance", "setZoom", "zoom", "getZoom", "()Ljava/lang/Integer;", "setGain", "gain", "getGain", "setGamma", "gamma", "getGamma", "setBrightness", "brightness", "getBrightness", "setContrast", "contrast", "getContrast", "setSharpness", "sharpness", "getSharpness", "setSaturation", "saturation", "getSaturation", "setHue", "hue", "getHue", "getUsbDeviceListInternal", "requestCameraPermission", "device", "frameCallBack", "Lcom/jiangdg/uvc/IFrameCallback;", "Companion", "libausbc_release"})
@SourceDebugExtension(value={"SMAP\nCameraUvcStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CameraUvcStrategy.kt\ncom/jiangdg/ausbc/camera/CameraUvcStrategy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,804:1\n1863#2,2:805\n1863#2,2:807\n1863#2,2:809\n1863#2,2:811\n1863#2,2:813\n1863#2,2:815\n*S KotlinDebug\n*F\n+ 1 CameraUvcStrategy.kt\ncom/jiangdg/ausbc/camera/CameraUvcStrategy\n*L\n85#1:805,2\n353#1:807,2\n369#1:809,2\n553#1:811,2\n754#1:813,2\n783#1:815,2\n*E\n"})
public final class CameraUvcStrategy
extends ICameraStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private SettableFuture<UsbDevice> mDevSettableFuture;
    @Nullable
    private SettableFuture<USBMonitor.UsbControlBlock> mCtrlBlockSettableFuture;
    @NotNull
    private final SettableFuture<Boolean> mConnectSettableFuture;
    @NotNull
    private final Lazy mNV21DataQueue$delegate;
    @NotNull
    private final Lazy mRequestPermission$delegate;
    @Nullable
    private USBMonitor mUsbMonitor;
    @Nullable
    private UVCCamera mUVCCamera;
    @Nullable
    private IDeviceConnectCallBack mDevConnectCallBack;
    @NotNull
    private List<UsbDevice> mCacheDeviceList;
    @NotNull
    private final IFrameCallback frameCallBack;
    @NotNull
    private static final String TAG = "CameraUvc";
    private static final int MIN_FS = 10;
    private static final int MAX_FS = 60;
    private static final int MAX_NV21_DATA = 5;
    private static final long CAPTURE_TIMES_OUT_SEC = 1L;

    public CameraUvcStrategy(@NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        super(ctx);
        this.mConnectSettableFuture = new SettableFuture();
        this.mNV21DataQueue$delegate = LazyKt.lazy(CameraUvcStrategy::mNV21DataQueue_delegate$lambda$0);
        this.mRequestPermission$delegate = LazyKt.lazy(CameraUvcStrategy::mRequestPermission_delegate$lambda$1);
        this.mCacheDeviceList = new ArrayList();
        this.register();
        this.frameCallBack = arg_0 -> CameraUvcStrategy.frameCallBack$lambda$37(this, arg_0);
    }

    private final LinkedBlockingDeque<byte[]> getMNV21DataQueue() {
        Lazy lazy = this.mNV21DataQueue$delegate;
        return (LinkedBlockingDeque)lazy.getValue();
    }

    private final AtomicBoolean getMRequestPermission() {
        Lazy lazy = this.mRequestPermission$delegate;
        return (AtomicBoolean)lazy.getValue();
    }

    @Override
    protected void loadCameraInfo() {
        try {
            List<UsbDevice> devList = this.getUsbDeviceListInternal();
            Collection collection = devList;
            if (collection == null || collection.isEmpty()) {
                String emptyTip = "Find no uvc devices, if you want some special device please use getUsbDeviceList() or add device info into default_device_filter.xml";
                this.postCameraStatus(new CameraStatus(-1, emptyTip));
                Logger.INSTANCE.e(TAG, emptyTip);
                return;
            }
            Iterable $this$forEach$iv = devList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                UsbDevice dev = (UsbDevice)element$iv;
                boolean bl = false;
                this.loadCameraInfoInternal(dev);
            }
        }
        catch (Exception e) {
            Logger.INSTANCE.e(TAG, " Find no uvc devices, err = " + e.getLocalizedMessage(), e);
        }
    }

    private final void loadCameraInfoInternal(UsbDevice dev) {
        CameraUvcInfo cameraUvcInfo;
        if (this.getMCameraInfoMap().containsKey(dev.getDeviceId())) {
            return;
        }
        CameraUvcInfo $this$loadCameraInfoInternal_u24lambda_u243 = cameraUvcInfo = new CameraUvcInfo(String.valueOf(dev.getDeviceId()));
        boolean bl = false;
        $this$loadCameraInfoInternal_u24lambda_u243.setCameraVid(dev.getVendorId());
        $this$loadCameraInfoInternal_u24lambda_u243.setCameraPid(dev.getProductId());
        $this$loadCameraInfoInternal_u24lambda_u243.setCameraName(dev.getDeviceName());
        $this$loadCameraInfoInternal_u24lambda_u243.setCameraProtocol(dev.getDeviceProtocol());
        $this$loadCameraInfoInternal_u24lambda_u243.setCameraClass(dev.getDeviceClass());
        $this$loadCameraInfoInternal_u24lambda_u243.setCameraSubClass(dev.getDeviceSubclass());
        if (Build.VERSION.SDK_INT >= 21) {
            $this$loadCameraInfoInternal_u24lambda_u243.setCameraProductName(dev.getProductName());
            $this$loadCameraInfoInternal_u24lambda_u243.setCameraManufacturerName(dev.getManufacturerName());
        }
        CameraUvcInfo cameraInfo = cameraUvcInfo;
        ((Map)this.getMCameraInfoMap()).put(dev.getDeviceId(), cameraInfo);
    }

    @Override
    protected void startPreviewInternal() {
        try {
            this.createCamera();
            this.realStartPreview();
        }
        catch (Exception e) {
            this.stopPreview();
            Logger.INSTANCE.e(TAG, " preview failed, err = " + e.getLocalizedMessage(), e);
            this.postCameraStatus(new CameraStatus(-1, e.getLocalizedMessage()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Boolean createCamera() {
        block11: {
            void $this$createCamera_u24lambda_u245_u24lambda_u244;
            UVCCamera uVCCamera;
            SettableFuture<USBMonitor.UsbControlBlock> settableFuture = this.mCtrlBlockSettableFuture;
            USBMonitor.UsbControlBlock ctrlBlock = settableFuture != null ? settableFuture.get() : null;
            SettableFuture<UsbDevice> settableFuture2 = this.mDevSettableFuture;
            Object device = settableFuture2 != null ? settableFuture2.get() : null;
            if (device == null) {
                return null;
            }
            if (ctrlBlock == null) {
                return null;
            }
            CameraRequest cameraRequest = this.getRequest();
            if (cameraRequest == null) break block11;
            CameraRequest request = cameraRequest;
            boolean bl = false;
            int previewWidth = request.getPreviewWidth();
            int previewHeight = request.getPreviewHeight();
            request.setCameraId(String.valueOf(device.getDeviceId()));
            UVCCamera uVCCamera2 = uVCCamera = new UVCCamera();
            CameraUvcStrategy cameraUvcStrategy = this;
            boolean bl2 = false;
            $this$createCamera_u24lambda_u245_u24lambda_u244.open(ctrlBlock);
            cameraUvcStrategy.mUVCCamera = uVCCamera;
            if (!this.isPreviewSizeSupported(previewWidth, previewHeight)) {
                this.postCameraStatus(new CameraStatus(-2, "unsupported preview size(" + request.getPreviewWidth() + ", " + request.getPreviewHeight() + ')'));
                Logger.INSTANCE.e(TAG, " unsupported preview size(" + request.getPreviewWidth() + ", " + request.getPreviewHeight() + ')');
                return null;
            }
            try {
                UVCCamera uVCCamera3 = this.mUVCCamera;
                if (uVCCamera3 != null) {
                    uVCCamera3.setPreviewSize(request.getPreviewWidth(), request.getPreviewHeight(), 10, 60, 1, 1.0f);
                }
            }
            catch (Exception e) {
                try {
                    Logger.INSTANCE.w(TAG, " setPreviewSize failed " + e.getLocalizedMessage() + ", try yuv format...");
                    if (!this.isPreviewSizeSupported(previewWidth, previewHeight)) {
                        this.postCameraStatus(new CameraStatus(-2, "unsupported preview size(" + request.getPreviewWidth() + ", " + request.getPreviewHeight() + ')'));
                        Logger.INSTANCE.e(TAG, " unsupported preview size(" + request.getPreviewWidth() + ", " + request.getPreviewHeight() + ')');
                        return null;
                    }
                    UVCCamera uVCCamera4 = this.mUVCCamera;
                    if (uVCCamera4 != null) {
                        uVCCamera4.setPreviewSize(request.getPreviewWidth(), request.getPreviewHeight(), 10, 60, 0, 1.0f);
                    }
                }
                catch (Exception e2) {
                    this.postCameraStatus(new CameraStatus(-1, "setPreviewSize failed, err = " + e2.getLocalizedMessage()));
                    Logger.INSTANCE.e(TAG, " setPreviewSize failed", e2);
                    return null;
                }
            }
            UVCCamera uVCCamera5 = this.mUVCCamera;
            if (uVCCamera5 != null) {
                uVCCamera5.setFrameCallback(this.frameCallBack, 4);
            }
            Logger.INSTANCE.i(TAG, " createCamera success! request = " + request);
        }
        return true;
    }

    private final boolean isPreviewSizeSupported(int previewWidth, int previewHeight) {
        PreviewSize previewSize;
        List list = ICameraStrategy.getAllPreviewSizes$default(this, null, 1, null);
        if (list != null) {
            Object v1;
            block3: {
                Iterable iterable = list;
                for (Object t : iterable) {
                    PreviewSize it = (PreviewSize)t;
                    boolean bl = false;
                    if (!(it.getWidth() == previewWidth && it.getHeight() == previewHeight)) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            previewSize = v1;
        } else {
            previewSize = null;
        }
        return previewSize != null;
    }

    private final Boolean realStartPreview() {
        try {
            CameraRequest cameraRequest;
            SurfaceTexture st = this.getSurfaceTexture();
            SurfaceHolder holder = this.getSurfaceHolder();
            if (st == null && holder == null) {
                this.postCameraStatus(new CameraStatus(-1, "surface is null"));
                Logger.INSTANCE.e(TAG, " SurfaceTexture or SurfaceHolder cannot be null.");
                return null;
            }
            if (st != null) {
                UVCCamera uVCCamera = this.mUVCCamera;
                if (uVCCamera != null) {
                    uVCCamera.setPreviewTexture(st);
                }
            } else {
                UVCCamera uVCCamera = this.mUVCCamera;
                if (uVCCamera != null) {
                    uVCCamera.setPreviewDisplay(holder);
                }
            }
            UVCCamera uVCCamera = this.mUVCCamera;
            if (uVCCamera != null) {
                uVCCamera.setAutoFocus(true);
            }
            UVCCamera uVCCamera2 = this.mUVCCamera;
            if (uVCCamera2 != null) {
                uVCCamera2.setAutoWhiteBlance(true);
            }
            UVCCamera uVCCamera3 = this.mUVCCamera;
            if (uVCCamera3 != null) {
                uVCCamera3.startPreview();
            }
            UVCCamera uVCCamera4 = this.mUVCCamera;
            if (uVCCamera4 != null) {
                uVCCamera4.updateCameraParams();
            }
            this.getMIsPreviewing().set(true);
            CameraRequest cameraRequest2 = this.getRequest();
            if (cameraRequest2 != null) {
                CameraRequest $this$realStartPreview_u24lambda_u247 = cameraRequest = cameraRequest2;
                boolean bl = false;
                this.postCameraStatus(new CameraStatus(1, new Pair((Object)$this$realStartPreview_u24lambda_u247.getPreviewWidth(), (Object)$this$realStartPreview_u24lambda_u247.getPreviewHeight()).toString()));
            }
            SettableFuture<UsbDevice> settableFuture = this.mDevSettableFuture;
            CameraRequest $this$realStartPreview_u24lambda_u248 = cameraRequest = settableFuture != null ? settableFuture.get() : null;
            boolean bl = false;
            IDeviceConnectCallBack iDeviceConnectCallBack = this.mDevConnectCallBack;
            if (iDeviceConnectCallBack != null) {
                IDeviceConnectCallBack.DefaultImpls.onConnectDev$default(iDeviceConnectCallBack, (UsbDevice)$this$realStartPreview_u24lambda_u248, null, 2, null);
            }
            CameraRequest dev = cameraRequest;
            if (Utils.INSTANCE.getDebugCamera()) {
                CameraRequest cameraRequest3 = dev;
                Logger.INSTANCE.i(TAG, " start preview success!!!, id(" + (cameraRequest3 != null ? cameraRequest3.getDeviceName() : null));
            }
        }
        catch (Exception e) {
            this.postCameraStatus(new CameraStatus(-1, e.getLocalizedMessage()));
            Logger.INSTANCE.e(TAG, " startPreview failed. err = " + e.getLocalizedMessage(), e);
            return null;
        }
        return true;
    }

    @Override
    protected void stopPreviewInternal() {
        if (Utils.INSTANCE.getDebugCamera() && this.getMIsPreviewing().get()) {
            Logger.INSTANCE.i(TAG, "stopPreviewInternal");
        }
        this.getMRequestPermission().set(false);
        this.getMIsPreviewing().set(false);
        UVCCamera uVCCamera = this.mUVCCamera;
        if (uVCCamera != null) {
            uVCCamera.stopPreview();
        }
        UVCCamera uVCCamera2 = this.mUVCCamera;
        if (uVCCamera2 != null) {
            uVCCamera2.destroy();
        }
        this.mUVCCamera = null;
        this.postCameraStatus(new CameraStatus(2, null, 2, null));
    }

    @Override
    protected void captureImageInternal(@Nullable String savePath) {
        if (!this.hasCameraPermission() || !this.hasStoragePermission()) {
            this.getMMainHandler().post(() -> CameraUvcStrategy.captureImageInternal$lambda$9(this));
            Logger.INSTANCE.i(TAG, "captureImageInternal failed, has no storage/camera permission.");
            return;
        }
        if (this.getMIsCapturing().get()) {
            return;
        }
        this.getMSaveImageExecutor().submit(() -> CameraUvcStrategy.captureImageInternal$lambda$14(this, savePath));
    }

    @Override
    protected void switchCameraInternal(@Nullable String cameraId) {
        block12: {
            CharSequence charSequence;
            CameraRequest cameraRequest = this.getRequest();
            if (cameraRequest == null) break block12;
            CameraRequest it = cameraRequest;
            boolean bl = false;
            if (Utils.INSTANCE.getDebugCamera()) {
                Logger.INSTANCE.i(TAG, "switchCameraInternal, camera id = " + cameraId);
            }
            if ((charSequence = (CharSequence)cameraId) == null || charSequence.length() == 0) {
                Logger.INSTANCE.e(TAG, "camera id invalid.");
            } else {
                UsbDevice usbDevice = this.getCurrentDevice();
                if (Intrinsics.areEqual((Object)(usbDevice != null ? Integer.valueOf(usbDevice.getDeviceId()).toString() : null), (Object)cameraId)) {
                    Logger.INSTANCE.e(TAG, "camera was already opened.");
                } else {
                    UsbDevice usbDevice2;
                    List list = CameraUvcStrategy.getUsbDeviceList$default(this, null, 1, null);
                    if (list != null) {
                        Object v3;
                        block11: {
                            Iterable iterable = list;
                            for (Object t : iterable) {
                                UsbDevice it2 = (UsbDevice)t;
                                boolean bl2 = false;
                                if (!Intrinsics.areEqual((Object)cameraId, (Object)String.valueOf(it2.getDeviceId()))) continue;
                                v3 = t;
                                break block11;
                            }
                            v3 = null;
                        }
                        usbDevice2 = v3;
                    } else {
                        usbDevice2 = null;
                    }
                    CharSequence dev = charSequence = usbDevice2;
                    boolean bl3 = false;
                    if (dev == null) {
                        Logger.INSTANCE.e(TAG, "switch camera(: " + cameraId + ") failed, not found.");
                    } else {
                        if (!this.mCacheDeviceList.contains(dev)) {
                            this.mCacheDeviceList.add((UsbDevice)dev);
                        }
                        this.stopPreviewInternal();
                        this.requestCameraPermission((UsbDevice)dev);
                    }
                }
            }
        }
    }

    @Override
    protected void updateResolutionInternal(int width, int height) {
        block0: {
            CameraRequest cameraRequest = this.getRequest();
            if (cameraRequest == null) break block0;
            CameraRequest request = cameraRequest;
            boolean bl = false;
            request.setPreviewWidth(width);
            request.setPreviewHeight(height);
            this.stopPreviewInternal();
            this.startPreviewInternal();
        }
    }

    @Override
    @Nullable
    public List<PreviewSize> getAllPreviewSizes(@Nullable Double aspectRatio) {
        CameraRequest cameraRequest = this.getRequest();
        if (cameraRequest != null) {
            Object previewSizeList;
            CameraInfo cameraInfo;
            Object object;
            Object v1;
            Iterable iterable;
            block13: {
                CameraRequest request = cameraRequest;
                boolean bl = false;
                Collection<CameraInfo> collection = this.getMCameraInfoMap().values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                iterable = collection;
                for (Object t : iterable) {
                    CameraInfo it = (CameraInfo)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)request.getCameraId(), (Object)it.getCameraId())) continue;
                    v1 = t;
                    break block13;
                }
                v1 = null;
            }
            if ((object = (cameraInfo = (CameraInfo)v1)) == null || (object = ((CameraInfo)object).getCameraPreviewSizes()) == null) {
                object = new ArrayList();
            }
            if ((previewSizeList = object).isEmpty()) {
                List list;
                UVCCamera uVCCamera = this.mUVCCamera;
                Logger.INSTANCE.i(TAG, "getAllPreviewSizes = " + (uVCCamera != null ? uVCCamera.getSupportedSizeList() : null));
                Object object2 = this.mUVCCamera;
                boolean bl = object2 != null && (object2 = object2.getSupportedSizeList()) != null ? !((Collection)object2).isEmpty() : false;
                if (bl) {
                    UVCCamera uVCCamera2 = this.mUVCCamera;
                    list = uVCCamera2 != null ? uVCCamera2.getSupportedSizeList() : null;
                } else {
                    UVCCamera uVCCamera3 = this.mUVCCamera;
                    list = uVCCamera3 != null ? uVCCamera3.getSupportedSizeList(0) : null;
                }
                Iterable sizeList = iterable = list;
                boolean bl3 = false;
                Iterable iterable2 = sizeList;
                if (iterable2 != null) {
                    Iterable $this$forEach$iv = iterable2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Object v10;
                        Size size;
                        block14: {
                            size = (Size)element$iv;
                            boolean bl4 = false;
                            Iterable iterable3 = (Iterable)previewSizeList;
                            for (Object t : iterable3) {
                                PreviewSize it = (PreviewSize)t;
                                boolean bl5 = false;
                                if (!(it.getWidth() == size.width && it.getHeight() == size.height)) continue;
                                v10 = t;
                                break block14;
                            }
                            v10 = null;
                        }
                        Object var21_28 = v10;
                        PreviewSize it = var21_28;
                        boolean bl6 = false;
                        if (it != null) continue;
                        previewSizeList.add(new PreviewSize(size.width, size.height));
                    }
                }
                CameraInfo cameraInfo2 = cameraInfo;
                if (cameraInfo2 != null) {
                    cameraInfo2.setCameraPreviewSizes((List<PreviewSize>)previewSizeList);
                }
            }
            Double d = aspectRatio;
            if (d == null) {
                return previewSizeList;
            }
            d.doubleValue();
            List aspectList = new ArrayList();
            aspectList.clear();
            Object object3 = cameraInfo;
            if (object3 != null && (object3 = ((CameraInfo)object3).getCameraPreviewSizes()) != null) {
                Iterable $this$forEach$iv = (Iterable)object3;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    int height;
                    PreviewSize size = (PreviewSize)element$iv;
                    boolean bl = false;
                    int width = size.getWidth();
                    double ratio = (double)width / (double)(height = size.getHeight());
                    if (!Intrinsics.areEqual((double)ratio, (Double)aspectRatio)) continue;
                    aspectList.add(size);
                }
            }
            Logger.INSTANCE.i(TAG, "getAllPreviewSizes aspectRatio = " + aspectRatio + ", size = " + aspectList);
            return aspectList;
        }
        return null;
    }

    @Override
    public void register() {
        USBMonitor uSBMonitor = this.mUsbMonitor;
        boolean bl = uSBMonitor != null ? uSBMonitor.isRegistered() : false;
        if (bl) {
            return;
        }
        USBMonitor uSBMonitor2 = this.mUsbMonitor = USBMonitor.getInstance((Context)this.getContext());
        if (uSBMonitor2 != null) {
            uSBMonitor2.setOnDeviceConnectListener(new USBMonitor.OnDeviceConnectListener(this){
                final /* synthetic */ CameraUvcStrategy this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onAttach(UsbDevice device) {
                    if (Utils.INSTANCE.getDebugCamera()) {
                        UsbDevice usbDevice = device;
                        Logger.INSTANCE.i("CameraUvc", "attach device = " + (usbDevice != null ? usbDevice.toString() : null));
                    }
                    if (device == null) {
                        return;
                    }
                    if (!CameraUtils.INSTANCE.isUsbCamera(device) && !CameraUtils.INSTANCE.isFilterDevice(this.this$0.getContext(), device)) {
                        return;
                    }
                    if (!CameraUvcStrategy.access$getMCacheDeviceList$p(this.this$0).contains(device)) {
                        UsbDevice usbDevice = device;
                        CameraUvcStrategy cameraUvcStrategy = this.this$0;
                        UsbDevice it = usbDevice;
                        boolean bl = false;
                        CameraUvcStrategy.access$getMCacheDeviceList$p(cameraUvcStrategy).add(it);
                        IDeviceConnectCallBack iDeviceConnectCallBack = CameraUvcStrategy.access$getMDevConnectCallBack$p(this.this$0);
                        if (iDeviceConnectCallBack != null) {
                            iDeviceConnectCallBack.onAttachDev(device);
                        }
                    }
                    CameraUvcStrategy.access$loadCameraInfoInternal(this.this$0, device);
                    CameraUvcStrategy.access$requestCameraPermission(this.this$0, device);
                }

                public void onDetach(UsbDevice device) {
                    UsbDevice dev;
                    if (Utils.INSTANCE.getDebugCamera()) {
                        UsbDevice usbDevice = device;
                        Logger.INSTANCE.i("CameraUvc", "onDetach device = " + (usbDevice != null ? usbDevice.getDeviceName() : null));
                    }
                    if (!(CameraUtils.INSTANCE.isUsbCamera(device) || CameraUtils.INSTANCE.isFilterDevice(this.this$0.getContext(), device) || CollectionsKt.contains((Iterable)CameraUvcStrategy.access$getMCacheDeviceList$p(this.this$0), (Object)device))) {
                        return;
                    }
                    Map map = this.this$0.getMCameraInfoMap();
                    UsbDevice usbDevice = device;
                    Integer n = usbDevice != null ? Integer.valueOf(usbDevice.getDeviceId()) : null;
                    TypeIntrinsics.asMutableMap((Object)map).remove(n);
                    IDeviceConnectCallBack iDeviceConnectCallBack = CameraUvcStrategy.access$getMDevConnectCallBack$p(this.this$0);
                    if (iDeviceConnectCallBack != null) {
                        iDeviceConnectCallBack.onDetachDec(device);
                    }
                    if (CollectionsKt.contains((Iterable)CameraUvcStrategy.access$getMCacheDeviceList$p(this.this$0), (Object)device)) {
                        TypeIntrinsics.asMutableCollection((Object)CameraUvcStrategy.access$getMCacheDeviceList$p(this.this$0)).remove(device);
                    }
                    SettableFuture settableFuture = CameraUvcStrategy.access$getMDevSettableFuture$p(this.this$0);
                    UsbDevice usbDevice2 = dev = settableFuture != null ? (UsbDevice)settableFuture.get() : null;
                    UsbDevice usbDevice3 = device;
                    if (Intrinsics.areEqual((Object)(usbDevice2 != null ? Integer.valueOf(usbDevice2.getDeviceId()) : null), (Object)(usbDevice3 != null ? Integer.valueOf(usbDevice3.getDeviceId()) : null))) {
                        CameraUvcStrategy.access$getMRequestPermission(this.this$0).set(false);
                    }
                }

                public void onConnect(UsbDevice device, USBMonitor.UsbControlBlock ctrlBlock, boolean createNew) {
                    if (Utils.INSTANCE.getDebugCamera()) {
                        UsbDevice usbDevice = device;
                        Logger.INSTANCE.i("CameraUvc", "onConnect device = " + (usbDevice != null ? usbDevice.getDeviceName() : null));
                    }
                    if (!(CameraUtils.INSTANCE.isUsbCamera(device) || CameraUtils.INSTANCE.isFilterDevice(this.this$0.getContext(), device) || CollectionsKt.contains((Iterable)CameraUvcStrategy.access$getMCacheDeviceList$p(this.this$0), (Object)device))) {
                        return;
                    }
                    CameraUvcStrategy.access$setMDevSettableFuture$p(this.this$0, new SettableFuture<V>());
                    CameraUvcStrategy.access$setMCtrlBlockSettableFuture$p(this.this$0, new SettableFuture<V>());
                    CameraRequest cameraRequest = this.this$0.getRequest();
                    if (cameraRequest != null) {
                        CameraRequest cameraRequest2 = cameraRequest;
                        CameraUvcStrategy cameraUvcStrategy = this.this$0;
                        CameraRequest $this$onConnect_u24lambda_u241 = cameraRequest2;
                        boolean bl = false;
                        if (cameraUvcStrategy.getSurfaceTexture() != null) {
                            cameraUvcStrategy.startPreview($this$onConnect_u24lambda_u241, cameraUvcStrategy.getSurfaceTexture());
                        } else {
                            cameraUvcStrategy.startPreview($this$onConnect_u24lambda_u241, cameraUvcStrategy.getSurfaceHolder());
                        }
                    }
                    SettableFuture settableFuture = CameraUvcStrategy.access$getMDevSettableFuture$p(this.this$0);
                    if (settableFuture != null) {
                        settableFuture.set(device);
                    }
                    SettableFuture settableFuture2 = CameraUvcStrategy.access$getMCtrlBlockSettableFuture$p(this.this$0);
                    if (settableFuture2 != null) {
                        settableFuture2.set(ctrlBlock);
                    }
                    CameraUvcStrategy.access$getMConnectSettableFuture$p(this.this$0).set(true);
                }

                public void onDisconnect(UsbDevice device, USBMonitor.UsbControlBlock ctrlBlock) {
                    UsbDevice curDevice;
                    if (Utils.INSTANCE.getDebugCamera()) {
                        UsbDevice usbDevice = device;
                        Logger.INSTANCE.i("CameraUvc", "onDisconnect device = " + (usbDevice != null ? usbDevice.getDeviceName() : null));
                    }
                    if (!(CameraUtils.INSTANCE.isUsbCamera(device) || CameraUtils.INSTANCE.isFilterDevice(this.this$0.getContext(), device) || CollectionsKt.contains((Iterable)CameraUvcStrategy.access$getMCacheDeviceList$p(this.this$0), (Object)device))) {
                        return;
                    }
                    SettableFuture settableFuture = CameraUvcStrategy.access$getMDevSettableFuture$p(this.this$0);
                    UsbDevice usbDevice = curDevice = settableFuture != null ? (UsbDevice)settableFuture.get() : null;
                    UsbDevice usbDevice2 = device;
                    if (!Intrinsics.areEqual((Object)(usbDevice != null ? Integer.valueOf(usbDevice.getDeviceId()) : null), (Object)(usbDevice2 != null ? Integer.valueOf(usbDevice2.getDeviceId()) : null))) {
                        return;
                    }
                    this.this$0.stopPreview();
                    IDeviceConnectCallBack iDeviceConnectCallBack = CameraUvcStrategy.access$getMDevConnectCallBack$p(this.this$0);
                    if (iDeviceConnectCallBack != null) {
                        iDeviceConnectCallBack.onDisConnectDec(device, ctrlBlock);
                    }
                    CameraUvcStrategy.access$getMConnectSettableFuture$p(this.this$0).set(false);
                }

                public void onCancel(UsbDevice device) {
                    block3: {
                        UsbDevice curDevice;
                        if (Utils.INSTANCE.getDebugCamera()) {
                            UsbDevice usbDevice = device;
                            Logger.INSTANCE.i("CameraUvc", "onCancel device = " + (usbDevice != null ? usbDevice.getDeviceName() : null));
                        }
                        if (!(CameraUtils.INSTANCE.isUsbCamera(device) || CameraUtils.INSTANCE.isFilterDevice(this.this$0.getContext(), device) || CollectionsKt.contains((Iterable)CameraUvcStrategy.access$getMCacheDeviceList$p(this.this$0), (Object)device))) {
                            return;
                        }
                        SettableFuture settableFuture = CameraUvcStrategy.access$getMDevSettableFuture$p(this.this$0);
                        UsbDevice usbDevice = curDevice = settableFuture != null ? (UsbDevice)settableFuture.get() : null;
                        UsbDevice usbDevice2 = device;
                        if (!Intrinsics.areEqual((Object)(usbDevice != null ? Integer.valueOf(usbDevice.getDeviceId()) : null), (Object)(usbDevice2 != null ? Integer.valueOf(usbDevice2.getDeviceId()) : null))) {
                            return;
                        }
                        this.this$0.stopPreview();
                        IDeviceConnectCallBack iDeviceConnectCallBack = CameraUvcStrategy.access$getMDevConnectCallBack$p(this.this$0);
                        if (iDeviceConnectCallBack == null) break block3;
                        IDeviceConnectCallBack.DefaultImpls.onDisConnectDec$default(iDeviceConnectCallBack, device, null, 2, null);
                    }
                }
            });
        }
        USBMonitor uSBMonitor3 = this.mUsbMonitor;
        if (uSBMonitor3 != null) {
            uSBMonitor3.register();
        }
        if (Utils.INSTANCE.getDebugCamera()) {
            Logger.INSTANCE.i(TAG, "register uvc device monitor");
        }
    }

    @Override
    public void unRegister() {
        USBMonitor uSBMonitor = this.mUsbMonitor;
        boolean bl = uSBMonitor != null ? !uSBMonitor.isRegistered() : false;
        if (bl) {
            return;
        }
        USBMonitor uSBMonitor2 = this.mUsbMonitor;
        if (uSBMonitor2 != null) {
            uSBMonitor2.unregister();
        }
        USBMonitor uSBMonitor3 = this.mUsbMonitor;
        if (uSBMonitor3 != null) {
            uSBMonitor3.destroy();
        }
        this.mUsbMonitor = null;
        if (Utils.INSTANCE.getDebugCamera()) {
            Logger.INSTANCE.i(TAG, "unRegister uvc device monitor");
        }
    }

    public final void setDeviceConnectStatusListener(@NotNull IDeviceConnectCallBack cb) {
        Intrinsics.checkNotNullParameter((Object)cb, (String)"cb");
        this.mDevConnectCallBack = cb;
    }

    @Nullable
    public final List<UsbDevice> getUsbDeviceList(@Nullable Integer resId) {
        ArrayList<UsbDevice> arrayList;
        Object object = this.mUsbMonitor;
        if (object != null && (object = object.getDeviceList()) != null) {
            List list;
            Object usbDevList = object;
            boolean bl = false;
            ArrayList<UsbDevice> list2 = new ArrayList<UsbDevice>();
            List filterList = list = resId == null ? null : DeviceFilter.getDeviceFilters((Context)this.getContext(), (int)resId);
            boolean bl2 = false;
            if (filterList == null) {
                list2.addAll((Collection)usbDevList);
            } else {
                Iterable $this$forEach$iv = (Iterable)usbDevList;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    DeviceFilter filterDev;
                    Object v2;
                    UsbDevice dev;
                    block6: {
                        dev = (UsbDevice)element$iv;
                        boolean bl3 = false;
                        Iterable iterable = filterList;
                        for (Object t : iterable) {
                            DeviceFilter it = (DeviceFilter)t;
                            boolean bl4 = false;
                            boolean bl5 = dev != null ? it.mProductId == dev.getProductId() : false;
                            if (!(bl5 && it.mVendorId == dev.getVendorId())) continue;
                            v2 = t;
                            break block6;
                        }
                        v2 = null;
                    }
                    if ((filterDev = (DeviceFilter)v2) == null) continue;
                    list2.add(dev);
                }
            }
            arrayList = list2;
        } else {
            arrayList = null;
        }
        return arrayList;
    }

    public static /* synthetic */ List getUsbDeviceList$default(CameraUvcStrategy cameraUvcStrategy, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        return cameraUvcStrategy.getUsbDeviceList(n);
    }

    @Nullable
    public final UsbDevice getCurrentDevice() {
        UsbDevice usbDevice;
        try {
            Boolean isConnected = this.mConnectSettableFuture.get(3L, TimeUnit.SECONDS);
            if (!Intrinsics.areEqual((Object)isConnected, (Object)true)) {
                return null;
            }
            SettableFuture<UsbDevice> settableFuture = this.mDevSettableFuture;
            usbDevice = settableFuture != null ? settableFuture.get(1L, TimeUnit.SECONDS) : null;
        }
        catch (Exception e) {
            usbDevice = null;
        }
        return usbDevice;
    }

    @Nullable
    public final USBMonitor.UsbControlBlock getUsbControlBlock() {
        USBMonitor.UsbControlBlock usbControlBlock;
        try {
            Boolean isConnected = this.mConnectSettableFuture.get(3L, TimeUnit.SECONDS);
            if (!Intrinsics.areEqual((Object)isConnected, (Object)true)) {
                return null;
            }
            SettableFuture<USBMonitor.UsbControlBlock> settableFuture = this.mCtrlBlockSettableFuture;
            usbControlBlock = settableFuture != null ? settableFuture.get(1L, TimeUnit.SECONDS) : null;
        }
        catch (Exception e) {
            Logger.INSTANCE.w(TAG, "get current usb control block times out");
            usbControlBlock = null;
        }
        return usbControlBlock;
    }

    public final boolean isMicSupported() {
        return CameraUtils.INSTANCE.isCameraContainsMic(this.getCurrentDevice());
    }

    @Nullable
    public final Integer sendCameraCommand(int command) {
        Integer n;
        UVCCamera uVCCamera = this.mUVCCamera;
        Integer $this$sendCameraCommand_u24lambda_u2430 = n = uVCCamera != null ? Integer.valueOf(uVCCamera.sendCommand(command)) : null;
        boolean bl = false;
        Logger.INSTANCE.i(TAG, "send command ret = " + $this$sendCameraCommand_u24lambda_u2430);
        return n;
    }

    public final void setAutoFocus(boolean enable) {
        block0: {
            UVCCamera uVCCamera = this.mUVCCamera;
            if (uVCCamera == null) break block0;
            uVCCamera.setAutoFocus(enable);
        }
    }

    public final void setAutoWhiteBalance(boolean autoWhiteBalance) {
        block0: {
            UVCCamera uVCCamera = this.mUVCCamera;
            if (uVCCamera == null) break block0;
            uVCCamera.setAutoWhiteBlance(autoWhiteBalance);
        }
    }

    public final void setZoom(int zoom) {
        block0: {
            UVCCamera uVCCamera = this.mUVCCamera;
            if (uVCCamera == null) break block0;
            uVCCamera.setZoom(zoom);
        }
    }

    @Nullable
    public final Integer getZoom() {
        UVCCamera uVCCamera = this.mUVCCamera;
        return uVCCamera != null ? Integer.valueOf(uVCCamera.getZoom()) : null;
    }

    public final void setGain(int gain) {
        block0: {
            UVCCamera uVCCamera = this.mUVCCamera;
            if (uVCCamera == null) break block0;
            uVCCamera.setGain(gain);
        }
    }

    @Nullable
    public final Integer getGain() {
        UVCCamera uVCCamera = this.mUVCCamera;
        return uVCCamera != null ? Integer.valueOf(uVCCamera.getGain()) : null;
    }

    public final void setGamma(int gamma) {
        block0: {
            UVCCamera uVCCamera = this.mUVCCamera;
            if (uVCCamera == null) break block0;
            uVCCamera.setGamma(gamma);
        }
    }

    @Nullable
    public final Integer getGamma() {
        UVCCamera uVCCamera = this.mUVCCamera;
        return uVCCamera != null ? Integer.valueOf(uVCCamera.getGamma()) : null;
    }

    public final void setBrightness(int brightness) {
        block0: {
            UVCCamera uVCCamera = this.mUVCCamera;
            if (uVCCamera == null) break block0;
            uVCCamera.setBrightness(brightness);
        }
    }

    @Nullable
    public final Integer getBrightness() {
        UVCCamera uVCCamera = this.mUVCCamera;
        return uVCCamera != null ? Integer.valueOf(uVCCamera.getBrightness()) : null;
    }

    public final void setContrast(int contrast) {
        block0: {
            UVCCamera uVCCamera = this.mUVCCamera;
            if (uVCCamera == null) break block0;
            uVCCamera.setContrast(contrast);
        }
    }

    @Nullable
    public final Integer getContrast() {
        UVCCamera uVCCamera = this.mUVCCamera;
        return uVCCamera != null ? Integer.valueOf(uVCCamera.getContrast()) : null;
    }

    public final void setSharpness(int sharpness) {
        block0: {
            UVCCamera uVCCamera = this.mUVCCamera;
            if (uVCCamera == null) break block0;
            uVCCamera.setSharpness(sharpness);
        }
    }

    @Nullable
    public final Integer getSharpness() {
        UVCCamera uVCCamera = this.mUVCCamera;
        return uVCCamera != null ? Integer.valueOf(uVCCamera.getSharpness()) : null;
    }

    public final void setSaturation(int saturation) {
        block0: {
            UVCCamera uVCCamera = this.mUVCCamera;
            if (uVCCamera == null) break block0;
            uVCCamera.setSaturation(saturation);
        }
    }

    @Nullable
    public final Integer getSaturation() {
        UVCCamera uVCCamera = this.mUVCCamera;
        return uVCCamera != null ? Integer.valueOf(uVCCamera.getSaturation()) : null;
    }

    public final void setHue(int hue) {
        block0: {
            UVCCamera uVCCamera = this.mUVCCamera;
            if (uVCCamera == null) break block0;
            uVCCamera.setHue(hue);
        }
    }

    @Nullable
    public final Integer getHue() {
        UVCCamera uVCCamera = this.mUVCCamera;
        return uVCCamera != null ? Integer.valueOf(uVCCamera.getHue()) : null;
    }

    private final List<UsbDevice> getUsbDeviceListInternal() {
        List<UsbDevice> list;
        Object object = this.mUsbMonitor;
        if (object != null && (object = object.getDeviceList((List)new ArrayList())) != null) {
            Object devList = object;
            boolean bl = false;
            this.mCacheDeviceList.clear();
            ArrayList<String> devInfoList = new ArrayList<String>();
            Iterable $this$forEach$iv = (Iterable)devList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                UsbDevice it = (UsbDevice)element$iv;
                boolean bl2 = false;
                devInfoList.add(it.getDeviceName());
                if (!CameraUtils.INSTANCE.isUsbCamera(it) && !CameraUtils.INSTANCE.isFilterDevice(this.getContext(), it)) continue;
                Intrinsics.checkNotNull((Object)it);
                this.mCacheDeviceList.add(it);
            }
            Logger.INSTANCE.i(TAG, " find some device list, = " + devInfoList);
            list = this.mCacheDeviceList;
        } else {
            list = null;
        }
        return list;
    }

    private final void requestCameraPermission(UsbDevice device) {
        block4: {
            UsbDevice dev;
            block3: {
                Object v2;
                block2: {
                    if (this.getMRequestPermission().get()) {
                        return;
                    }
                    Iterable iterable = this.mCacheDeviceList;
                    for (Object t : iterable) {
                        UsbDevice it = (UsbDevice)t;
                        boolean bl = false;
                        UsbDevice usbDevice = device;
                        boolean bl2 = usbDevice != null ? usbDevice.getDeviceId() == it.getDeviceId() : false;
                        if (!bl2) continue;
                        v2 = t;
                        break block2;
                    }
                    v2 = null;
                }
                Object var2_8 = v2;
                dev = var2_8;
                boolean bl = false;
                if (dev != null) break block3;
                Logger.INSTANCE.e(TAG, "open camera failed, not found.");
                break block4;
            }
            this.getMRequestPermission().set(true);
            USBMonitor uSBMonitor = this.mUsbMonitor;
            if (uSBMonitor == null) break block4;
            uSBMonitor.requestPermission(dev);
        }
    }

    private static final LinkedBlockingDeque mNV21DataQueue_delegate$lambda$0() {
        return new LinkedBlockingDeque(5);
    }

    private static final AtomicBoolean mRequestPermission_delegate$lambda$1() {
        return new AtomicBoolean(false);
    }

    private static final void captureImageInternal$lambda$9(CameraUvcStrategy this$0) {
        block0: {
            ICaptureCallBack iCaptureCallBack = this$0.getMCaptureDataCb();
            if (iCaptureCallBack == null) break block0;
            iCaptureCallBack.onError("Have no storage or camera permission.");
        }
    }

    private static final void captureImageInternal$lambda$14$lambda$10(CameraUvcStrategy this$0) {
        block0: {
            ICaptureCallBack iCaptureCallBack = this$0.getMCaptureDataCb();
            if (iCaptureCallBack == null) break block0;
            iCaptureCallBack.onError("Times out or camera request is null");
        }
    }

    private static final void captureImageInternal$lambda$14$lambda$11(CameraUvcStrategy this$0) {
        block0: {
            ICaptureCallBack iCaptureCallBack = this$0.getMCaptureDataCb();
            if (iCaptureCallBack == null) break block0;
            iCaptureCallBack.onBegin();
        }
    }

    private static final void captureImageInternal$lambda$14$lambda$12(CameraUvcStrategy this$0) {
        block0: {
            ICaptureCallBack iCaptureCallBack = this$0.getMCaptureDataCb();
            if (iCaptureCallBack == null) break block0;
            iCaptureCallBack.onError("save yuv to jpeg failed.");
        }
    }

    private static final void captureImageInternal$lambda$14$lambda$13(CameraUvcStrategy this$0, String $path) {
        block0: {
            ICaptureCallBack iCaptureCallBack = this$0.getMCaptureDataCb();
            if (iCaptureCallBack == null) break block0;
            iCaptureCallBack.onComplete($path);
        }
    }

    private static final void captureImageInternal$lambda$14(CameraUvcStrategy this$0, String $savePath) {
        String string;
        String displayName;
        String string2;
        String title;
        byte[] data = this$0.getMNV21DataQueue().pollFirst(1L, TimeUnit.SECONDS);
        if (data == null || this$0.getRequest() == null) {
            this$0.getMMainHandler().post(() -> CameraUvcStrategy.captureImageInternal$lambda$14$lambda$10(this$0));
            Logger.INSTANCE.i(TAG, "captureImageInternal failed, times out.");
            return;
        }
        this$0.getMIsCapturing().set(true);
        this$0.getMMainHandler().post(() -> CameraUvcStrategy.captureImageInternal$lambda$14$lambda$11(this$0));
        String date = this$0.getMDateFormat().format(System.currentTimeMillis());
        String string3 = $savePath;
        if (string3 == null) {
            string3 = title = "IMG_JJCamera_" + date;
        }
        if ((string2 = $savePath) == null) {
            string2 = displayName = title + ".jpg";
        }
        if ((string = $savePath) == null) {
            string = this$0.getMCameraDir() + '/' + displayName;
        }
        String path = string;
        int orientation = 0;
        Location location = Utils.INSTANCE.getGpsLocation(this$0.getContext());
        CameraRequest cameraRequest = this$0.getRequest();
        Intrinsics.checkNotNull((Object)cameraRequest);
        int width = cameraRequest.getPreviewWidth();
        CameraRequest cameraRequest2 = this$0.getRequest();
        Intrinsics.checkNotNull((Object)cameraRequest2);
        int height = cameraRequest2.getPreviewHeight();
        boolean ret = MediaUtils.INSTANCE.saveYuv2Jpeg(path, data, width, height);
        if (!ret) {
            File file = new File(path);
            if (file.exists()) {
                file.delete();
            }
            this$0.getMMainHandler().post(() -> CameraUvcStrategy.captureImageInternal$lambda$14$lambda$12(this$0));
            Logger.INSTANCE.w(TAG, "save yuv to jpeg failed.");
            return;
        }
        ContentValues values = new ContentValues();
        values.put("title", title);
        values.put("_display_name", displayName);
        values.put("_data", path);
        values.put("datetaken", date);
        values.put("orientation", Integer.valueOf(orientation));
        Location location2 = location;
        values.put("longitude", location2 != null ? Double.valueOf(location2.getLongitude()) : null);
        Location location3 = location;
        values.put("latitude", location3 != null ? Double.valueOf(location3.getLatitude()) : null);
        Context context = this$0.getContext();
        if (context != null && (context = context.getContentResolver()) != null) {
            context.insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
        }
        this$0.getMMainHandler().post(() -> CameraUvcStrategy.captureImageInternal$lambda$14$lambda$13(this$0, path));
        this$0.getMIsCapturing().set(false);
        if (Utils.INSTANCE.getDebugCamera()) {
            Logger.INSTANCE.i(TAG, "captureImageInternal save path = " + path);
        }
    }

    private static final void frameCallBack$lambda$37(CameraUvcStrategy this$0, ByteBuffer frame) {
        Iterable $this$forEach$iv = this$0.getMPreviewDataCbList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ByteBuffer byteBuffer;
            IPreviewDataCallBack cb = (IPreviewDataCallBack)element$iv;
            boolean bl = false;
            if (frame == null) continue;
            ByteBuffer $this$frameCallBack_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435 = byteBuffer;
            boolean bl2 = false;
            frame.position(0);
            byte[] data = new byte[$this$frameCallBack_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435.capacity()];
            $this$frameCallBack_u24lambda_u2437_u24lambda_u2436_u24lambda_u2435.get(data);
            CameraRequest cameraRequest = this$0.getRequest();
            Intrinsics.checkNotNull((Object)cameraRequest);
            int n = cameraRequest.getPreviewWidth();
            CameraRequest cameraRequest2 = this$0.getRequest();
            Intrinsics.checkNotNull((Object)cameraRequest2);
            cb.onPreviewData(data, n, cameraRequest2.getPreviewHeight(), IPreviewDataCallBack.DataFormat.NV21);
            if (this$0.getMNV21DataQueue().size() >= 5) {
                this$0.getMNV21DataQueue().removeLast();
            }
            this$0.getMNV21DataQueue().offerFirst(data);
        }
    }

    public static final /* synthetic */ List access$getMCacheDeviceList$p(CameraUvcStrategy $this) {
        return $this.mCacheDeviceList;
    }

    public static final /* synthetic */ IDeviceConnectCallBack access$getMDevConnectCallBack$p(CameraUvcStrategy $this) {
        return $this.mDevConnectCallBack;
    }

    public static final /* synthetic */ void access$loadCameraInfoInternal(CameraUvcStrategy $this, UsbDevice dev) {
        $this.loadCameraInfoInternal(dev);
    }

    public static final /* synthetic */ void access$requestCameraPermission(CameraUvcStrategy $this, UsbDevice device) {
        $this.requestCameraPermission(device);
    }

    public static final /* synthetic */ SettableFuture access$getMDevSettableFuture$p(CameraUvcStrategy $this) {
        return $this.mDevSettableFuture;
    }

    public static final /* synthetic */ AtomicBoolean access$getMRequestPermission(CameraUvcStrategy $this) {
        return $this.getMRequestPermission();
    }

    public static final /* synthetic */ void access$setMDevSettableFuture$p(CameraUvcStrategy $this, SettableFuture settableFuture) {
        $this.mDevSettableFuture = settableFuture;
    }

    public static final /* synthetic */ void access$setMCtrlBlockSettableFuture$p(CameraUvcStrategy $this, SettableFuture settableFuture) {
        $this.mCtrlBlockSettableFuture = settableFuture;
    }

    public static final /* synthetic */ SettableFuture access$getMCtrlBlockSettableFuture$p(CameraUvcStrategy $this) {
        return $this.mCtrlBlockSettableFuture;
    }

    public static final /* synthetic */ SettableFuture access$getMConnectSettableFuture$p(CameraUvcStrategy $this) {
        return $this.mConnectSettableFuture;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jiangdg/ausbc/camera/CameraUvcStrategy$Companion;", "", "<init>", "()V", "TAG", "", "MIN_FS", "", "MAX_FS", "MAX_NV21_DATA", "CAPTURE_TIMES_OUT_SEC", "", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

