/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.camera;

import android.app.Activity;
import android.content.ContentValues;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.location.Location;
import android.provider.MediaStore;
import android.view.SurfaceHolder;
import com.jiangdg.ausbc.callback.ICaptureCallBack;
import com.jiangdg.ausbc.callback.IPreviewDataCallBack;
import com.jiangdg.ausbc.camera.ICameraStrategy;
import com.jiangdg.ausbc.camera.bean.CameraInfo;
import com.jiangdg.ausbc.camera.bean.CameraRequest;
import com.jiangdg.ausbc.camera.bean.CameraStatus;
import com.jiangdg.ausbc.camera.bean.CameraV1Info;
import com.jiangdg.ausbc.camera.bean.PreviewSize;
import com.jiangdg.ausbc.utils.Logger;
import com.jiangdg.ausbc.utils.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="Deprecated since version 3.3.0")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0007\u0018\u0000 -2\u00020\u00012\u00020\u0002:\u0001-B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\nH\u0014J\b\u0010\f\u001a\u00020\nH\u0014J\u0012\u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014J\u0012\u0010\u0010\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000fH\u0014J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0014J\u001f\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\nH\u0002J\b\u0010\u001d\u001a\u00020\nH\u0002J\b\u0010\u001e\u001a\u00020\nH\u0002J\b\u0010\u001f\u001a\u00020\nH\u0002J*\u0010 \u001a\u00020\u00182\u0010\u0010!\u001a\f\u0012\b\u0012\u00060\"R\u00020\b0\u00172\u0006\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u0014H\u0002J\u001a\u0010%\u001a\u00020\u00142\b\u0010&\u001a\u0004\u0018\u00010\u00042\u0006\u0010'\u001a\u00020(H\u0002J\u001c\u0010)\u001a\u00020\n2\b\u0010*\u001a\u0004\u0018\u00010+2\b\u0010,\u001a\u0004\u0018\u00010\bH\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/jiangdg/ausbc/camera/Camera1Strategy;", "Lcom/jiangdg/ausbc/camera/ICameraStrategy;", "Landroid/hardware/Camera$PreviewCallback;", "ctx", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "mCamera", "Landroid/hardware/Camera;", "loadCameraInfo", "", "startPreviewInternal", "stopPreviewInternal", "captureImageInternal", "savePath", "", "switchCameraInternal", "cameraId", "updateResolutionInternal", "width", "", "height", "getAllPreviewSizes", "", "Lcom/jiangdg/ausbc/camera/bean/PreviewSize;", "aspectRatio", "", "(Ljava/lang/Double;)Ljava/util/List;", "createCamera", "setParameters", "realStartPreview", "destroyCamera", "getSuitableSize", "sizeList", "Landroid/hardware/Camera$Size;", "maxWidth", "maxHeight", "getPreviewDegree", "context", "isFrontCamera", "", "onPreviewFrame", "data", "", "camera", "Companion", "libausbc_release"})
@SourceDebugExtension(value={"SMAP\nCamera1Strategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Camera1Strategy.kt\ncom/jiangdg/ausbc/camera/Camera1Strategy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,358:1\n1863#2,2:359\n1863#2,2:361\n1863#2,2:363\n1863#2,2:365\n*S KotlinDebug\n*F\n+ 1 Camera1Strategy.kt\ncom/jiangdg/ausbc/camera/Camera1Strategy\n*L\n167#1:359,2\n172#1:361,2\n302#1:363,2\n346#1:365,2\n*E\n"})
public final class Camera1Strategy
extends ICameraStrategy
implements Camera.PreviewCallback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Camera mCamera;
    @NotNull
    private static final String TAG = "CameraV1";

    public Camera1Strategy(@NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        super(ctx);
    }

    @Override
    protected void loadCameraInfo() {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        int n = Camera.getNumberOfCameras();
        for (int cameraId = 0; cameraId < n; ++cameraId) {
            CameraV1Info cameraV1Info;
            int n2;
            int n3;
            Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)cameraInfo);
            switch (cameraInfo.facing) {
                case 1: {
                    n3 = 0;
                    break;
                }
                case 0: {
                    n3 = 1;
                    break;
                }
                default: {
                    n3 = 2;
                }
            }
            int type = n2 = n3;
            boolean bl = false;
            CameraV1Info $this$loadCameraInfo_u24lambda_u241_u24lambda_u240 = cameraV1Info = new CameraV1Info(String.valueOf(cameraId));
            boolean bl2 = false;
            $this$loadCameraInfo_u24lambda_u241_u24lambda_u240.setCameraType(type);
            $this$loadCameraInfo_u24lambda_u241_u24lambda_u240.setCameraVid(cameraId + 1);
            $this$loadCameraInfo_u24lambda_u241_u24lambda_u240.setCameraPid(cameraId + 1);
            CameraV1Info info = cameraV1Info;
            Integer n4 = type;
            ((Map)this.getMCameraInfoMap()).put(n4, info);
        }
        if (Utils.INSTANCE.getDebugCamera()) {
            Logger.INSTANCE.i(TAG, "loadCameraInfo = " + this.getMCameraInfoMap());
        }
    }

    @Override
    protected void startPreviewInternal() {
        this.createCamera();
        this.setParameters();
        this.realStartPreview();
    }

    @Override
    protected void stopPreviewInternal() {
        this.destroyCamera();
    }

    @Override
    protected void captureImageInternal(@Nullable String savePath) {
        block2: {
            Camera.PictureCallback jpegDataCb = (arg_0, arg_1) -> Camera1Strategy.captureImageInternal$lambda$5(this, savePath, arg_0, arg_1);
            if (!this.hasCameraPermission() || !this.hasStoragePermission()) {
                this.getMMainHandler().post(() -> Camera1Strategy.captureImageInternal$lambda$6(this));
                Logger.INSTANCE.i(TAG, "takePictureInternal failed, has no storage/camera permission.");
                return;
            }
            if (this.getMIsCapturing().get()) {
                return;
            }
            this.getMIsCapturing().set(true);
            Camera camera = this.mCamera;
            if (camera == null) break block2;
            camera.takePicture(null, null, null, jpegDataCb);
        }
    }

    @Override
    protected void switchCameraInternal(@Nullable String cameraId) {
        block1: {
            CameraRequest cameraRequest = this.getRequest();
            if (cameraRequest == null) break block1;
            CameraRequest request = cameraRequest;
            boolean bl = false;
            request.setFrontCamera(!request.isFrontCamera());
            this.stopPreviewInternal();
            this.startPreviewInternal();
            if (Utils.INSTANCE.getDebugCamera()) {
                Logger.INSTANCE.i(TAG, "switchCameraInternal");
            }
        }
    }

    @Override
    protected void updateResolutionInternal(int width, int height) {
        block0: {
            CameraRequest cameraRequest = this.getRequest();
            if (cameraRequest == null) break block0;
            CameraRequest request = cameraRequest;
            boolean bl = false;
            request.setPreviewWidth(width);
            request.setPreviewHeight(height);
            this.stopPreviewInternal();
            this.startPreviewInternal();
        }
    }

    @Override
    @Nullable
    public List<PreviewSize> getAllPreviewSizes(@Nullable Double aspectRatio) {
        CameraRequest cameraRequest = this.getRequest();
        if (cameraRequest != null) {
            Object previewSizeList;
            CameraInfo cameraInfo;
            Object object;
            Object v1;
            List list;
            block7: {
                CameraRequest request = cameraRequest;
                boolean bl = false;
                list = new ArrayList();
                Collection<CameraInfo> collection = this.getMCameraInfoMap().values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                Iterable iterable = collection;
                for (Object object2 : iterable) {
                    CameraInfo it = (CameraInfo)object2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)request.getCameraId(), (Object)it.getCameraId())) continue;
                    v1 = object2;
                    break block7;
                }
                v1 = null;
            }
            if ((object = (cameraInfo = (CameraInfo)v1)) == null || (object = ((CameraInfo)object).getCameraPreviewSizes()) == null) {
                object = new ArrayList();
            }
            if ((previewSizeList = object).isEmpty()) {
                Object object3 = this.mCamera;
                if (object3 != null && (object3 = object3.getParameters()) != null && (object3 = object3.getSupportedPreviewSizes()) != null) {
                    Iterable $this$forEach$iv = (Iterable)object3;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Camera.Size size = (Camera.Size)element$iv;
                        boolean bl = false;
                        list.add(new PreviewSize(size.width, size.height));
                    }
                }
                previewSizeList.addAll(list);
            }
            Iterable $this$forEach$iv = (Iterable)previewSizeList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PreviewSize size = (PreviewSize)element$iv;
                boolean bl = false;
                int width = size.getWidth();
                int height = size.getHeight();
                double ratio = (double)width / (double)height;
                if (aspectRatio != null && !Intrinsics.areEqual((double)ratio, (Double)aspectRatio)) continue;
                list.add(size);
            }
            Logger.INSTANCE.i(TAG, "getAllPreviewSizes aspect ratio = " + aspectRatio + ", list= " + list);
            return list;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final void createCamera() {
        block7: {
            Camera camera;
            Camera1Strategy camera1Strategy;
            CameraRequest cameraRequest = this.getRequest();
            if (cameraRequest == null) break block7;
            CameraRequest request = cameraRequest;
            boolean bl = false;
            if (!this.hasCameraPermission()) {
                Logger.INSTANCE.i(TAG, "openCamera failed, has no camera permission.");
                this.postCameraStatus(new CameraStatus(-1, "no permission"));
                return;
            }
            this.stopPreviewInternal();
            Camera1Strategy camera1Strategy2 = this;
            try {
                Camera camera2;
                camera1Strategy = camera1Strategy2;
                if (request.isFrontCamera()) {
                    CameraInfo cameraInfo = this.getMCameraInfoMap().get(0);
                    Intrinsics.checkNotNull((Object)cameraInfo);
                    String cameraId = cameraInfo.getCameraId();
                    camera2 = Camera.open((int)Integer.parseInt(cameraId));
                } else {
                    camera2 = Camera.open();
                }
                camera = camera2;
            }
            catch (Exception exception) {
                void e;
                camera1Strategy = camera1Strategy2;
                Logger.INSTANCE.e(TAG, "open camera failed, err = " + e.getLocalizedMessage(), (Throwable)e);
                this.postCameraStatus(new CameraStatus(-1, e.getLocalizedMessage()));
                camera = null;
            }
            Camera camera3 = camera;
            if (camera3 == null) {
                return;
            }
            camera1Strategy.mCamera = camera3;
            ICameraStrategy.getAllPreviewSizes$default(this, null, 1, null);
            if (Utils.INSTANCE.getDebugCamera()) {
                Logger.INSTANCE.i(TAG, "createCamera id = " + request.getCameraId() + ", front camera = " + request.isFrontCamera());
            }
        }
    }

    private final void setParameters() {
        try {
            CameraRequest cameraRequest = this.getRequest();
            if (cameraRequest != null) {
                Camera camera;
                Camera camera2;
                CameraRequest request = cameraRequest;
                boolean bl = false;
                Camera camera3 = this.mCamera;
                if (camera3 != null && (camera3 = camera3.getParameters()) != null) {
                    Camera camera4;
                    Camera $this$setParameters_u24lambda_u2416_u24lambda_u2414 = camera4 = camera3;
                    boolean bl2 = false;
                    List list = $this$setParameters_u24lambda_u2416_u24lambda_u2414.getSupportedPreviewSizes();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSupportedPreviewSizes(...)");
                    PreviewSize suitablePreviewSize = this.getSuitableSize(list, request.getPreviewWidth(), request.getPreviewHeight());
                    int width = suitablePreviewSize.getWidth();
                    int height = suitablePreviewSize.getHeight();
                    $this$setParameters_u24lambda_u2416_u24lambda_u2414.setPreviewFormat(17);
                    $this$setParameters_u24lambda_u2416_u24lambda_u2414.setPictureFormat(256);
                    if ($this$setParameters_u24lambda_u2416_u24lambda_u2414.getSupportedFocusModes().contains("continuous-picture")) {
                        $this$setParameters_u24lambda_u2416_u24lambda_u2414.setFocusMode("continuous-picture");
                    }
                    $this$setParameters_u24lambda_u2416_u24lambda_u2414.setPreviewSize(width, height);
                    $this$setParameters_u24lambda_u2416_u24lambda_u2414.set("orientation", "portrait");
                    $this$setParameters_u24lambda_u2416_u24lambda_u2414.set("rotation", 90);
                    request.setPreviewWidth(width);
                    request.setPreviewHeight(height);
                    camera2 = camera4;
                } else {
                    camera2 = null;
                }
                Camera it = camera = camera2;
                boolean bl3 = false;
                Camera camera5 = this.mCamera;
                if (camera5 != null) {
                    camera5.setParameters(it);
                }
            }
        }
        catch (Exception e) {
            Logger.INSTANCE.e(TAG, "open camera failed, err = " + e.getLocalizedMessage(), e);
            this.getMIsPreviewing().set(false);
            Camera camera = this.mCamera;
            if (camera != null) {
                camera.setPreviewCallbackWithBuffer(null);
            }
            Camera camera6 = this.mCamera;
            if (camera6 != null) {
                camera6.addCallbackBuffer(null);
            }
            Camera camera7 = this.mCamera;
            if (camera7 != null) {
                camera7.release();
            }
            this.mCamera = null;
            this.postCameraStatus(new CameraStatus(-1, e.getLocalizedMessage()));
            return;
        }
    }

    private final void realStartPreview() {
        SurfaceTexture st = this.getSurfaceTexture();
        SurfaceHolder holder = this.getSurfaceHolder();
        if (st == null && holder == null) {
            this.postCameraStatus(new CameraStatus(-1, "surface is null"));
            Logger.INSTANCE.e(TAG, "realStartPreview failed, SurfaceTexture or SurfaceHolder cannot be null.");
            return;
        }
        try {
            CameraRequest cameraRequest = this.getRequest();
            if (cameraRequest != null) {
                CameraRequest request = cameraRequest;
                boolean bl = false;
                int width = request.getPreviewWidth();
                int height = request.getPreviewHeight();
                Camera camera = this.mCamera;
                if (camera != null) {
                    CameraRequest cameraRequest2 = this.getRequest();
                    camera.setDisplayOrientation(this.getPreviewDegree(this.getContext(), cameraRequest2 != null ? cameraRequest2.isFrontCamera() : false));
                }
                Camera camera2 = this.mCamera;
                if (camera2 != null) {
                    camera2.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
                }
                Camera camera3 = this.mCamera;
                if (camera3 != null) {
                    camera3.addCallbackBuffer(new byte[width * height * 3 / 2]);
                }
                if (st != null) {
                    Camera camera4 = this.mCamera;
                    if (camera4 != null) {
                        camera4.setPreviewTexture(st);
                    }
                } else {
                    Camera camera5 = this.mCamera;
                    if (camera5 != null) {
                        camera5.setPreviewDisplay(holder);
                    }
                }
                Camera camera6 = this.mCamera;
                if (camera6 != null) {
                    camera6.startPreview();
                }
                this.getMIsPreviewing().set(true);
                this.postCameraStatus(new CameraStatus(1, new Pair((Object)width, (Object)height).toString()));
                if (Utils.INSTANCE.getDebugCamera()) {
                    Logger.INSTANCE.i(TAG, "realStartPreview width =" + width + ", height=" + height);
                }
            }
        }
        catch (Exception e) {
            this.postCameraStatus(new CameraStatus(-1, e.getLocalizedMessage()));
        }
    }

    private final void destroyCamera() {
        if (!this.getMIsPreviewing().get()) {
            return;
        }
        this.getMIsPreviewing().set(false);
        Camera camera = this.mCamera;
        if (camera != null) {
            camera.setPreviewCallbackWithBuffer(null);
        }
        Camera camera2 = this.mCamera;
        if (camera2 != null) {
            camera2.addCallbackBuffer(null);
        }
        Camera camera3 = this.mCamera;
        if (camera3 != null) {
            camera3.stopPreview();
        }
        Camera camera4 = this.mCamera;
        if (camera4 != null) {
            camera4.release();
        }
        this.mCamera = null;
        this.postCameraStatus(new CameraStatus(2, null, 2, null));
        if (Utils.INSTANCE.getDebugCamera()) {
            Logger.INSTANCE.i(TAG, "destroyCamera");
        }
    }

    private final PreviewSize getSuitableSize(List<Camera.Size> sizeList, int maxWidth, int maxHeight) {
        float aspectRatio = (float)maxWidth / (float)maxHeight;
        Iterable $this$forEach$iv = sizeList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Camera.Size size = (Camera.Size)element$iv;
            boolean bl = false;
            int w = size.width;
            int h = size.height;
            float ratio = (float)w / (float)h;
            if (!(ratio == aspectRatio) || w > maxWidth || h > maxHeight) continue;
            return new PreviewSize(w, h);
        }
        return sizeList.isEmpty() ? new PreviewSize(maxWidth, maxHeight) : new PreviewSize(sizeList.get((int)0).width, sizeList.get((int)0).height);
    }

    private final int getPreviewDegree(Context context, boolean isFrontCamera) {
        int n;
        int n2;
        if (!(context instanceof Activity)) {
            return 90;
        }
        switch (((Activity)context).getWindowManager().getDefaultDisplay().getRotation()) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 90;
                break;
            }
            case 2: {
                n2 = 180;
                break;
            }
            case 3: {
                n2 = 270;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        int degree = n2;
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        if (isFrontCamera) {
            Camera.getCameraInfo((int)1, (Camera.CameraInfo)cameraInfo);
            n = (360 - (cameraInfo.orientation - degree) % 360) % 360;
        } else {
            Camera.getCameraInfo((int)0, (Camera.CameraInfo)cameraInfo);
            n = (cameraInfo.orientation - degree + 360) % 360;
        }
        return n;
    }

    public void onPreviewFrame(@Nullable byte[] data, @Nullable Camera camera) {
        byte[] byArray = data;
        if (data == null) {
            return;
        }
        if (this.getRequest() == null) {
            return;
        }
        try {
            CameraRequest cameraRequest = this.getRequest();
            Intrinsics.checkNotNull((Object)cameraRequest);
            int n = cameraRequest.getPreviewWidth();
            CameraRequest cameraRequest2 = this.getRequest();
            Intrinsics.checkNotNull((Object)cameraRequest2);
            int frameSize = n * cameraRequest2.getPreviewHeight() * 3 / 2;
            if (data.length != frameSize) {
                return;
            }
            Iterable $this$forEach$iv = this.getMPreviewDataCbList();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IPreviewDataCallBack cb = (IPreviewDataCallBack)element$iv;
                boolean bl = false;
                CameraRequest cameraRequest3 = this.getRequest();
                Intrinsics.checkNotNull((Object)cameraRequest3);
                int n2 = cameraRequest3.getPreviewWidth();
                CameraRequest cameraRequest4 = this.getRequest();
                Intrinsics.checkNotNull((Object)cameraRequest4);
                cb.onPreviewData(data, n2, cameraRequest4.getPreviewHeight(), IPreviewDataCallBack.DataFormat.NV21);
            }
            Camera camera2 = this.mCamera;
            if (camera2 != null) {
                camera2.addCallbackBuffer(data);
            }
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    private static final void captureImageInternal$lambda$5$lambda$4$lambda$2(Camera1Strategy this$0) {
        block0: {
            ICaptureCallBack iCaptureCallBack = this$0.getMCaptureDataCb();
            if (iCaptureCallBack == null) break block0;
            iCaptureCallBack.onBegin();
        }
    }

    private static final void captureImageInternal$lambda$5$lambda$4$lambda$3(Camera1Strategy this$0, String $path) {
        block0: {
            ICaptureCallBack iCaptureCallBack = this$0.getMCaptureDataCb();
            if (iCaptureCallBack == null) break block0;
            iCaptureCallBack.onComplete($path);
        }
    }

    private static final void captureImageInternal$lambda$5$lambda$4(Camera1Strategy this$0, String $savePath, byte[] $data) {
        String string;
        String displayName;
        String string2;
        String title;
        this$0.getMMainHandler().post(() -> Camera1Strategy.captureImageInternal$lambda$5$lambda$4$lambda$2(this$0));
        String date = this$0.getMDateFormat().format(System.currentTimeMillis());
        String string3 = $savePath;
        if (string3 == null) {
            string3 = title = "IMG_JJCamera_" + date;
        }
        if ((string2 = $savePath) == null) {
            string2 = displayName = title + ".jpg";
        }
        if ((string = $savePath) == null) {
            string = this$0.getMCameraDir() + '/' + displayName;
        }
        String path = string;
        CameraRequest cameraRequest = this$0.getRequest();
        Integer width = cameraRequest != null ? Integer.valueOf(cameraRequest.getPreviewWidth()) : null;
        CameraRequest cameraRequest2 = this$0.getRequest();
        Integer height = cameraRequest2 != null ? Integer.valueOf(cameraRequest2.getPreviewHeight()) : null;
        int orientation = 0;
        Location location = Utils.INSTANCE.getGpsLocation(this$0.getContext());
        File file = new File(path);
        Intrinsics.checkNotNull((Object)$data);
        FilesKt.writeBytes((File)file, (byte[])$data);
        ContentValues values = new ContentValues();
        values.put("title", title);
        values.put("_display_name", displayName);
        values.put("_data", path);
        values.put("datetaken", date);
        values.put("width", width);
        values.put("height", height);
        values.put("orientation", Integer.valueOf(orientation));
        Location location2 = location;
        values.put("longitude", location2 != null ? Double.valueOf(location2.getLongitude()) : null);
        Location location3 = location;
        values.put("latitude", location3 != null ? Double.valueOf(location3.getLatitude()) : null);
        Context context = this$0.getContext();
        if (context != null && (context = context.getContentResolver()) != null) {
            context.insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
        }
        this$0.getMMainHandler().post(() -> Camera1Strategy.captureImageInternal$lambda$5$lambda$4$lambda$3(this$0, path));
        this$0.stopPreviewInternal();
        this$0.startPreviewInternal();
        this$0.realStartPreview();
        this$0.getMIsCapturing().set(false);
        if (Utils.INSTANCE.getDebugCamera()) {
            Logger.INSTANCE.i(TAG, "takePictureInternal save path = " + path);
        }
    }

    private static final void captureImageInternal$lambda$5(Camera1Strategy this$0, String $savePath, byte[] data, Camera camera) {
        this$0.getMSaveImageExecutor().submit(() -> Camera1Strategy.captureImageInternal$lambda$5$lambda$4(this$0, $savePath, data));
    }

    private static final void captureImageInternal$lambda$6(Camera1Strategy this$0) {
        block0: {
            ICaptureCallBack iCaptureCallBack = this$0.getMCaptureDataCb();
            if (iCaptureCallBack == null) break block0;
            iCaptureCallBack.onError("Have no storage or camera permission.");
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jiangdg/ausbc/camera/Camera1Strategy$Companion;", "", "<init>", "()V", "TAG", "", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

