/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.Looper;
import android.view.Surface;
import androidx.annotation.MainThread;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.jiangdg.ausbc.CameraClient;
import com.jiangdg.ausbc.callback.ICaptureCallBack;
import com.jiangdg.ausbc.callback.IEncodeDataCallBack;
import com.jiangdg.ausbc.callback.IPlayCallBack;
import com.jiangdg.ausbc.callback.IPreviewDataCallBack;
import com.jiangdg.ausbc.camera.CameraUvcStrategy;
import com.jiangdg.ausbc.camera.ICameraStrategy;
import com.jiangdg.ausbc.camera.bean.CameraRequest;
import com.jiangdg.ausbc.camera.bean.CameraStatus;
import com.jiangdg.ausbc.camera.bean.PreviewSize;
import com.jiangdg.ausbc.encode.AACEncodeProcessor;
import com.jiangdg.ausbc.encode.AbstractProcessor;
import com.jiangdg.ausbc.encode.H264EncodeProcessor;
import com.jiangdg.ausbc.encode.audio.AudioStrategySystem;
import com.jiangdg.ausbc.encode.bean.RawData;
import com.jiangdg.ausbc.encode.muxer.Mp4Muxer;
import com.jiangdg.ausbc.render.RenderManager;
import com.jiangdg.ausbc.render.effect.AbstractEffect;
import com.jiangdg.ausbc.render.env.RotateType;
import com.jiangdg.ausbc.utils.CameraUtils;
import com.jiangdg.ausbc.utils.Logger;
import com.jiangdg.ausbc.utils.Utils;
import com.jiangdg.ausbc.utils.bus.EventBus;
import com.jiangdg.ausbc.widget.AspectRatioSurfaceView;
import com.jiangdg.ausbc.widget.AspectRatioTextureView;
import com.jiangdg.ausbc.widget.IAspectRatio;
import com.jiangdg.usb.USBMonitor;
import com.jiangdg.uvc.UVCCamera;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="Deprecated since version 3.3.0")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0011\b\u0007\u0018\u0000 d2\u00020\u0001:\u0002deB\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J*\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020*H\u0016J\u001a\u0010+\u001a\u00020#2\b\u0010,\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010-\u001a\u00020\tJ\u0006\u0010.\u001a\u00020#J\u0010\u0010/\u001a\u00020#2\b\u00100\u001a\u0004\u0018\u00010\u0014J\u0016\u00101\u001a\u00020#2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'J\u000e\u00102\u001a\u00020#2\u0006\u00103\u001a\u00020\u0012J\u000e\u00104\u001a\u00020#2\u0006\u00103\u001a\u00020\u0012J\u0018\u00105\u001a\u00020#2\u0006\u00106\u001a\u00020'2\b\u00103\u001a\u0004\u0018\u00010\u0012J\u0012\u00107\u001a\u00020#2\n\b\u0002\u00108\u001a\u0004\u0018\u000109J\u001a\u0010:\u001a\u00020#2\u0006\u0010;\u001a\u00020<2\n\b\u0002\u0010=\u001a\u0004\u0018\u000109J\r\u0010>\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010?J\u0010\u0010@\u001a\u00020#2\b\u0010;\u001a\u0004\u0018\u00010AJ\u0006\u0010B\u001a\u00020#J\u0006\u0010C\u001a\u00020#J\u001a\u0010D\u001a\u00020#2\u0006\u0010;\u001a\u00020<2\n\b\u0002\u0010E\u001a\u0004\u0018\u000109J\u0006\u0010F\u001a\u00020#J\u0006\u0010G\u001a\u00020#J\u000e\u0010H\u001a\u00020#2\u0006\u0010;\u001a\u00020IJ\u000e\u0010J\u001a\u00020#2\u0006\u0010;\u001a\u00020\u0001J\u000e\u0010K\u001a\u00020#2\u0006\u0010;\u001a\u00020\u0001J$\u0010L\u001a\u00020#2\u0006\u0010;\u001a\u00020<2\n\b\u0002\u0010=\u001a\u0004\u0018\u0001092\b\b\u0002\u0010M\u001a\u00020NJ\u0006\u0010O\u001a\u00020#J\u0018\u0010P\u001a\u00020\t2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0007J\u001f\u0010Q\u001a\n\u0012\u0004\u0012\u00020S\u0018\u00010R2\n\b\u0002\u0010T\u001a\u0004\u0018\u00010U\u00a2\u0006\u0002\u0010VJ\b\u0010W\u001a\u0004\u0018\u00010\u0010J\b\u0010X\u001a\u0004\u0018\u00010\fJ\b\u0010Y\u001a\u0004\u0018\u00010\u0012J\u0015\u0010Z\u001a\u0004\u0018\u00010'2\u0006\u0010[\u001a\u00020'\u00a2\u0006\u0002\u0010\\J\b\u0010]\u001a\u00020#H\u0002J\b\u0010^\u001a\u00020#H\u0002J\u0010\u0010_\u001a\u00020#2\u0006\u0010`\u001a\u00020\u0007H\u0002J\u001a\u0010a\u001a\u0004\u0018\u00010S2\u0006\u0010b\u001a\u00020'2\u0006\u0010c\u001a\u00020'H\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u001c\u001a\u0004\u0018\u00010\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006f"}, d2={"Lcom/jiangdg/ausbc/CameraClient;", "Lcom/jiangdg/ausbc/callback/IPreviewDataCallBack;", "builder", "Lcom/jiangdg/ausbc/CameraClient$Builder;", "<init>", "(Lcom/jiangdg/ausbc/CameraClient$Builder;)V", "mCtx", "Landroid/content/Context;", "isEnableGLEs", "", "rawImage", "mCamera", "Lcom/jiangdg/ausbc/camera/ICameraStrategy;", "mCameraView", "Lcom/jiangdg/ausbc/widget/IAspectRatio;", "mRequest", "Lcom/jiangdg/ausbc/camera/bean/CameraRequest;", "mDefaultEffect", "Lcom/jiangdg/ausbc/render/effect/AbstractEffect;", "mDefaultRotateType", "Lcom/jiangdg/ausbc/render/env/RotateType;", "mAudioProcess", "Lcom/jiangdg/ausbc/encode/AbstractProcessor;", "mVideoProcess", "mMediaMuxer", "Lcom/jiangdg/ausbc/encode/muxer/Mp4Muxer;", "mMainHandler", "Landroid/os/Handler;", "mRenderManager", "Lcom/jiangdg/ausbc/render/RenderManager;", "getMRenderManager", "()Lcom/jiangdg/ausbc/render/RenderManager;", "mRenderManager$delegate", "Lkotlin/Lazy;", "onPreviewData", "", "data", "", "width", "", "height", "format", "Lcom/jiangdg/ausbc/callback/IPreviewDataCallBack$DataFormat;", "openCamera", "cameraView", "isReboot", "closeCamera", "setRotateType", "type", "setRenderSize", "addRenderEffect", "effect", "removeRenderEffect", "updateRenderEffect", "classifyId", "switchCamera", "cameraId", "", "captureImage", "callBack", "Lcom/jiangdg/ausbc/callback/ICaptureCallBack;", "path", "isCameraOpened", "()Ljava/lang/Boolean;", "startPlayMic", "Lcom/jiangdg/ausbc/callback/IPlayCallBack;", "stopPlayMic", "startPush", "captureAudioStart", "mp3Path", "captureAudioStop", "stopPush", "addEncodeDataCallBack", "Lcom/jiangdg/ausbc/callback/IEncodeDataCallBack;", "addPreviewDataCallBack", "removePreviewDataCallBack", "captureVideoStart", "durationInSec", "", "captureVideoStop", "updateResolution", "getAllPreviewSizes", "", "Lcom/jiangdg/ausbc/camera/bean/PreviewSize;", "aspectRatio", "", "(Ljava/lang/Double;)Ljava/util/List;", "getCameraRequest", "getCameraStrategy", "getDefaultEffect", "sendCameraCommand", "command", "(I)Ljava/lang/Integer;", "initEncodeProcessor", "releaseEncodeProcessor", "addLifecycleObserver", "context", "getSuitableSize", "maxWidth", "maxHeight", "Companion", "Builder", "libausbc_release"})
@SourceDebugExtension(value={"SMAP\nCameraClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CameraClient.kt\ncom/jiangdg/ausbc/CameraClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,739:1\n1863#2,2:740\n1863#2,2:742\n1863#2,2:744\n*S KotlinDebug\n*F\n+ 1 CameraClient.kt\ncom/jiangdg/ausbc/CameraClient\n*L\n186#1:740,2\n589#1:742,2\n201#1:744,2\n*E\n"})
public final class CameraClient
implements IPreviewDataCallBack {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Context mCtx;
    private final boolean isEnableGLEs;
    private final boolean rawImage;
    @Nullable
    private final ICameraStrategy mCamera;
    @Nullable
    private IAspectRatio mCameraView;
    @Nullable
    private CameraRequest mRequest;
    @Nullable
    private AbstractEffect mDefaultEffect;
    @Nullable
    private final RotateType mDefaultRotateType;
    @Nullable
    private AbstractProcessor mAudioProcess;
    @Nullable
    private AbstractProcessor mVideoProcess;
    @Nullable
    private Mp4Muxer mMediaMuxer;
    @NotNull
    private final Handler mMainHandler;
    @NotNull
    private final Lazy mRenderManager$delegate;
    @NotNull
    private static final String TAG = "CameraClient";

    public CameraClient(@NotNull Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.mCtx = builder.getContext$libausbc_release();
        this.isEnableGLEs = builder.getEnableGLEs$libausbc_release();
        this.rawImage = builder.getRawImage$libausbc_release();
        this.mCamera = builder.getCamera$libausbc_release();
        this.mRequest = builder.getCameraRequest$libausbc_release();
        this.mDefaultEffect = builder.getDefaultEffect$libausbc_release();
        this.mDefaultRotateType = builder.getDefaultRotateType$libausbc_release();
        this.mMainHandler = new Handler(Looper.getMainLooper());
        this.mRenderManager$delegate = LazyKt.lazy(() -> CameraClient.mRenderManager_delegate$lambda$0(this));
        CameraRequest cameraRequest = this.mRequest;
        if (cameraRequest == null) {
            cameraRequest = new CameraRequest.Builder().create();
        }
        this.mRequest = cameraRequest;
        Context context = this.mCtx;
        if (context != null) {
            Context context2 = context;
            boolean bl = false;
            if (!(context2 instanceof LifecycleOwner)) {
                throw new IllegalArgumentException("context should be subclass of LifecycleOwner!");
            }
            this.addLifecycleObserver(context2);
            EventBus.INSTANCE.with("camera-status").observe((LifecycleOwner)context2, arg_0 -> CameraClient.lambda$6$lambda$5(arg_0 -> CameraClient.lambda$6$lambda$4(this, arg_0), arg_0));
        }
        if (Utils.INSTANCE.getDebugCamera()) {
            Logger.INSTANCE.i(TAG, "init camera client, camera = " + this.mCamera);
        }
    }

    private final RenderManager getMRenderManager() {
        Lazy lazy = this.mRenderManager$delegate;
        return (RenderManager)lazy.getValue();
    }

    @Override
    public void onPreviewData(@Nullable byte[] data, int width, int height, @NotNull IPreviewDataCallBack.DataFormat format) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
            if (data == null) break block2;
            byte[] it = data;
            boolean bl = false;
            if (data.length != width * height * 3 / 2) {
                return;
            }
            AbstractProcessor abstractProcessor = this.mVideoProcess;
            if (abstractProcessor != null) {
                abstractProcessor.putRawData(new RawData(it, it.length));
            }
        }
    }

    public final void openCamera(@Nullable IAspectRatio cameraView, boolean isReboot) {
        IAspectRatio iAspectRatio;
        IAspectRatio iAspectRatio2;
        if (this.mCtx != null && Utils.INSTANCE.isTargetSdkOverP(this.mCtx) && !CameraUtils.INSTANCE.hasCameraPermission(this.mCtx)) {
            Logger.INSTANCE.e(TAG, "open camera failed, need Manifest.permission.CAMERA permission");
            return;
        }
        this.initEncodeProcessor();
        Logger.INSTANCE.i(TAG, "start open camera request = " + this.mRequest + ", gl = " + this.isEnableGLEs);
        CameraRequest cameraRequest = this.mRequest;
        Intrinsics.checkNotNull((Object)cameraRequest);
        int previewWidth = cameraRequest.getPreviewWidth();
        CameraRequest cameraRequest2 = this.mRequest;
        Intrinsics.checkNotNull((Object)cameraRequest2);
        int previewHeight = cameraRequest2.getPreviewHeight();
        IAspectRatio iAspectRatio3 = cameraView;
        if (iAspectRatio3 instanceof AspectRatioSurfaceView) {
            if (!this.isEnableGLEs) {
                ((AspectRatioSurfaceView)cameraView).postUITask((Function0<Unit>)((Function0)() -> CameraClient.openCamera$lambda$8(this, cameraView)));
            }
            ((AspectRatioSurfaceView)cameraView).setAspectRatio(previewWidth, previewHeight);
            iAspectRatio2 = cameraView;
        } else if (iAspectRatio3 instanceof AspectRatioTextureView) {
            if (!this.isEnableGLEs) {
                ((AspectRatioTextureView)cameraView).postUITask((Function0<Unit>)((Function0)() -> CameraClient.openCamera$lambda$9(this, cameraView)));
            }
            ((AspectRatioTextureView)cameraView).setAspectRatio(previewWidth, previewHeight);
            iAspectRatio2 = cameraView;
        } else {
            iAspectRatio2 = cameraView;
        }
        IAspectRatio view = iAspectRatio3 = iAspectRatio2;
        boolean bl = false;
        IAspectRatio iAspectRatio4 = view;
        if (iAspectRatio4 == null) {
            iAspectRatio4 = this.mCameraView = this.mCameraView;
        }
        if (!this.isEnableGLEs) {
            return;
        }
        IAspectRatio $this$openCamera_u24lambda_u2414_u24lambda_u2413 = iAspectRatio = view;
        boolean bl2 = false;
        RenderManager.CameraSurfaceTextureListener listener2 = new RenderManager.CameraSurfaceTextureListener(this){
            final /* synthetic */ CameraClient this$0;
            {
                this.this$0 = $receiver;
            }

            public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture) {
                block2: {
                    SurfaceTexture surfaceTexture2 = surfaceTexture;
                    if (surfaceTexture2 == null) break block2;
                    SurfaceTexture surfaceTexture3 = surfaceTexture2;
                    CameraClient cameraClient = this.this$0;
                    SurfaceTexture it = surfaceTexture3;
                    boolean bl = false;
                    ICameraStrategy iCameraStrategy = CameraClient.access$getMCamera$p(cameraClient);
                    if (iCameraStrategy != null) {
                        CameraRequest cameraRequest = CameraClient.access$getMRequest$p(cameraClient);
                        Intrinsics.checkNotNull((Object)cameraRequest);
                        iCameraStrategy.startPreview(cameraRequest, it);
                    }
                    ICameraStrategy iCameraStrategy2 = CameraClient.access$getMCamera$p(cameraClient);
                    if (iCameraStrategy2 != null) {
                        iCameraStrategy2.addPreviewDataCallBack(cameraClient);
                    }
                }
            }
        };
        if ($this$openCamera_u24lambda_u2414_u24lambda_u2413 == null) {
            Logger.INSTANCE.i(TAG, "Offscreen render, width=" + previewWidth + ", height=" + previewHeight);
            RenderManager renderManager = this.getMRenderManager();
            if (renderManager != null) {
                renderManager.startRenderScreen(previewWidth, previewHeight, null, listener2);
            }
            if (isReboot) {
                Object object = this.getMRenderManager();
                if (object != null && (object = ((RenderManager)object).getCacheEffectList()) != null) {
                    Iterable $this$forEach$iv = (Iterable)object;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        AbstractEffect effect = (AbstractEffect)element$iv;
                        boolean bl3 = false;
                        RenderManager renderManager2 = this.getMRenderManager();
                        if (renderManager2 != null) {
                            renderManager2.addRenderEffect(effect);
                        }
                    }
                }
            } else {
                RenderManager renderManager3 = this.getMRenderManager();
                if (renderManager3 != null) {
                    renderManager3.addRenderEffect(this.mDefaultEffect);
                }
            }
        } else {
            $this$openCamera_u24lambda_u2414_u24lambda_u2413.postUITask((Function0<Unit>)((Function0)() -> CameraClient.openCamera$lambda$14$lambda$13$lambda$12($this$openCamera_u24lambda_u2414_u24lambda_u2413, this, listener2, isReboot)));
        }
    }

    public static /* synthetic */ void openCamera$default(CameraClient cameraClient, IAspectRatio iAspectRatio, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        cameraClient.openCamera(iAspectRatio, bl);
    }

    public final void closeCamera() {
        block3: {
            if (Utils.INSTANCE.getDebugCamera()) {
                Logger.INSTANCE.i(TAG, "closeCamera...");
            }
            this.releaseEncodeProcessor();
            if (this.isEnableGLEs) {
                RenderManager renderManager = this.getMRenderManager();
                if (renderManager != null) {
                    renderManager.stopRenderScreen();
                }
            }
            ICameraStrategy iCameraStrategy = this.mCamera;
            if (iCameraStrategy == null) break block3;
            iCameraStrategy.stopPreview();
        }
    }

    public final void setRotateType(@Nullable RotateType type) {
        block0: {
            RenderManager renderManager = this.getMRenderManager();
            if (renderManager == null) break block0;
            renderManager.setRotateType(type);
        }
    }

    public final void setRenderSize(int width, int height) {
        block0: {
            RenderManager renderManager = this.getMRenderManager();
            if (renderManager == null) break block0;
            renderManager.setRenderSize(width, height);
        }
    }

    public final void addRenderEffect(@NotNull AbstractEffect effect) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
            RenderManager renderManager = this.getMRenderManager();
            if (renderManager == null) break block0;
            renderManager.addRenderEffect(effect);
        }
    }

    public final void removeRenderEffect(@NotNull AbstractEffect effect) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
            RenderManager renderManager = this.getMRenderManager();
            if (renderManager == null) break block0;
            renderManager.removeRenderEffect(effect);
        }
    }

    public final void updateRenderEffect(int classifyId, @Nullable AbstractEffect effect) {
        ArrayList<AbstractEffect> arrayList;
        RenderManager renderManager = this.getMRenderManager();
        if (renderManager != null && (arrayList = renderManager.getCacheEffectList()) != null) {
            Object v0;
            block4: {
                Iterable iterable = arrayList;
                for (Object t : iterable) {
                    AbstractEffect it = (AbstractEffect)t;
                    boolean bl = false;
                    if (!(it.getClassifyId() == classifyId)) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            AbstractEffect abstractEffect = v0;
            if (abstractEffect != null) {
                AbstractEffect abstractEffect2;
                AbstractEffect it = abstractEffect2 = abstractEffect;
                boolean bl = false;
                this.removeRenderEffect(it);
            }
        }
        if (effect == null) {
            return;
        }
        this.addRenderEffect(effect);
    }

    public final void switchCamera(@Nullable String cameraId) {
        block1: {
            if (Utils.INSTANCE.getDebugCamera()) {
                Logger.INSTANCE.i(TAG, "switchCamera, id = " + cameraId);
            }
            ICameraStrategy iCameraStrategy = this.mCamera;
            if (iCameraStrategy == null) break block1;
            iCameraStrategy.switchCamera(cameraId);
        }
    }

    public static /* synthetic */ void switchCamera$default(CameraClient cameraClient, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        cameraClient.switchCamera(string);
    }

    public final void captureImage(@NotNull ICaptureCallBack callBack, @Nullable String path) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
            if (Utils.INSTANCE.getDebugCamera()) {
                Logger.INSTANCE.i(TAG, "captureImage...");
            }
            if (this.isEnableGLEs && !this.rawImage) {
                RenderManager renderManager = this.getMRenderManager();
                if (renderManager != null) {
                    renderManager.saveImage(callBack, path);
                }
                return;
            }
            ICameraStrategy iCameraStrategy = this.mCamera;
            if (iCameraStrategy == null) break block3;
            iCameraStrategy.captureImage(callBack, path);
        }
    }

    public static /* synthetic */ void captureImage$default(CameraClient cameraClient, ICaptureCallBack iCaptureCallBack, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        cameraClient.captureImage(iCaptureCallBack, string);
    }

    @Nullable
    public final Boolean isCameraOpened() {
        ICameraStrategy iCameraStrategy = this.mCamera;
        return iCameraStrategy != null ? Boolean.valueOf(iCameraStrategy.isCameraOpened()) : null;
    }

    public final void startPlayMic(@Nullable IPlayCallBack callBack) {
        block0: {
            AbstractProcessor abstractProcessor = this.mAudioProcess;
            AACEncodeProcessor aACEncodeProcessor = abstractProcessor instanceof AACEncodeProcessor ? (AACEncodeProcessor)abstractProcessor : null;
            if (aACEncodeProcessor == null) break block0;
            aACEncodeProcessor.playAudioStart(callBack);
        }
    }

    public final void stopPlayMic() {
        block0: {
            AbstractProcessor abstractProcessor = this.mAudioProcess;
            AACEncodeProcessor aACEncodeProcessor = abstractProcessor instanceof AACEncodeProcessor ? (AACEncodeProcessor)abstractProcessor : null;
            if (aACEncodeProcessor == null) break block0;
            aACEncodeProcessor.playAudioStop();
        }
    }

    public final void startPush() {
        block1: {
            AbstractProcessor abstractProcessor = this.mVideoProcess;
            if (abstractProcessor != null) {
                abstractProcessor.startEncode();
            }
            AbstractProcessor abstractProcessor2 = this.mAudioProcess;
            if (abstractProcessor2 == null) break block1;
            abstractProcessor2.startEncode();
        }
    }

    public final void captureAudioStart(@NotNull ICaptureCallBack callBack, @Nullable String mp3Path) {
        block0: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
            CharSequence charSequence = mp3Path;
            String path = charSequence == null || charSequence.length() == 0 ? ((object = this.mCtx) != null && (object = object.getExternalFilesDir(null)) != null ? ((File)object).getPath() : null) + '/' + System.currentTimeMillis() + ".mp3" : mp3Path;
            AbstractProcessor abstractProcessor = this.mAudioProcess;
            AACEncodeProcessor aACEncodeProcessor = abstractProcessor instanceof AACEncodeProcessor ? (AACEncodeProcessor)abstractProcessor : null;
            if (aACEncodeProcessor == null) break block0;
            aACEncodeProcessor.recordMp3Start(path, callBack);
        }
    }

    public static /* synthetic */ void captureAudioStart$default(CameraClient cameraClient, ICaptureCallBack iCaptureCallBack, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        cameraClient.captureAudioStart(iCaptureCallBack, string);
    }

    public final void captureAudioStop() {
        block0: {
            AbstractProcessor abstractProcessor = this.mAudioProcess;
            AACEncodeProcessor aACEncodeProcessor = abstractProcessor instanceof AACEncodeProcessor ? (AACEncodeProcessor)abstractProcessor : null;
            if (aACEncodeProcessor == null) break block0;
            aACEncodeProcessor.recordMp3Stop();
        }
    }

    public final void stopPush() {
        block1: {
            AbstractProcessor abstractProcessor = this.mVideoProcess;
            if (abstractProcessor != null) {
                abstractProcessor.stopEncode();
            }
            AbstractProcessor abstractProcessor2 = this.mAudioProcess;
            if (abstractProcessor2 == null) break block1;
            abstractProcessor2.stopEncode();
        }
    }

    public final void addEncodeDataCallBack(@NotNull IEncodeDataCallBack callBack) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
            AbstractProcessor abstractProcessor = this.mVideoProcess;
            if (abstractProcessor != null) {
                abstractProcessor.setEncodeDataCallBack(callBack);
            }
            AbstractProcessor abstractProcessor2 = this.mAudioProcess;
            if (abstractProcessor2 == null) break block1;
            abstractProcessor2.setEncodeDataCallBack(callBack);
        }
    }

    public final void addPreviewDataCallBack(@NotNull IPreviewDataCallBack callBack) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
            ICameraStrategy iCameraStrategy = this.mCamera;
            if (iCameraStrategy == null) break block0;
            iCameraStrategy.addPreviewDataCallBack(callBack);
        }
    }

    public final void removePreviewDataCallBack(@NotNull IPreviewDataCallBack callBack) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
            ICameraStrategy iCameraStrategy = this.mCamera;
            if (iCameraStrategy == null) break block0;
            iCameraStrategy.removePreviewDataCallBack(callBack);
        }
    }

    public final void captureVideoStart(@NotNull ICaptureCallBack callBack, @Nullable String path, long durationInSec) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
            this.mMediaMuxer = new Mp4Muxer(this.mCtx, callBack, path, durationInSec, false, 16, null);
            AbstractProcessor abstractProcessor = this.mVideoProcess;
            H264EncodeProcessor h264EncodeProcessor = abstractProcessor instanceof H264EncodeProcessor ? (H264EncodeProcessor)abstractProcessor : null;
            if (h264EncodeProcessor != null) {
                AbstractProcessor $this$captureVideoStart_u24lambda_u2417 = abstractProcessor = h264EncodeProcessor;
                boolean bl = false;
                $this$captureVideoStart_u24lambda_u2417.startEncode();
                Mp4Muxer mp4Muxer = this.mMediaMuxer;
                Intrinsics.checkNotNull((Object)mp4Muxer);
                $this$captureVideoStart_u24lambda_u2417.setMp4Muxer(mp4Muxer);
                ((H264EncodeProcessor)$this$captureVideoStart_u24lambda_u2417).setOnEncodeReadyListener(new H264EncodeProcessor.OnEncodeReadyListener(this, (H264EncodeProcessor)$this$captureVideoStart_u24lambda_u2417){
                    final /* synthetic */ CameraClient this$0;
                    final /* synthetic */ H264EncodeProcessor $this_apply;
                    {
                        this.this$0 = $receiver;
                        this.$this_apply = $receiver2;
                    }

                    public void onReady(Surface surface) {
                        block2: {
                            if (!CameraClient.access$isEnableGLEs$p(this.this$0)) {
                                return;
                            }
                            if (surface == null) {
                                Logger.INSTANCE.e("CameraClient", "Input surface can't be null.");
                                return;
                            }
                            RenderManager renderManager = CameraClient.access$getMRenderManager(this.this$0);
                            if (renderManager == null) break block2;
                            renderManager.startRenderCodec(surface, this.$this_apply.getWidth(), this.$this_apply.getHeight());
                        }
                    }
                });
            }
            abstractProcessor = this.mAudioProcess;
            AACEncodeProcessor aACEncodeProcessor = abstractProcessor instanceof AACEncodeProcessor ? (AACEncodeProcessor)abstractProcessor : null;
            if (aACEncodeProcessor == null) break block1;
            AbstractProcessor $this$captureVideoStart_u24lambda_u2418 = abstractProcessor = aACEncodeProcessor;
            boolean bl = false;
            $this$captureVideoStart_u24lambda_u2418.startEncode();
            Mp4Muxer mp4Muxer = this.mMediaMuxer;
            Intrinsics.checkNotNull((Object)mp4Muxer);
            $this$captureVideoStart_u24lambda_u2418.setMp4Muxer(mp4Muxer);
        }
    }

    public static /* synthetic */ void captureVideoStart$default(CameraClient cameraClient, ICaptureCallBack iCaptureCallBack, String string, long l, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            l = 0L;
        }
        cameraClient.captureVideoStart(iCaptureCallBack, string, l);
    }

    public final void captureVideoStop() {
        RenderManager renderManager = this.getMRenderManager();
        if (renderManager != null) {
            renderManager.stopRenderCodec();
        }
        Mp4Muxer mp4Muxer = this.mMediaMuxer;
        if (mp4Muxer != null) {
            mp4Muxer.release();
        }
        AbstractProcessor abstractProcessor = this.mVideoProcess;
        if (abstractProcessor != null) {
            abstractProcessor.stopEncode();
        }
        AbstractProcessor abstractProcessor2 = this.mAudioProcess;
        if (abstractProcessor2 != null) {
            abstractProcessor2.stopEncode();
        }
        this.mMediaMuxer = null;
    }

    @MainThread
    public final boolean updateResolution(int width, int height) {
        CameraRequest cameraRequest;
        if (Utils.INSTANCE.getDebugCamera()) {
            Logger.INSTANCE.i(TAG, "updateResolution size = " + width + 'x' + height);
        }
        CameraRequest $this$updateResolution_u24lambda_u2420 = cameraRequest = this.getCameraRequest();
        boolean bl = false;
        if ($this$updateResolution_u24lambda_u2420 == null) {
            Logger.INSTANCE.e(TAG, "updateResolution failed, camera request is null.");
            return false;
        }
        AbstractProcessor abstractProcessor = this.mVideoProcess;
        boolean bl2 = abstractProcessor != null ? abstractProcessor.isEncoding() : false;
        if (bl2) {
            Logger.INSTANCE.e(TAG, "updateResolution failed, video recording...");
            return false;
        }
        $this$updateResolution_u24lambda_u2420.setPreviewWidth(width);
        $this$updateResolution_u24lambda_u2420.setPreviewHeight(height);
        this.closeCamera();
        this.mMainHandler.postDelayed(() -> CameraClient.updateResolution$lambda$20$lambda$19(this), 500L);
        return true;
    }

    @Nullable
    public final List<PreviewSize> getAllPreviewSizes(@Nullable Double aspectRatio) {
        ICameraStrategy iCameraStrategy = this.mCamera;
        return iCameraStrategy != null ? iCameraStrategy.getAllPreviewSizes(aspectRatio) : null;
    }

    public static /* synthetic */ List getAllPreviewSizes$default(CameraClient cameraClient, Double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = null;
        }
        return cameraClient.getAllPreviewSizes(d);
    }

    @Nullable
    public final CameraRequest getCameraRequest() {
        return this.mRequest;
    }

    @Nullable
    public final ICameraStrategy getCameraStrategy() {
        return this.mCamera;
    }

    @Nullable
    public final AbstractEffect getDefaultEffect() {
        return this.mDefaultEffect;
    }

    @Nullable
    public final Integer sendCameraCommand(int command) {
        if (!(this.mCamera instanceof CameraUvcStrategy)) {
            return null;
        }
        return ((CameraUvcStrategy)this.mCamera).sendCameraCommand(command);
    }

    private final void initEncodeProcessor() {
        int n;
        int encodeWidth;
        int n2;
        this.releaseEncodeProcessor();
        if (this.isEnableGLEs) {
            CameraRequest cameraRequest = this.mRequest;
            Intrinsics.checkNotNull((Object)cameraRequest);
            n2 = cameraRequest.getPreviewHeight();
        } else {
            CameraRequest cameraRequest = this.mRequest;
            Intrinsics.checkNotNull((Object)cameraRequest);
            n2 = encodeWidth = cameraRequest.getPreviewWidth();
        }
        if (this.isEnableGLEs) {
            CameraRequest cameraRequest = this.mRequest;
            Intrinsics.checkNotNull((Object)cameraRequest);
            n = cameraRequest.getPreviewWidth();
        } else {
            CameraRequest cameraRequest = this.mRequest;
            Intrinsics.checkNotNull((Object)cameraRequest);
            n = cameraRequest.getPreviewHeight();
        }
        int encodeHeight = n;
        this.mAudioProcess = new AACEncodeProcessor(new AudioStrategySystem());
        this.mVideoProcess = new H264EncodeProcessor(encodeWidth, encodeHeight, this.isEnableGLEs, false, 8, null);
    }

    private final void releaseEncodeProcessor() {
        AbstractProcessor abstractProcessor = this.mAudioProcess;
        AACEncodeProcessor aACEncodeProcessor = abstractProcessor instanceof AACEncodeProcessor ? (AACEncodeProcessor)abstractProcessor : null;
        if (aACEncodeProcessor != null) {
            aACEncodeProcessor.playAudioStop();
        }
        AbstractProcessor abstractProcessor2 = this.mVideoProcess;
        if (abstractProcessor2 != null) {
            abstractProcessor2.stopEncode();
        }
        AbstractProcessor abstractProcessor3 = this.mAudioProcess;
        if (abstractProcessor3 != null) {
            abstractProcessor3.stopEncode();
        }
        this.mVideoProcess = null;
        this.mAudioProcess = null;
    }

    private final void addLifecycleObserver(Context context) {
        Intrinsics.checkNotNull((Object)context, (String)"null cannot be cast to non-null type androidx.lifecycle.LifecycleOwner");
        ((LifecycleOwner)context).getLifecycle().addObserver((LifecycleObserver)new LifecycleEventObserver(this){
            final /* synthetic */ CameraClient this$0;
            {
                this.this$0 = $receiver;
            }

            public void onStateChanged(LifecycleOwner source, Lifecycle.Event event) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (addLifecycleObserver.WhenMappings.$EnumSwitchMapping$0[event.ordinal()] == 1) {
                    this.this$0.captureVideoStop();
                    this.this$0.closeCamera();
                }
            }
        });
    }

    private final PreviewSize getSuitableSize(int maxWidth, int maxHeight) {
        PreviewSize closetSize;
        block11: {
            PreviewSize previewSize;
            PreviewSize previewSize2;
            PreviewSize previewSize3;
            PreviewSize it;
            List sizeList;
            List list = sizeList = CameraClient.getAllPreviewSizes$default(this, null, 1, null);
            if (list != null) {
                Object v1;
                block9: {
                    Iterable iterable = list;
                    for (Object object : iterable) {
                        it = (PreviewSize)object;
                        boolean bl = false;
                        if (!(it.getWidth() == maxWidth && it.getHeight() == maxHeight)) continue;
                        v1 = object;
                        break block9;
                    }
                    v1 = null;
                }
                previewSize3 = v1;
            } else {
                previewSize3 = null;
            }
            PreviewSize size = previewSize2 = previewSize3;
            boolean bl2 = false;
            if (size != null) {
                return size;
            }
            float aspectRatio = (float)maxWidth / (float)maxHeight;
            List list2 = sizeList;
            if (list2 != null) {
                PreviewSize previewSize4;
                block10: {
                    Object object;
                    Iterable bl2 = list2;
                    object = bl2.iterator();
                    while (object.hasNext()) {
                        int h;
                        PreviewSize it2 = it = object.next();
                        boolean bl3 = false;
                        int w = it2.getWidth();
                        float ratio = (float)w / (float)(h = it2.getHeight());
                        if (!(ratio == aspectRatio && w <= maxWidth && h <= maxHeight)) continue;
                        previewSize4 = it;
                        break block10;
                    }
                    previewSize4 = null;
                }
                previewSize = previewSize4;
            } else {
                previewSize = null;
            }
            PreviewSize size2 = size = previewSize;
            boolean bl4 = false;
            if (size2 != null) {
                return size2;
            }
            int minDistance = 0;
            minDistance = maxWidth;
            closetSize = null;
            List list3 = sizeList;
            if (list3 == null) break block11;
            Iterable $this$forEach$iv = list3;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PreviewSize size3 = (PreviewSize)element$iv;
                boolean bl5 = false;
                if (minDistance < Math.abs(maxWidth - size3.getWidth())) continue;
                minDistance = Math.abs(maxWidth - size3.getWidth());
                closetSize = size3;
            }
        }
        return closetSize;
    }

    private static final RenderManager mRenderManager_delegate$lambda$0(CameraClient this$0) {
        Context context = this$0.mCtx;
        Intrinsics.checkNotNull((Object)context);
        CameraRequest cameraRequest = this$0.mRequest;
        Intrinsics.checkNotNull((Object)cameraRequest);
        int n = cameraRequest.getPreviewWidth();
        CameraRequest cameraRequest2 = this$0.mRequest;
        Intrinsics.checkNotNull((Object)cameraRequest2);
        return new RenderManager(context, n, cameraRequest2.getPreviewHeight(), null);
    }

    private static final Unit lambda$6$lambda$4(CameraClient this$0, CameraStatus status) {
        switch (status.getCode()) {
            case -1: {
                ICameraStrategy iCameraStrategy = this$0.mCamera;
                if (iCameraStrategy != null) {
                    iCameraStrategy.stopPreview();
                }
                break;
            }
            case -2: {
                CameraRequest cameraRequest = this$0.mRequest;
                if (cameraRequest != null) {
                    PreviewSize previewSize;
                    CameraRequest request = cameraRequest;
                    boolean bl = false;
                    int oldPreviewWidth = request.getPreviewWidth();
                    int oldPreviewHeight = request.getPreviewHeight();
                    PreviewSize it = this$0.getSuitableSize(oldPreviewWidth, oldPreviewHeight);
                    boolean bl2 = false;
                    PreviewSize previewSize2 = it;
                    if (previewSize2 == null) {
                        return Unit.INSTANCE;
                    }
                    it = previewSize = previewSize2;
                    boolean bl3 = false;
                    Logger.INSTANCE.i(TAG, "Automatically select the appropriate resolution (" + it.getWidth() + 'x' + it.getHeight() + ')');
                    this$0.updateResolution(it.getWidth(), it.getHeight());
                }
                break;
            }
        }
        return Unit.INSTANCE;
    }

    private static final void lambda$6$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit openCamera$lambda$8(CameraClient this$0, IAspectRatio $cameraView) {
        block1: {
            ICameraStrategy iCameraStrategy = this$0.mCamera;
            if (iCameraStrategy != null) {
                CameraRequest cameraRequest = this$0.mRequest;
                Intrinsics.checkNotNull((Object)cameraRequest);
                iCameraStrategy.startPreview(cameraRequest, ((AspectRatioSurfaceView)$cameraView).getHolder());
            }
            ICameraStrategy iCameraStrategy2 = this$0.mCamera;
            if (iCameraStrategy2 == null) break block1;
            iCameraStrategy2.addPreviewDataCallBack(this$0);
        }
        return Unit.INSTANCE;
    }

    private static final Unit openCamera$lambda$9(CameraClient this$0, IAspectRatio $cameraView) {
        block1: {
            ICameraStrategy iCameraStrategy = this$0.mCamera;
            if (iCameraStrategy != null) {
                CameraRequest cameraRequest = this$0.mRequest;
                Intrinsics.checkNotNull((Object)cameraRequest);
                iCameraStrategy.startPreview(cameraRequest, ((AspectRatioTextureView)$cameraView).getSurfaceTexture());
            }
            ICameraStrategy iCameraStrategy2 = this$0.mCamera;
            if (iCameraStrategy2 == null) break block1;
            iCameraStrategy2.addPreviewDataCallBack(this$0);
        }
        return Unit.INSTANCE;
    }

    private static final Unit openCamera$lambda$14$lambda$13$lambda$12(IAspectRatio $this_apply, CameraClient this$0, openCamera.3.1.listener.1 $listener, boolean $isReboot) {
        int surfaceWidth = $this_apply.getSurfaceWidth();
        int surfaceHeight = $this_apply.getSurfaceHeight();
        Surface surface = $this_apply.getSurface();
        RenderManager renderManager = this$0.getMRenderManager();
        if (renderManager != null) {
            renderManager.startRenderScreen(surfaceWidth, surfaceHeight, surface, $listener);
        }
        RenderManager renderManager2 = this$0.getMRenderManager();
        if (renderManager2 != null) {
            renderManager2.setRotateType(this$0.mDefaultRotateType);
        }
        if ($isReboot) {
            Object object = this$0.getMRenderManager();
            if (object != null && (object = ((RenderManager)object).getCacheEffectList()) != null) {
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    AbstractEffect effect = (AbstractEffect)element$iv;
                    boolean bl = false;
                    RenderManager renderManager3 = this$0.getMRenderManager();
                    if (renderManager3 == null) continue;
                    renderManager3.addRenderEffect(effect);
                }
            }
            return Unit.INSTANCE;
        }
        RenderManager renderManager4 = this$0.getMRenderManager();
        if (renderManager4 != null) {
            renderManager4.addRenderEffect(this$0.mDefaultEffect);
        }
        Logger.INSTANCE.i(TAG, "Display render, width=" + surfaceWidth + ", height=" + surfaceHeight);
        return Unit.INSTANCE;
    }

    private static final void updateResolution$lambda$20$lambda$19(CameraClient this$0) {
        this$0.openCamera(this$0.mCameraView, true);
    }

    @JvmStatic
    @NotNull
    public static final Builder newBuilder(@NotNull Context ctx) {
        return Companion.newBuilder(ctx);
    }

    public static final /* synthetic */ ICameraStrategy access$getMCamera$p(CameraClient $this) {
        return $this.mCamera;
    }

    public static final /* synthetic */ CameraRequest access$getMRequest$p(CameraClient $this) {
        return $this.mRequest;
    }

    public static final /* synthetic */ boolean access$isEnableGLEs$p(CameraClient $this) {
        return $this.isEnableGLEs;
    }

    public static final /* synthetic */ RenderManager access$getMRenderManager(CameraClient $this) {
        return $this.getMRenderManager();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006J\u0010\u00105\u001a\u00020\u00002\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u000e\u00106\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u000bJ\u000e\u00108\u001a\u00020\u00002\u0006\u00109\u001a\u00020\u0011J\u000e\u0010:\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0011J\u000e\u0010;\u001a\u00020\u00002\u0006\u0010<\u001a\u00020 J\u0010\u0010=\u001a\u00020\u00002\u0006\u0010>\u001a\u00020&H\u0007J\u0010\u0010?\u001a\u00020\u00002\u0006\u0010@\u001a\u00020&H\u0007J\u000e\u0010A\u001a\u00020\u00002\u0006\u0010B\u001a\u00020\u0011J\u0010\u0010C\u001a\u00020\u00002\b\u0010D\u001a\u0004\u0018\u000100J\b\u0010E\u001a\u00020FH\u0016J\u0006\u0010G\u001a\u00020HR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0006R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001e\u0010%\u001a\u0004\u0018\u00010&X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010+\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001e\u0010,\u001a\u0004\u0018\u00010&X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010+\u001a\u0004\b-\u0010(\"\u0004\b.\u0010*R\u001c\u0010/\u001a\u0004\u0018\u000100X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104\u00a8\u0006I"}, d2={"Lcom/jiangdg/ausbc/CameraClient$Builder;", "", "<init>", "()V", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext$libausbc_release", "()Landroid/content/Context;", "setContext$libausbc_release", "cameraRequest", "Lcom/jiangdg/ausbc/camera/bean/CameraRequest;", "getCameraRequest$libausbc_release", "()Lcom/jiangdg/ausbc/camera/bean/CameraRequest;", "setCameraRequest$libausbc_release", "(Lcom/jiangdg/ausbc/camera/bean/CameraRequest;)V", "enableGLEs", "", "getEnableGLEs$libausbc_release", "()Z", "setEnableGLEs$libausbc_release", "(Z)V", "rawImage", "getRawImage$libausbc_release", "setRawImage$libausbc_release", "camera", "Lcom/jiangdg/ausbc/camera/ICameraStrategy;", "getCamera$libausbc_release", "()Lcom/jiangdg/ausbc/camera/ICameraStrategy;", "setCamera$libausbc_release", "(Lcom/jiangdg/ausbc/camera/ICameraStrategy;)V", "defaultEffect", "Lcom/jiangdg/ausbc/render/effect/AbstractEffect;", "getDefaultEffect$libausbc_release", "()Lcom/jiangdg/ausbc/render/effect/AbstractEffect;", "setDefaultEffect$libausbc_release", "(Lcom/jiangdg/ausbc/render/effect/AbstractEffect;)V", "videoEncodeBitRate", "", "getVideoEncodeBitRate$libausbc_release", "()Ljava/lang/Integer;", "setVideoEncodeBitRate$libausbc_release", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "videoEncodeFrameRate", "getVideoEncodeFrameRate$libausbc_release", "setVideoEncodeFrameRate$libausbc_release", "defaultRotateType", "Lcom/jiangdg/ausbc/render/env/RotateType;", "getDefaultRotateType$libausbc_release", "()Lcom/jiangdg/ausbc/render/env/RotateType;", "setDefaultRotateType$libausbc_release", "(Lcom/jiangdg/ausbc/render/env/RotateType;)V", "setCameraStrategy", "setCameraRequest", "request", "setEnableGLES", "enable", "setRawImage", "setDefaultEffect", "effect", "setVideoEncodeBitRate", "bitRate", "setVideoEncodeFrameRate", "frameRate", "openDebug", "debug", "setDefaultRotateType", "type", "toString", "", "build", "Lcom/jiangdg/ausbc/CameraClient;", "libausbc_release"})
    public static final class Builder {
        @Nullable
        private Context context;
        @Nullable
        private CameraRequest cameraRequest;
        private boolean enableGLEs;
        private boolean rawImage;
        @Nullable
        private ICameraStrategy camera;
        @Nullable
        private AbstractEffect defaultEffect;
        @Nullable
        private Integer videoEncodeBitRate;
        @Nullable
        private Integer videoEncodeFrameRate;
        @Nullable
        private RotateType defaultRotateType;

        public Builder() {
            this.enableGLEs = true;
            this.rawImage = true;
        }

        @Nullable
        public final Context getContext$libausbc_release() {
            return this.context;
        }

        public final void setContext$libausbc_release(@Nullable Context context) {
            this.context = context;
        }

        @Nullable
        public final CameraRequest getCameraRequest$libausbc_release() {
            return this.cameraRequest;
        }

        public final void setCameraRequest$libausbc_release(@Nullable CameraRequest cameraRequest) {
            this.cameraRequest = cameraRequest;
        }

        public final boolean getEnableGLEs$libausbc_release() {
            return this.enableGLEs;
        }

        public final void setEnableGLEs$libausbc_release(boolean bl) {
            this.enableGLEs = bl;
        }

        public final boolean getRawImage$libausbc_release() {
            return this.rawImage;
        }

        public final void setRawImage$libausbc_release(boolean bl) {
            this.rawImage = bl;
        }

        @Nullable
        public final ICameraStrategy getCamera$libausbc_release() {
            return this.camera;
        }

        public final void setCamera$libausbc_release(@Nullable ICameraStrategy iCameraStrategy) {
            this.camera = iCameraStrategy;
        }

        @Nullable
        public final AbstractEffect getDefaultEffect$libausbc_release() {
            return this.defaultEffect;
        }

        public final void setDefaultEffect$libausbc_release(@Nullable AbstractEffect abstractEffect) {
            this.defaultEffect = abstractEffect;
        }

        @Nullable
        public final Integer getVideoEncodeBitRate$libausbc_release() {
            return this.videoEncodeBitRate;
        }

        public final void setVideoEncodeBitRate$libausbc_release(@Nullable Integer n) {
            this.videoEncodeBitRate = n;
        }

        @Nullable
        public final Integer getVideoEncodeFrameRate$libausbc_release() {
            return this.videoEncodeFrameRate;
        }

        public final void setVideoEncodeFrameRate$libausbc_release(@Nullable Integer n) {
            this.videoEncodeFrameRate = n;
        }

        @Nullable
        public final RotateType getDefaultRotateType$libausbc_release() {
            return this.defaultRotateType;
        }

        public final void setDefaultRotateType$libausbc_release(@Nullable RotateType rotateType) {
            this.defaultRotateType = rotateType;
        }

        public Builder(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this();
            this.context = context;
        }

        @NotNull
        public final Builder setCameraStrategy(@Nullable ICameraStrategy camera) {
            this.camera = camera;
            return this;
        }

        @NotNull
        public final Builder setCameraRequest(@NotNull CameraRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            this.cameraRequest = request;
            return this;
        }

        @NotNull
        public final Builder setEnableGLES(boolean enable) {
            this.enableGLEs = enable;
            return this;
        }

        @NotNull
        public final Builder setRawImage(boolean rawImage) {
            this.rawImage = rawImage;
            return this;
        }

        @NotNull
        public final Builder setDefaultEffect(@NotNull AbstractEffect effect) {
            Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
            this.defaultEffect = effect;
            return this;
        }

        @Deprecated(message="Not realized")
        @NotNull
        public final Builder setVideoEncodeBitRate(int bitRate) {
            this.videoEncodeBitRate = bitRate;
            return this;
        }

        @Deprecated(message="Not realized")
        @NotNull
        public final Builder setVideoEncodeFrameRate(int frameRate) {
            this.videoEncodeFrameRate = frameRate;
            return this;
        }

        @NotNull
        public final Builder openDebug(boolean debug) {
            UVCCamera.DEBUG = debug;
            USBMonitor.DEBUG = debug;
            Utils.INSTANCE.setDebugCamera(debug);
            return this;
        }

        @NotNull
        public final Builder setDefaultRotateType(@Nullable RotateType type) {
            this.defaultRotateType = type;
            return this;
        }

        @NotNull
        public String toString() {
            return "Builder(context=" + this.context + ", cameraType=" + this.camera + ", cameraRequest=" + this.cameraRequest + ", glEsVersion=" + this.enableGLEs + ')';
        }

        @NotNull
        public final CameraClient build() {
            return new CameraClient(this);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jiangdg/ausbc/CameraClient$Companion;", "", "<init>", "()V", "TAG", "", "newBuilder", "Lcom/jiangdg/ausbc/CameraClient$Builder;", "ctx", "Landroid/content/Context;", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Builder newBuilder(@NotNull Context ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            return new Builder(ctx);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

