/*
 * Decompiled with CFR 0.152.
 */
package cn.pedant.SweetAlert;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.util.AttributeSet;
import android.util.Xml;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.RotateAnimation;
import android.view.animation.ScaleAnimation;
import android.view.animation.TranslateAnimation;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class OptAnimationLoader {
    public static Animation loadAnimation(Context context, int id) throws Resources.NotFoundException {
        try (XmlResourceParser parser = null;){
            parser = context.getResources().getAnimation(id);
            Animation animation = OptAnimationLoader.createAnimationFromXml(context, (XmlPullParser)parser);
            return animation;
        }
    }

    private static Animation createAnimationFromXml(Context c, XmlPullParser parser) throws XmlPullParserException, IOException {
        return OptAnimationLoader.createAnimationFromXml(c, parser, null, Xml.asAttributeSet((XmlPullParser)parser));
    }

    private static Animation createAnimationFromXml(Context c, XmlPullParser parser, AnimationSet parent, AttributeSet attrs) throws XmlPullParserException, IOException {
        int type;
        AnimationSet anim = null;
        int depth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            String name;
            if (type != 2) continue;
            switch (name = parser.getName()) {
                case "set": {
                    anim = new AnimationSet(c, attrs);
                    OptAnimationLoader.createAnimationFromXml(c, parser, anim, attrs);
                    break;
                }
                case "alpha": {
                    anim = new AlphaAnimation(c, attrs);
                    break;
                }
                case "scale": {
                    anim = new ScaleAnimation(c, attrs);
                    break;
                }
                case "rotate": {
                    anim = new RotateAnimation(c, attrs);
                    break;
                }
                case "translate": {
                    anim = new TranslateAnimation(c, attrs);
                    break;
                }
                default: {
                    try {
                        anim = (Animation)Class.forName(name).getConstructor(Context.class, AttributeSet.class).newInstance(c, attrs);
                        break;
                    }
                    catch (Exception te) {
                        throw new RuntimeException("Unknown animation name: " + parser.getName() + " error:" + te.getMessage());
                    }
                }
            }
            if (parent == null) continue;
            parent.addAnimation((Animation)anim);
        }
        return anim;
    }
}

