/*
 * Decompiled with CFR 0.152.
 */
package me.ele.uetool;

import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.LinearGradient;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.NinePatchDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.graphics.drawable.VectorDrawableCompat;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v7.widget.RecyclerView;
import android.text.SpannedString;
import android.text.style.ImageSpan;
import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.ele.uetool.UETool;
import me.ele.uetool.base.Application;
import me.ele.uetool.base.ReflectionP;

public class Util {
    public static void enableFullscreen(@NonNull Window window) {
        if (Build.VERSION.SDK_INT >= 21) {
            Util.addSystemUiFlag(window, 1280);
        }
    }

    private static void addSystemUiFlag(Window window, int flag) {
        View view = window.getDecorView();
        if (view != null) {
            view.setSystemUiVisibility(view.getSystemUiVisibility() | flag);
        }
    }

    public static void setStatusBarColor(@NonNull Window window, int color) {
        if (Build.VERSION.SDK_INT >= 21) {
            window.setStatusBarColor(color);
        }
    }

    public static String getViewClickListener(final View view) {
        return (String)ReflectionP.breakAndroidP((ReflectionP.Func)new ReflectionP.Func<String>(){

            public String call() {
                try {
                    Field mListenerInfoField = View.class.getDeclaredField("mListenerInfo");
                    mListenerInfoField.setAccessible(true);
                    Field mClickListenerField = Class.forName("android.view.View$ListenerInfo").getDeclaredField("mOnClickListener");
                    mClickListenerField.setAccessible(true);
                    View.OnClickListener listener = (View.OnClickListener)mClickListenerField.get(mListenerInfoField.get(view));
                    return listener.getClass().getName();
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
    }

    public static String getResourceName(int id2) {
        Resources resources = Application.getApplicationContext().getResources();
        try {
            if (id2 == -1 || id2 == 0) {
                return "";
            }
            return resources.getResourceEntryName(id2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getViewTag(View view) {
        Object tag = view.getTag();
        return tag == null ? "" : tag.toString();
    }

    public static String getResId(View view) {
        try {
            int id2 = view.getId();
            if (id2 == -1) {
                return "";
            }
            return "0x" + Integer.toHexString(id2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String intToHexColor(int color) {
        return "#" + Integer.toHexString(color).toUpperCase();
    }

    public static Object getBackground(View view) {
        Drawable drawable2 = view.getBackground();
        if (drawable2 instanceof ColorDrawable) {
            return Util.intToHexColor(((ColorDrawable)drawable2).getColor());
        }
        if (drawable2 instanceof GradientDrawable) {
            try {
                Field mFillPaintField = GradientDrawable.class.getDeclaredField("mFillPaint");
                mFillPaintField.setAccessible(true);
                Paint mFillPaint = (Paint)mFillPaintField.get(drawable2);
                Shader shader = mFillPaint.getShader();
                if (shader instanceof LinearGradient) {
                    Field mColorsField = LinearGradient.class.getDeclaredField("mColors");
                    mColorsField.setAccessible(true);
                    int[] mColors = (int[])mColorsField.get(shader);
                    StringBuilder sb = new StringBuilder();
                    int N = mColors.length;
                    for (int i = 0; i < N; ++i) {
                        sb.append(Util.intToHexColor(mColors[i]));
                        if (i >= N - 1) continue;
                        sb.append(" -> ");
                    }
                    return sb.toString();
                }
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else {
            return Util.getDrawableBitmap(drawable2);
        }
        return null;
    }

    public static List<Pair<String, Bitmap>> getTextViewBitmap(TextView textView) {
        ArrayList<Pair<String, Bitmap>> bitmaps = new ArrayList<Pair<String, Bitmap>>();
        bitmaps.addAll(Util.getTextViewDrawableBitmap(textView));
        bitmaps.addAll(Util.getTextViewImageSpanBitmap(textView));
        return bitmaps;
    }

    private static List<Pair<String, Bitmap>> getTextViewDrawableBitmap(TextView textView) {
        ArrayList<Pair<String, Bitmap>> bitmaps = new ArrayList<Pair<String, Bitmap>>();
        try {
            Drawable[] drawables = textView.getCompoundDrawables();
            bitmaps.add((Pair<String, Bitmap>)new Pair((Object)"DrawableLeft", (Object)Util.getDrawableBitmap(drawables[0])));
            bitmaps.add((Pair<String, Bitmap>)new Pair((Object)"DrawableTop", (Object)Util.getDrawableBitmap(drawables[1])));
            bitmaps.add((Pair<String, Bitmap>)new Pair((Object)"DrawableRight", (Object)Util.getDrawableBitmap(drawables[2])));
            bitmaps.add((Pair<String, Bitmap>)new Pair((Object)"DrawableBottom", (Object)Util.getDrawableBitmap(drawables[3])));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bitmaps;
    }

    private static List<Pair<String, Bitmap>> getTextViewImageSpanBitmap(TextView textView) {
        ArrayList<Pair<String, Bitmap>> bitmaps = new ArrayList<Pair<String, Bitmap>>();
        try {
            CharSequence text = textView.getText();
            if (text instanceof SpannedString) {
                Object[] spans;
                Field mSpansField = Class.forName("android.text.SpannableStringInternal").getDeclaredField("mSpans");
                mSpansField.setAccessible(true);
                for (Object span : spans = (Object[])mSpansField.get(text)) {
                    if (!(span instanceof ImageSpan)) continue;
                    bitmaps.add((Pair<String, Bitmap>)new Pair((Object)"SpanBitmap", (Object)Util.getDrawableBitmap(((ImageSpan)span).getDrawable())));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bitmaps;
    }

    public static Bitmap getImageViewBitmap(ImageView imageView) {
        return Util.getDrawableBitmap(imageView.getDrawable());
    }

    private static Bitmap getDrawableBitmap(Drawable drawable2) {
        try {
            if (drawable2 instanceof BitmapDrawable) {
                return ((BitmapDrawable)drawable2).getBitmap();
            }
            if (drawable2 instanceof NinePatchDrawable) {
                NinePatch ninePatch = null;
                if (Build.VERSION.SDK_INT >= 24) {
                    Field mNinePatchStateFiled = NinePatchDrawable.class.getDeclaredField("mNinePatchState");
                    mNinePatchStateFiled.setAccessible(true);
                    Object mNinePatchState = mNinePatchStateFiled.get(drawable2);
                    Field mNinePatchFiled = mNinePatchState.getClass().getDeclaredField("mNinePatch");
                    mNinePatchFiled.setAccessible(true);
                    ninePatch = (NinePatch)mNinePatchFiled.get(mNinePatchState);
                    return ninePatch.getBitmap();
                }
                if (Build.VERSION.SDK_INT >= 19) {
                    Field mNinePatchFiled = NinePatchDrawable.class.getDeclaredField("mNinePatch");
                    mNinePatchFiled.setAccessible(true);
                    ninePatch = (NinePatch)mNinePatchFiled.get(drawable2);
                    return ninePatch.getBitmap();
                }
            } else if (drawable2 instanceof ClipDrawable) {
                if (Build.VERSION.SDK_INT >= 23) {
                    return ((BitmapDrawable)((ClipDrawable)drawable2).getDrawable()).getBitmap();
                }
            } else {
                if (drawable2 instanceof StateListDrawable) {
                    return ((BitmapDrawable)drawable2.getCurrent()).getBitmap();
                }
                if (drawable2 instanceof VectorDrawableCompat) {
                    Field mVectorStateField = VectorDrawableCompat.class.getDeclaredField("mVectorState");
                    mVectorStateField.setAccessible(true);
                    Field mCachedBitmapField = Class.forName("android.support.graphics.drawable.VectorDrawableCompat$VectorDrawableCompatState").getDeclaredField("mCachedBitmap");
                    mCachedBitmapField.setAccessible(true);
                    return (Bitmap)mCachedBitmapField.get(mVectorStateField.get(drawable2));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getImageViewScaleType(ImageView imageView) {
        return imageView.getScaleType().name();
    }

    public static void clipText(String clipText) {
        Context context = Application.getApplicationContext();
        ClipData clipData = ClipData.newPlainText((CharSequence)"", (CharSequence)clipText);
        ((ClipboardManager)context.getSystemService("clipboard")).setPrimaryClip(clipData);
        Toast.makeText((Context)context, (CharSequence)"copied", (int)0).show();
    }

    public static Activity getCurrentActivity() {
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            Method currentActivityThreadMethod = activityThreadClass.getMethod("currentActivityThread", new Class[0]);
            Object currentActivityThread = currentActivityThreadMethod.invoke(null, new Object[0]);
            Field mActivitiesField = activityThreadClass.getDeclaredField("mActivities");
            mActivitiesField.setAccessible(true);
            Map activities = (Map)mActivitiesField.get(currentActivityThread);
            for (Object record : activities.values()) {
                Class<?> recordClass = record.getClass();
                Field pausedField = recordClass.getDeclaredField("paused");
                pausedField.setAccessible(true);
                if (((Boolean)pausedField.get(record)).booleanValue()) continue;
                Field activityField = recordClass.getDeclaredField("activity");
                activityField.setAccessible(true);
                return (Activity)activityField.get(record);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Nullable
    public static Fragment getCurrentFragment(View targetView) {
        Activity activity = UETool.getInstance().getTargetActivity();
        if (activity instanceof FragmentActivity) {
            List<Fragment> fragments = Util.collectVisibleFragment(((FragmentActivity)activity).getSupportFragmentManager());
            for (int i = fragments.size() - 1; i >= 0; --i) {
                Fragment fragment = fragments.get(i);
                if (!Util.findTargetView(fragment.getView(), targetView)) continue;
                return fragment;
            }
        }
        return null;
    }

    private static List<Fragment> collectVisibleFragment(FragmentManager fragmentManager) {
        ArrayList<Fragment> fragments = new ArrayList<Fragment>();
        for (Fragment fragment : fragmentManager.getFragments()) {
            if (!fragment.isVisible()) continue;
            fragments.add(fragment);
            fragments.addAll(Util.collectVisibleFragment(fragment.getChildFragmentManager()));
        }
        return fragments;
    }

    @Nullable
    public static String getCurrentFragmentName(View targetView) {
        Fragment fragment = Util.getCurrentFragment(targetView);
        if (fragment != null) {
            return fragment.getClass().getName();
        }
        return null;
    }

    public static String getViewHolderName(View targetView) {
        View currentView = targetView;
        while (currentView != null) {
            ViewParent parent = currentView.getParent();
            if (parent instanceof RecyclerView) {
                return ((RecyclerView)parent).getChildViewHolder(currentView).getClass().getName();
            }
            currentView = parent instanceof View ? (View)parent : null;
        }
        return null;
    }

    private static boolean findTargetView(View view, View targetView) {
        if (view == targetView) {
            return true;
        }
        if (view instanceof ViewGroup) {
            ViewGroup parent = (ViewGroup)view;
            for (int i = 0; i < parent.getChildCount(); ++i) {
                if (!Util.findTargetView(parent.getChildAt(i), targetView)) continue;
                return true;
            }
        }
        return false;
    }
}

