/*
 * Decompiled with CFR 0.152.
 */
package me.ele.uetool;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.RectF;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.TextView;
import com.unnamed.b.atv.model.TreeNode;
import com.unnamed.b.atv.view.AndroidTreeView;
import me.ele.uetool.Provider;
import me.ele.uetool.R;
import me.ele.uetool.RegionView;
import me.ele.uetool.UETool;

public class FragmentListTreeDialog
extends Dialog
implements Provider {
    private ViewGroup containerView;
    private RegionView regionView;

    public FragmentListTreeDialog(Context context) {
        super(context);
        this.requestWindowFeature(1);
    }

    protected void onCreate(Bundle savedInstanceState) {
        this.getWindow().addFlags(Integer.MIN_VALUE);
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.uet_dialog_fragment_list_tree);
        this.containerView = (ViewGroup)this.findViewById(R.id.container);
        this.regionView = (RegionView)this.findViewById(R.id.region);
        CheckBox checkBox = (CheckBox)this.findViewById(R.id.checkbox);
        this.createTree(checkBox.isChecked());
        checkBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                FragmentListTreeDialog.this.createTree(isChecked);
            }
        });
    }

    private void createTree(boolean showPackageName) {
        TreeNode root = TreeNode.root();
        Activity activity = UETool.getInstance().getTargetActivity();
        if (activity instanceof FragmentActivity) {
            FragmentManager fragmentManager = ((FragmentActivity)activity).getSupportFragmentManager();
            this.createTreeNode(root, fragmentManager, showPackageName);
        }
        this.containerView.removeAllViews();
        AndroidTreeView tView = new AndroidTreeView(this.getContext(), root);
        tView.setDefaultAnimation(true);
        tView.setUse2dScroll(true);
        tView.setDefaultContainerStyle(R.style.uet_TreeNodeStyleCustom);
        this.containerView.addView(tView.getView());
        tView.expandAll();
    }

    private TreeNode createTreeNode(TreeNode rootNode, FragmentManager fragmentManager, boolean showPackageName) {
        for (Fragment fragment : fragmentManager.getFragments()) {
            TreeNode node = new TreeNode((Object)new TreeItem(fragment, showPackageName)).setViewHolder((TreeNode.BaseNodeViewHolder)new TreeItemVH(this.getContext(), this));
            FragmentManager childManager = fragment.getChildFragmentManager();
            rootNode.addChild(this.createTreeNode(node, childManager, showPackageName));
        }
        return rootNode;
    }

    protected void onStart() {
        super.onStart();
        this.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.getWindow().setLayout(-1, -1);
    }

    @Override
    public void onClickTreeItem(RectF rectF) {
        this.regionView.drawRegion(rectF);
    }

    public static class TreeItem {
        public String name;
        public RectF rectF;

        public TreeItem(Fragment fragment, boolean showPackageName) {
            this.initName(fragment, showPackageName);
            this.initRect(fragment);
        }

        private void initName(Fragment fragment, boolean showPackageName) {
            StringBuilder sb = new StringBuilder();
            sb.append(showPackageName ? fragment.getClass().getName() : fragment.getClass().getSimpleName());
            sb.append("[visible=").append(fragment.isVisible()).append(", hashCode=").append(fragment.hashCode()).append("]");
            this.name = sb.toString();
            if (fragment.isVisible()) {
                this.name = "<u>" + this.name + "</u>";
            }
        }

        private void initRect(Fragment fragment) {
            if (fragment.isVisible()) {
                View view = fragment.getView();
                int[] location = new int[2];
                view.getLocationOnScreen(location);
                this.rectF = new RectF((float)location[0], (float)location[1], (float)(location[0] + view.getWidth()), (float)(location[1] + view.getHeight()));
            }
        }
    }

    public static class TreeItemVH
    extends TreeNode.BaseNodeViewHolder<TreeItem> {
        private TextView nameView;
        private ImageView arrowView;
        private Provider provider;

        public TreeItemVH(Context context, Provider provider) {
            super(context);
            this.provider = provider;
        }

        public View createNodeView(TreeNode node, final TreeItem value) {
            View view = LayoutInflater.from((Context)this.context).inflate(R.layout.uet_cell_tree, null, false);
            this.nameView = (TextView)view.findViewById(R.id.name);
            this.arrowView = (ImageView)view.findViewById(R.id.arrow);
            this.nameView.setText((CharSequence)Html.fromHtml((String)value.name));
            if (value.rectF != null) {
                this.nameView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (TreeItemVH.this.provider != null) {
                            TreeItemVH.this.provider.onClickTreeItem(value.rectF);
                        }
                    }
                });
            }
            return view;
        }

        public void toggle(boolean active) {
            super.toggle(active);
            this.arrowView.animate().setDuration(200L).rotation(active ? 90.0f : 0.0f).start();
        }
    }
}

