/*
 * Decompiled with CFR 0.152.
 */
package me.ele.uetool.base;

import android.content.Context;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import me.ele.uetool.base.Application;

public class DimenUtil {
    private static final Context CONTEXT = Application.getApplicationContext();

    private DimenUtil() {
    }

    public static String px2dip(float pxValue) {
        return DimenUtil.px2dip(pxValue, false);
    }

    public static String px2dip(float pxValue, boolean withUnit) {
        float scale = DimenUtil.CONTEXT.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f) + (withUnit ? "dp" : "");
    }

    public static int dip2px(float dpValue) {
        float scale = DimenUtil.CONTEXT.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static int sp2px(float sp) {
        return (int)TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)CONTEXT.getResources().getDisplayMetrics());
    }

    public static String px2sp(float pxValue) {
        float fontScale = DimenUtil.CONTEXT.getResources().getDisplayMetrics().scaledDensity;
        return String.valueOf((int)(pxValue / fontScale + 0.5f));
    }

    public static int getScreenWidth() {
        return DimenUtil.CONTEXT.getResources().getDisplayMetrics().widthPixels;
    }

    public static int getScreenHeight() {
        return DimenUtil.CONTEXT.getResources().getDisplayMetrics().heightPixels;
    }

    public static int getStatusBarHeight() {
        Resources resources = CONTEXT.getResources();
        int resId = resources.getIdentifier("status_bar_height", "dimen", "android");
        return resId > 0 ? resources.getDimensionPixelSize(resId) : 0;
    }
}

