/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.exoplayer2.ui;

import android.graphics.Typeface;
import android.view.accessibility.CaptioningManager;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import buzz.getcoco.exoplayer2.util.Util;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class CaptionStyleCompat {
    public static final int EDGE_TYPE_NONE = 0;
    public static final int EDGE_TYPE_OUTLINE = 1;
    public static final int EDGE_TYPE_DROP_SHADOW = 2;
    public static final int EDGE_TYPE_RAISED = 3;
    public static final int EDGE_TYPE_DEPRESSED = 4;
    public static final int USE_TRACK_COLOR_SETTINGS = 1;
    public static final CaptionStyleCompat DEFAULT = new CaptionStyleCompat(-1, -16777216, 0, 0, -1, null);
    public final int foregroundColor;
    public final int backgroundColor;
    public final int windowColor;
    public final int edgeType;
    public final int edgeColor;
    @Nullable
    public final Typeface typeface;

    @RequiresApi(value=19)
    public static CaptionStyleCompat createFromCaptionStyle(CaptioningManager.CaptionStyle captionStyle) {
        if (Util.SDK_INT >= 21) {
            return CaptionStyleCompat.createFromCaptionStyleV21(captionStyle);
        }
        return CaptionStyleCompat.createFromCaptionStyleV19(captionStyle);
    }

    public CaptionStyleCompat(int foregroundColor, int backgroundColor, int windowColor, int edgeType, int edgeColor, @Nullable Typeface typeface) {
        this.foregroundColor = foregroundColor;
        this.backgroundColor = backgroundColor;
        this.windowColor = windowColor;
        this.edgeType = edgeType;
        this.edgeColor = edgeColor;
        this.typeface = typeface;
    }

    @RequiresApi(value=19)
    private static CaptionStyleCompat createFromCaptionStyleV19(CaptioningManager.CaptionStyle captionStyle) {
        return new CaptionStyleCompat(captionStyle.foregroundColor, captionStyle.backgroundColor, 0, captionStyle.edgeType, captionStyle.edgeColor, captionStyle.getTypeface());
    }

    @RequiresApi(value=21)
    private static CaptionStyleCompat createFromCaptionStyleV21(CaptioningManager.CaptionStyle captionStyle) {
        return new CaptionStyleCompat(captionStyle.hasForegroundColor() ? captionStyle.foregroundColor : CaptionStyleCompat.DEFAULT.foregroundColor, captionStyle.hasBackgroundColor() ? captionStyle.backgroundColor : CaptionStyleCompat.DEFAULT.backgroundColor, captionStyle.hasWindowColor() ? captionStyle.windowColor : CaptionStyleCompat.DEFAULT.windowColor, captionStyle.hasEdgeType() ? captionStyle.edgeType : CaptionStyleCompat.DEFAULT.edgeType, captionStyle.hasEdgeColor() ? captionStyle.edgeColor : CaptionStyleCompat.DEFAULT.edgeColor, captionStyle.getTypeface());
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EdgeType {
    }
}

