/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.exoplayer2.util;

import androidx.annotation.GuardedBy;
import buzz.getcoco.exoplayer2.util.Assertions;

public final class TimestampAdjuster {
    public static final long MODE_NO_OFFSET = Long.MAX_VALUE;
    public static final long MODE_SHARED = 0x7FFFFFFFFFFFFFFEL;
    private static final long MAX_PTS_PLUS_ONE = 0x200000000L;
    @GuardedBy(value="this")
    private long firstSampleTimestampUs;
    @GuardedBy(value="this")
    private long timestampOffsetUs;
    @GuardedBy(value="this")
    private long lastUnadjustedTimestampUs;
    private final ThreadLocal<Long> nextSampleTimestampUs = new ThreadLocal();

    public TimestampAdjuster(long firstSampleTimestampUs) {
        this.reset(firstSampleTimestampUs);
    }

    public synchronized void sharedInitializeOrWait(boolean canInitialize, long nextSampleTimestampUs) throws InterruptedException {
        Assertions.checkState(this.firstSampleTimestampUs == 0x7FFFFFFFFFFFFFFEL);
        if (this.timestampOffsetUs != -9223372036854775807L) {
            return;
        }
        if (canInitialize) {
            this.nextSampleTimestampUs.set(nextSampleTimestampUs);
        } else {
            while (this.timestampOffsetUs == -9223372036854775807L) {
                this.wait();
            }
        }
    }

    public synchronized long getFirstSampleTimestampUs() {
        return this.firstSampleTimestampUs == Long.MAX_VALUE || this.firstSampleTimestampUs == 0x7FFFFFFFFFFFFFFEL ? -9223372036854775807L : this.firstSampleTimestampUs;
    }

    public synchronized long getLastAdjustedTimestampUs() {
        return this.lastUnadjustedTimestampUs != -9223372036854775807L ? this.lastUnadjustedTimestampUs + this.timestampOffsetUs : this.getFirstSampleTimestampUs();
    }

    public synchronized long getTimestampOffsetUs() {
        return this.timestampOffsetUs;
    }

    public synchronized void reset(long firstSampleTimestampUs) {
        this.firstSampleTimestampUs = firstSampleTimestampUs;
        this.timestampOffsetUs = firstSampleTimestampUs == Long.MAX_VALUE ? 0L : -9223372036854775807L;
        this.lastUnadjustedTimestampUs = -9223372036854775807L;
    }

    public synchronized long adjustTsTimestamp(long pts90Khz) {
        if (pts90Khz == -9223372036854775807L) {
            return -9223372036854775807L;
        }
        if (this.lastUnadjustedTimestampUs != -9223372036854775807L) {
            long lastPts = TimestampAdjuster.usToNonWrappedPts(this.lastUnadjustedTimestampUs);
            long closestWrapCount = (lastPts + 0x100000000L) / 0x200000000L;
            long ptsWrapBelow = pts90Khz + 0x200000000L * (closestWrapCount - 1L);
            long ptsWrapAbove = pts90Khz + 0x200000000L * closestWrapCount;
            pts90Khz = Math.abs(ptsWrapBelow - lastPts) < Math.abs(ptsWrapAbove - lastPts) ? ptsWrapBelow : ptsWrapAbove;
        }
        return this.adjustSampleTimestamp(TimestampAdjuster.ptsToUs(pts90Khz));
    }

    public synchronized long adjustSampleTimestamp(long timeUs) {
        if (timeUs == -9223372036854775807L) {
            return -9223372036854775807L;
        }
        if (this.timestampOffsetUs == -9223372036854775807L) {
            long desiredSampleTimestampUs = this.firstSampleTimestampUs == 0x7FFFFFFFFFFFFFFEL ? Assertions.checkNotNull(this.nextSampleTimestampUs.get()) : this.firstSampleTimestampUs;
            this.timestampOffsetUs = desiredSampleTimestampUs - timeUs;
            this.notifyAll();
        }
        this.lastUnadjustedTimestampUs = timeUs;
        return timeUs + this.timestampOffsetUs;
    }

    public static long ptsToUs(long pts) {
        return pts * 1000000L / 90000L;
    }

    public static long usToWrappedPts(long us) {
        return TimestampAdjuster.usToNonWrappedPts(us) % 0x200000000L;
    }

    public static long usToNonWrappedPts(long us) {
        return us * 90000L / 1000000L;
    }
}

