/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.exoplayer2.source;

import android.os.Bundle;
import androidx.annotation.Nullable;
import buzz.getcoco.exoplayer2.Bundleable;
import buzz.getcoco.exoplayer2.Format;
import buzz.getcoco.exoplayer2.util.Assertions;
import buzz.getcoco.exoplayer2.util.BundleableUtil;
import buzz.getcoco.exoplayer2.util.Log;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;

public final class TrackGroup
implements Bundleable {
    private static final String TAG = "TrackGroup";
    public final int length;
    private final Format[] formats;
    private int hashCode;
    private static final int FIELD_FORMATS = 0;
    public static final Bundleable.Creator<TrackGroup> CREATOR = bundle -> {
        List<Format> formats = BundleableUtil.fromBundleNullableList(Format.CREATOR, bundle.getParcelableArrayList(TrackGroup.keyForField(0)), ImmutableList.of());
        return new TrackGroup(formats.toArray(new Format[0]));
    };

    public TrackGroup(Format ... formats) {
        Assertions.checkArgument(formats.length > 0);
        this.formats = formats;
        this.length = formats.length;
        this.verifyCorrectness();
    }

    public Format getFormat(int index) {
        return this.formats[index];
    }

    public int indexOf(Format format) {
        for (int i = 0; i < this.formats.length; ++i) {
            if (format != this.formats[i]) continue;
            return i;
        }
        return -1;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            this.hashCode = result = 31 * result + Arrays.hashCode(this.formats);
        }
        return this.hashCode;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TrackGroup other = (TrackGroup)obj;
        return this.length == other.length && Arrays.equals(this.formats, other.formats);
    }

    @Override
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList(TrackGroup.keyForField(0), BundleableUtil.toBundleArrayList(Lists.newArrayList((Object[])this.formats)));
        return bundle;
    }

    private static String keyForField(int field) {
        return Integer.toString(field, 36);
    }

    private void verifyCorrectness() {
        String language = TrackGroup.normalizeLanguage(this.formats[0].language);
        int roleFlags = TrackGroup.normalizeRoleFlags(this.formats[0].roleFlags);
        for (int i = 1; i < this.formats.length; ++i) {
            if (!language.equals(TrackGroup.normalizeLanguage(this.formats[i].language))) {
                TrackGroup.logErrorMessage("languages", this.formats[0].language, this.formats[i].language, i);
                return;
            }
            if (roleFlags == TrackGroup.normalizeRoleFlags(this.formats[i].roleFlags)) continue;
            TrackGroup.logErrorMessage("role flags", Integer.toBinaryString(this.formats[0].roleFlags), Integer.toBinaryString(this.formats[i].roleFlags), i);
            return;
        }
    }

    private static String normalizeLanguage(@Nullable String language) {
        return language == null || language.equals("und") ? "" : language;
    }

    private static int normalizeRoleFlags(int roleFlags) {
        return roleFlags | 0x4000;
    }

    private static void logErrorMessage(String mismatchField, @Nullable String valueIndex0, @Nullable String otherValue, int otherIndex) {
        Log.e(TAG, "", new IllegalStateException("Different " + mismatchField + " combined in one TrackGroup: '" + valueIndex0 + "' (track 0) and '" + otherValue + "' (track " + otherIndex + ")"));
    }
}

