/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.exoplayer2.audio;

import android.media.AudioAttributes;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import buzz.getcoco.exoplayer2.Bundleable;
import buzz.getcoco.exoplayer2.util.Util;

public final class AudioAttributes
implements Bundleable {
    public static final AudioAttributes DEFAULT = new Builder().build();
    public final int contentType;
    public final int flags;
    public final int usage;
    public final int allowedCapturePolicy;
    @Nullable
    private android.media.AudioAttributes audioAttributesV21;
    private static final int FIELD_CONTENT_TYPE = 0;
    private static final int FIELD_FLAGS = 1;
    private static final int FIELD_USAGE = 2;
    private static final int FIELD_ALLOWED_CAPTURE_POLICY = 3;
    public static final Bundleable.Creator<AudioAttributes> CREATOR = bundle -> {
        Builder builder = new Builder();
        if (bundle.containsKey(AudioAttributes.keyForField(0))) {
            builder.setContentType(bundle.getInt(AudioAttributes.keyForField(0)));
        }
        if (bundle.containsKey(AudioAttributes.keyForField(1))) {
            builder.setFlags(bundle.getInt(AudioAttributes.keyForField(1)));
        }
        if (bundle.containsKey(AudioAttributes.keyForField(2))) {
            builder.setUsage(bundle.getInt(AudioAttributes.keyForField(2)));
        }
        if (bundle.containsKey(AudioAttributes.keyForField(3))) {
            builder.setAllowedCapturePolicy(bundle.getInt(AudioAttributes.keyForField(3)));
        }
        return builder.build();
    };

    private AudioAttributes(int contentType, int flags, int usage, int allowedCapturePolicy) {
        this.contentType = contentType;
        this.flags = flags;
        this.usage = usage;
        this.allowedCapturePolicy = allowedCapturePolicy;
    }

    @RequiresApi(value=21)
    public android.media.AudioAttributes getAudioAttributesV21() {
        if (this.audioAttributesV21 == null) {
            AudioAttributes.Builder builder = new AudioAttributes.Builder().setContentType(this.contentType).setFlags(this.flags).setUsage(this.usage);
            if (Util.SDK_INT >= 29) {
                builder.setAllowedCapturePolicy(this.allowedCapturePolicy);
            }
            this.audioAttributesV21 = builder.build();
        }
        return this.audioAttributesV21;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AudioAttributes other = (AudioAttributes)obj;
        return this.contentType == other.contentType && this.flags == other.flags && this.usage == other.usage && this.allowedCapturePolicy == other.allowedCapturePolicy;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.contentType;
        result = 31 * result + this.flags;
        result = 31 * result + this.usage;
        result = 31 * result + this.allowedCapturePolicy;
        return result;
    }

    @Override
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putInt(AudioAttributes.keyForField(0), this.contentType);
        bundle.putInt(AudioAttributes.keyForField(1), this.flags);
        bundle.putInt(AudioAttributes.keyForField(2), this.usage);
        bundle.putInt(AudioAttributes.keyForField(3), this.allowedCapturePolicy);
        return bundle;
    }

    private static String keyForField(int field) {
        return Integer.toString(field, 36);
    }

    public static final class Builder {
        private int contentType = 0;
        private int flags = 0;
        private int usage = 1;
        private int allowedCapturePolicy = 1;

        public Builder setContentType(int contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder setFlags(int flags) {
            this.flags = flags;
            return this;
        }

        public Builder setUsage(int usage) {
            this.usage = usage;
            return this;
        }

        public Builder setAllowedCapturePolicy(int allowedCapturePolicy) {
            this.allowedCapturePolicy = allowedCapturePolicy;
            return this;
        }

        public AudioAttributes build() {
            return new AudioAttributes(this.contentType, this.flags, this.usage, this.allowedCapturePolicy);
        }
    }
}

