/*
 * Decompiled with CFR 0.152.
 */
package buzz.getcoco.exoplayer2;

import android.os.Bundle;
import androidx.annotation.Nullable;
import buzz.getcoco.exoplayer2.Bundleable;
import buzz.getcoco.exoplayer2.Rating;
import buzz.getcoco.exoplayer2.util.Assertions;
import com.google.common.base.Objects;

public final class ThumbRating
extends Rating {
    private final boolean rated;
    private final boolean isThumbsUp;
    private static final int TYPE = 3;
    private static final int FIELD_RATED = 1;
    private static final int FIELD_IS_THUMBS_UP = 2;
    public static final Bundleable.Creator<ThumbRating> CREATOR = ThumbRating::fromBundle;

    public ThumbRating() {
        this.rated = false;
        this.isThumbsUp = false;
    }

    public ThumbRating(boolean isThumbsUp) {
        this.rated = true;
        this.isThumbsUp = isThumbsUp;
    }

    @Override
    public boolean isRated() {
        return this.rated;
    }

    public boolean isThumbsUp() {
        return this.isThumbsUp;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.rated, this.isThumbsUp});
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof ThumbRating)) {
            return false;
        }
        ThumbRating other = (ThumbRating)obj;
        return this.isThumbsUp == other.isThumbsUp && this.rated == other.rated;
    }

    @Override
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putInt(ThumbRating.keyForField(0), 3);
        bundle.putBoolean(ThumbRating.keyForField(1), this.rated);
        bundle.putBoolean(ThumbRating.keyForField(2), this.isThumbsUp);
        return bundle;
    }

    private static ThumbRating fromBundle(Bundle bundle) {
        Assertions.checkArgument(bundle.getInt(ThumbRating.keyForField(0), -1) == 3);
        boolean rated = bundle.getBoolean(ThumbRating.keyForField(1), false);
        return rated ? new ThumbRating(bundle.getBoolean(ThumbRating.keyForField(2), false)) : new ThumbRating();
    }

    private static String keyForField(int field) {
        return Integer.toString(field, 36);
    }
}

