/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.NodeExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.NodeTaskExecutor;
import com.github.eirslett.maven.plugins.frontend.lib.NpmRunner;
import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class DefaultNpmRunner
extends NodeTaskExecutor
implements NpmRunner {
    static final String TASK_NAME = "npm";

    public DefaultNpmRunner(NodeExecutorConfig config, ProxyConfig proxyConfig, String npmRegistryURL) {
        super(config, TASK_NAME, config.getNpmPath().getAbsolutePath(), DefaultNpmRunner.buildArguments(proxyConfig, npmRegistryURL), DefaultNpmRunner.buildProxy(proxyConfig, npmRegistryURL));
    }

    static List<String> buildArguments(ProxyConfig proxyConfig, String npmRegistryURL) {
        ArrayList<String> arguments = new ArrayList<String>();
        if (npmRegistryURL != null && !npmRegistryURL.isEmpty()) {
            arguments.add("--registry=" + npmRegistryURL);
        }
        if (!proxyConfig.isEmpty()) {
            ProxyConfig.Proxy proxy = DefaultNpmRunner.getProxyConfig(proxyConfig, npmRegistryURL);
            arguments.add("--https-proxy=" + proxy.getUri().toString());
            arguments.add("--proxy=" + proxy.getUri().toString());
            String nonProxyHosts = proxy.getNonProxyHosts();
            if (nonProxyHosts != null && !nonProxyHosts.isEmpty()) {
                String[] nonProxyHostList;
                for (String nonProxyHost : nonProxyHostList = nonProxyHosts.split("\\|")) {
                    arguments.add("--noproxy=" + nonProxyHost.replace("*", ""));
                }
            }
        }
        return arguments;
    }

    private static Map<String, String> buildProxy(ProxyConfig proxyConfig, String npmRegistryURL) {
        Map<String, String> proxyEnvironmentVariables = Collections.emptyMap();
        if (!proxyConfig.isEmpty()) {
            ProxyConfig.Proxy proxy = DefaultNpmRunner.getProxyConfig(proxyConfig, npmRegistryURL);
            proxyEnvironmentVariables = new HashMap<String, String>();
            proxyEnvironmentVariables.put("https_proxy", proxy.getUri().toString());
            proxyEnvironmentVariables.put("http_proxy", proxy.getUri().toString());
        }
        return proxyEnvironmentVariables;
    }

    private static ProxyConfig.Proxy getProxyConfig(ProxyConfig proxyConfig, String npmRegistryURL) {
        ProxyConfig.Proxy proxy = null;
        if (npmRegistryURL != null && !npmRegistryURL.isEmpty()) {
            proxy = proxyConfig.getProxyForUrl(npmRegistryURL);
        }
        if (proxy == null) {
            proxy = proxyConfig.getSecureProxy();
        }
        if (proxy == null) {
            proxy = proxyConfig.getInsecureProxy();
        }
        return proxy;
    }
}

